/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMonitorResponse extends ForecastResponse implements
        ToCopyableBuilder<DescribeMonitorResponse.Builder, DescribeMonitorResponse> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorName").getter(getter(DescribeMonitorResponse::monitorName)).setter(setter(Builder::monitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorName").build()).build();

    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorArn").getter(getter(DescribeMonitorResponse::monitorArn)).setter(setter(Builder::monitorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(DescribeMonitorResponse::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeMonitorResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> LAST_EVALUATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastEvaluationTime").getter(getter(DescribeMonitorResponse::lastEvaluationTime))
            .setter(setter(Builder::lastEvaluationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluationTime").build())
            .build();

    private static final SdkField<String> LAST_EVALUATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastEvaluationState").getter(getter(DescribeMonitorResponse::lastEvaluationState))
            .setter(setter(Builder::lastEvaluationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluationState").build())
            .build();

    private static final SdkField<Baseline> BASELINE_FIELD = SdkField.<Baseline> builder(MarshallingType.SDK_POJO)
            .memberName("Baseline").getter(getter(DescribeMonitorResponse::baseline)).setter(setter(Builder::baseline))
            .constructor(Baseline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Baseline").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DescribeMonitorResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeMonitorResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(DescribeMonitorResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final SdkField<Long> ESTIMATED_EVALUATION_TIME_REMAINING_IN_MINUTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedEvaluationTimeRemainingInMinutes")
            .getter(getter(DescribeMonitorResponse::estimatedEvaluationTimeRemainingInMinutes))
            .setter(setter(Builder::estimatedEvaluationTimeRemainingInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EstimatedEvaluationTimeRemainingInMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD,
            MONITOR_ARN_FIELD, RESOURCE_ARN_FIELD, STATUS_FIELD, LAST_EVALUATION_TIME_FIELD, LAST_EVALUATION_STATE_FIELD,
            BASELINE_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD,
            ESTIMATED_EVALUATION_TIME_REMAINING_IN_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String monitorName;

    private final String monitorArn;

    private final String resourceArn;

    private final String status;

    private final Instant lastEvaluationTime;

    private final String lastEvaluationState;

    private final Baseline baseline;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private final Long estimatedEvaluationTimeRemainingInMinutes;

    private DescribeMonitorResponse(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.monitorArn = builder.monitorArn;
        this.resourceArn = builder.resourceArn;
        this.status = builder.status;
        this.lastEvaluationTime = builder.lastEvaluationTime;
        this.lastEvaluationState = builder.lastEvaluationState;
        this.baseline = builder.baseline;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.estimatedEvaluationTimeRemainingInMinutes = builder.estimatedEvaluationTimeRemainingInMinutes;
    }

    /**
     * <p>
     * The name of the monitor.
     * </p>
     * 
     * @return The name of the monitor.
     */
    public final String monitorName() {
        return monitorName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the monitor resource described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the monitor resource described.
     */
    public final String monitorArn() {
        return monitorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the auto predictor being monitored.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the auto predictor being monitored.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The status of the monitor resource.
     * </p>
     * 
     * @return The status of the monitor resource.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The timestamp of the latest evaluation completed by the monitor.
     * </p>
     * 
     * @return The timestamp of the latest evaluation completed by the monitor.
     */
    public final Instant lastEvaluationTime() {
        return lastEvaluationTime;
    }

    /**
     * <p>
     * The state of the monitor's latest evaluation.
     * </p>
     * 
     * @return The state of the monitor's latest evaluation.
     */
    public final String lastEvaluationState() {
        return lastEvaluationState;
    }

    /**
     * <p>
     * Metrics you can use as a baseline for comparison purposes. Use these values you interpret monitoring results for
     * an auto predictor.
     * </p>
     * 
     * @return Metrics you can use as a baseline for comparison purposes. Use these values you interpret monitoring
     *         results for an auto predictor.
     */
    public final Baseline baseline() {
        return baseline;
    }

    /**
     * <p>
     * An error message, if any, for the monitor.
     * </p>
     * 
     * @return An error message, if any, for the monitor.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The timestamp for when the monitor resource was created.
     * </p>
     * 
     * @return The timestamp for when the monitor resource was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The timestamp of the latest modification to the monitor.
     * </p>
     * 
     * @return The timestamp of the latest modification to the monitor.
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * <p>
     * The estimated number of minutes remaining before the monitor resource finishes its current evaluation.
     * </p>
     * 
     * @return The estimated number of minutes remaining before the monitor resource finishes its current evaluation.
     */
    public final Long estimatedEvaluationTimeRemainingInMinutes() {
        return estimatedEvaluationTimeRemainingInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(lastEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastEvaluationState());
        hashCode = 31 * hashCode + Objects.hashCode(baseline());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedEvaluationTimeRemainingInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMonitorResponse)) {
            return false;
        }
        DescribeMonitorResponse other = (DescribeMonitorResponse) obj;
        return Objects.equals(monitorName(), other.monitorName()) && Objects.equals(monitorArn(), other.monitorArn())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(status(), other.status())
                && Objects.equals(lastEvaluationTime(), other.lastEvaluationTime())
                && Objects.equals(lastEvaluationState(), other.lastEvaluationState())
                && Objects.equals(baseline(), other.baseline()) && Objects.equals(message(), other.message())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime())
                && Objects.equals(estimatedEvaluationTimeRemainingInMinutes(), other.estimatedEvaluationTimeRemainingInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMonitorResponse").add("MonitorName", monitorName()).add("MonitorArn", monitorArn())
                .add("ResourceArn", resourceArn()).add("Status", status()).add("LastEvaluationTime", lastEvaluationTime())
                .add("LastEvaluationState", lastEvaluationState()).add("Baseline", baseline()).add("Message", message())
                .add("CreationTime", creationTime()).add("LastModificationTime", lastModificationTime())
                .add("EstimatedEvaluationTimeRemainingInMinutes", estimatedEvaluationTimeRemainingInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitorName":
            return Optional.ofNullable(clazz.cast(monitorName()));
        case "MonitorArn":
            return Optional.ofNullable(clazz.cast(monitorArn()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "LastEvaluationTime":
            return Optional.ofNullable(clazz.cast(lastEvaluationTime()));
        case "LastEvaluationState":
            return Optional.ofNullable(clazz.cast(lastEvaluationState()));
        case "Baseline":
            return Optional.ofNullable(clazz.cast(baseline()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "EstimatedEvaluationTimeRemainingInMinutes":
            return Optional.ofNullable(clazz.cast(estimatedEvaluationTimeRemainingInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MonitorName", MONITOR_NAME_FIELD);
        map.put("MonitorArn", MONITOR_ARN_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LastEvaluationTime", LAST_EVALUATION_TIME_FIELD);
        map.put("LastEvaluationState", LAST_EVALUATION_STATE_FIELD);
        map.put("Baseline", BASELINE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        map.put("EstimatedEvaluationTimeRemainingInMinutes", ESTIMATED_EVALUATION_TIME_REMAINING_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMonitorResponse, T> g) {
        return obj -> g.apply((DescribeMonitorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMonitorResponse> {
        /**
         * <p>
         * The name of the monitor.
         * </p>
         * 
         * @param monitorName
         *        The name of the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorName(String monitorName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the monitor resource described.
         * </p>
         * 
         * @param monitorArn
         *        The Amazon Resource Name (ARN) of the monitor resource described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArn(String monitorArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the auto predictor being monitored.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the auto predictor being monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The status of the monitor resource.
         * </p>
         * 
         * @param status
         *        The status of the monitor resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The timestamp of the latest evaluation completed by the monitor.
         * </p>
         * 
         * @param lastEvaluationTime
         *        The timestamp of the latest evaluation completed by the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluationTime(Instant lastEvaluationTime);

        /**
         * <p>
         * The state of the monitor's latest evaluation.
         * </p>
         * 
         * @param lastEvaluationState
         *        The state of the monitor's latest evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluationState(String lastEvaluationState);

        /**
         * <p>
         * Metrics you can use as a baseline for comparison purposes. Use these values you interpret monitoring results
         * for an auto predictor.
         * </p>
         * 
         * @param baseline
         *        Metrics you can use as a baseline for comparison purposes. Use these values you interpret monitoring
         *        results for an auto predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseline(Baseline baseline);

        /**
         * <p>
         * Metrics you can use as a baseline for comparison purposes. Use these values you interpret monitoring results
         * for an auto predictor.
         * </p>
         * This is a convenience method that creates an instance of the {@link Baseline.Builder} avoiding the need to
         * create one manually via {@link Baseline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Baseline.Builder#build()} is called immediately and its result is
         * passed to {@link #baseline(Baseline)}.
         * 
         * @param baseline
         *        a consumer that will call methods on {@link Baseline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baseline(Baseline)
         */
        default Builder baseline(Consumer<Baseline.Builder> baseline) {
            return baseline(Baseline.builder().applyMutation(baseline).build());
        }

        /**
         * <p>
         * An error message, if any, for the monitor.
         * </p>
         * 
         * @param message
         *        An error message, if any, for the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The timestamp for when the monitor resource was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp for when the monitor resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The timestamp of the latest modification to the monitor.
         * </p>
         * 
         * @param lastModificationTime
         *        The timestamp of the latest modification to the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * The estimated number of minutes remaining before the monitor resource finishes its current evaluation.
         * </p>
         * 
         * @param estimatedEvaluationTimeRemainingInMinutes
         *        The estimated number of minutes remaining before the monitor resource finishes its current evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedEvaluationTimeRemainingInMinutes(Long estimatedEvaluationTimeRemainingInMinutes);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String monitorName;

        private String monitorArn;

        private String resourceArn;

        private String status;

        private Instant lastEvaluationTime;

        private String lastEvaluationState;

        private Baseline baseline;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private Long estimatedEvaluationTimeRemainingInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMonitorResponse model) {
            super(model);
            monitorName(model.monitorName);
            monitorArn(model.monitorArn);
            resourceArn(model.resourceArn);
            status(model.status);
            lastEvaluationTime(model.lastEvaluationTime);
            lastEvaluationState(model.lastEvaluationState);
            baseline(model.baseline);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
            estimatedEvaluationTimeRemainingInMinutes(model.estimatedEvaluationTimeRemainingInMinutes);
        }

        public final String getMonitorName() {
            return monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getMonitorArn() {
            return monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getLastEvaluationTime() {
            return lastEvaluationTime;
        }

        public final void setLastEvaluationTime(Instant lastEvaluationTime) {
            this.lastEvaluationTime = lastEvaluationTime;
        }

        @Override
        public final Builder lastEvaluationTime(Instant lastEvaluationTime) {
            this.lastEvaluationTime = lastEvaluationTime;
            return this;
        }

        public final String getLastEvaluationState() {
            return lastEvaluationState;
        }

        public final void setLastEvaluationState(String lastEvaluationState) {
            this.lastEvaluationState = lastEvaluationState;
        }

        @Override
        public final Builder lastEvaluationState(String lastEvaluationState) {
            this.lastEvaluationState = lastEvaluationState;
            return this;
        }

        public final Baseline.Builder getBaseline() {
            return baseline != null ? baseline.toBuilder() : null;
        }

        public final void setBaseline(Baseline.BuilderImpl baseline) {
            this.baseline = baseline != null ? baseline.build() : null;
        }

        @Override
        public final Builder baseline(Baseline baseline) {
            this.baseline = baseline;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final Long getEstimatedEvaluationTimeRemainingInMinutes() {
            return estimatedEvaluationTimeRemainingInMinutes;
        }

        public final void setEstimatedEvaluationTimeRemainingInMinutes(Long estimatedEvaluationTimeRemainingInMinutes) {
            this.estimatedEvaluationTimeRemainingInMinutes = estimatedEvaluationTimeRemainingInMinutes;
        }

        @Override
        public final Builder estimatedEvaluationTimeRemainingInMinutes(Long estimatedEvaluationTimeRemainingInMinutes) {
            this.estimatedEvaluationTimeRemainingInMinutes = estimatedEvaluationTimeRemainingInMinutes;
            return this;
        }

        @Override
        public DescribeMonitorResponse build() {
            return new DescribeMonitorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
