/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWhatIfForecastExportRequest extends ForecastRequest implements
        ToCopyableBuilder<DescribeWhatIfForecastExportRequest.Builder, DescribeWhatIfForecastExportRequest> {
    private static final SdkField<String> WHAT_IF_FORECAST_EXPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhatIfForecastExportArn").getter(getter(DescribeWhatIfForecastExportRequest::whatIfForecastExportArn))
            .setter(setter(Builder::whatIfForecastExportArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastExportArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(WHAT_IF_FORECAST_EXPORT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String whatIfForecastExportArn;

    private DescribeWhatIfForecastExportRequest(BuilderImpl builder) {
        super(builder);
        this.whatIfForecastExportArn = builder.whatIfForecastExportArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if forecast export that you are interested in.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the what-if forecast export that you are interested in.
     */
    public final String whatIfForecastExportArn() {
        return whatIfForecastExportArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(whatIfForecastExportArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWhatIfForecastExportRequest)) {
            return false;
        }
        DescribeWhatIfForecastExportRequest other = (DescribeWhatIfForecastExportRequest) obj;
        return Objects.equals(whatIfForecastExportArn(), other.whatIfForecastExportArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWhatIfForecastExportRequest").add("WhatIfForecastExportArn", whatIfForecastExportArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WhatIfForecastExportArn":
            return Optional.ofNullable(clazz.cast(whatIfForecastExportArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WhatIfForecastExportArn", WHAT_IF_FORECAST_EXPORT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWhatIfForecastExportRequest, T> g) {
        return obj -> g.apply((DescribeWhatIfForecastExportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWhatIfForecastExportRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the what-if forecast export that you are interested in.
         * </p>
         * 
         * @param whatIfForecastExportArn
         *        The Amazon Resource Name (ARN) of the what-if forecast export that you are interested in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastExportArn(String whatIfForecastExportArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastRequest.BuilderImpl implements Builder {
        private String whatIfForecastExportArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWhatIfForecastExportRequest model) {
            super(model);
            whatIfForecastExportArn(model.whatIfForecastExportArn);
        }

        public final String getWhatIfForecastExportArn() {
            return whatIfForecastExportArn;
        }

        public final void setWhatIfForecastExportArn(String whatIfForecastExportArn) {
            this.whatIfForecastExportArn = whatIfForecastExportArn;
        }

        @Override
        public final Builder whatIfForecastExportArn(String whatIfForecastExportArn) {
            this.whatIfForecastExportArn = whatIfForecastExportArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWhatIfForecastExportRequest build() {
            return new DescribeWhatIfForecastExportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
