/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWhatIfForecastResponse extends ForecastResponse implements
        ToCopyableBuilder<DescribeWhatIfForecastResponse.Builder, DescribeWhatIfForecastResponse> {
    private static final SdkField<String> WHAT_IF_FORECAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhatIfForecastName").getter(getter(DescribeWhatIfForecastResponse::whatIfForecastName))
            .setter(setter(Builder::whatIfForecastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastName").build())
            .build();

    private static final SdkField<String> WHAT_IF_FORECAST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhatIfForecastArn").getter(getter(DescribeWhatIfForecastResponse::whatIfForecastArn))
            .setter(setter(Builder::whatIfForecastArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastArn").build()).build();

    private static final SdkField<String> WHAT_IF_ANALYSIS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhatIfAnalysisArn").getter(getter(DescribeWhatIfForecastResponse::whatIfAnalysisArn))
            .setter(setter(Builder::whatIfAnalysisArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfAnalysisArn").build()).build();

    private static final SdkField<Long> ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedTimeRemainingInMinutes")
            .getter(getter(DescribeWhatIfForecastResponse::estimatedTimeRemainingInMinutes))
            .setter(setter(Builder::estimatedTimeRemainingInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeRemainingInMinutes")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeWhatIfForecastResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DescribeWhatIfForecastResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeWhatIfForecastResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(DescribeWhatIfForecastResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final SdkField<List<TimeSeriesTransformation>> TIME_SERIES_TRANSFORMATIONS_FIELD = SdkField
            .<List<TimeSeriesTransformation>> builder(MarshallingType.LIST)
            .memberName("TimeSeriesTransformations")
            .getter(getter(DescribeWhatIfForecastResponse::timeSeriesTransformations))
            .setter(setter(Builder::timeSeriesTransformations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesTransformations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeSeriesTransformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeSeriesTransformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimeSeriesReplacementsDataSource> TIME_SERIES_REPLACEMENTS_DATA_SOURCE_FIELD = SdkField
            .<TimeSeriesReplacementsDataSource> builder(MarshallingType.SDK_POJO)
            .memberName("TimeSeriesReplacementsDataSource")
            .getter(getter(DescribeWhatIfForecastResponse::timeSeriesReplacementsDataSource))
            .setter(setter(Builder::timeSeriesReplacementsDataSource))
            .constructor(TimeSeriesReplacementsDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesReplacementsDataSource")
                    .build()).build();

    private static final SdkField<List<String>> FORECAST_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ForecastTypes")
            .getter(getter(DescribeWhatIfForecastResponse::forecastTypes))
            .setter(setter(Builder::forecastTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WHAT_IF_FORECAST_NAME_FIELD,
            WHAT_IF_FORECAST_ARN_FIELD, WHAT_IF_ANALYSIS_ARN_FIELD, ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD, STATUS_FIELD,
            MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, TIME_SERIES_TRANSFORMATIONS_FIELD,
            TIME_SERIES_REPLACEMENTS_DATA_SOURCE_FIELD, FORECAST_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String whatIfForecastName;

    private final String whatIfForecastArn;

    private final String whatIfAnalysisArn;

    private final Long estimatedTimeRemainingInMinutes;

    private final String status;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private final List<TimeSeriesTransformation> timeSeriesTransformations;

    private final TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource;

    private final List<String> forecastTypes;

    private DescribeWhatIfForecastResponse(BuilderImpl builder) {
        super(builder);
        this.whatIfForecastName = builder.whatIfForecastName;
        this.whatIfForecastArn = builder.whatIfForecastArn;
        this.whatIfAnalysisArn = builder.whatIfAnalysisArn;
        this.estimatedTimeRemainingInMinutes = builder.estimatedTimeRemainingInMinutes;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.timeSeriesTransformations = builder.timeSeriesTransformations;
        this.timeSeriesReplacementsDataSource = builder.timeSeriesReplacementsDataSource;
        this.forecastTypes = builder.forecastTypes;
    }

    /**
     * <p>
     * The name of the what-if forecast.
     * </p>
     * 
     * @return The name of the what-if forecast.
     */
    public final String whatIfForecastName() {
        return whatIfForecastName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if forecast.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the what-if forecast.
     */
    public final String whatIfForecastArn() {
        return whatIfForecastArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if analysis that contains this forecast.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the what-if analysis that contains this forecast.
     */
    public final String whatIfAnalysisArn() {
        return whatIfAnalysisArn;
    }

    /**
     * <p>
     * The approximate time remaining to complete the what-if forecast, in minutes.
     * </p>
     * 
     * @return The approximate time remaining to complete the what-if forecast, in minutes.
     */
    public final Long estimatedTimeRemainingInMinutes() {
        return estimatedTimeRemainingInMinutes;
    }

    /**
     * <p>
     * The status of the what-if forecast. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Status</code> of the what-if forecast must be <code>ACTIVE</code> before you can access the forecast.
     * </p>
     * </note>
     * 
     * @return The status of the what-if forecast. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>Status</code> of the what-if forecast must be <code>ACTIVE</code> before you can access the
     *         forecast.
     *         </p>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @return If an error occurred, an informational message about the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * When the what-if forecast was created.
     * </p>
     * 
     * @return When the what-if forecast was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the TimeSeriesTransformations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTimeSeriesTransformations() {
        return timeSeriesTransformations != null && !(timeSeriesTransformations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Action</code> and <code>TimeSeriesConditions</code> elements that describe what transformations
     * were applied to which time series.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimeSeriesTransformations} method.
     * </p>
     * 
     * @return An array of <code>Action</code> and <code>TimeSeriesConditions</code> elements that describe what
     *         transformations were applied to which time series.
     */
    public final List<TimeSeriesTransformation> timeSeriesTransformations() {
        return timeSeriesTransformations;
    }

    /**
     * <p>
     * An array of <code>S3Config</code>, <code>Schema</code>, and <code>Format</code> elements that describe the
     * replacement time series.
     * </p>
     * 
     * @return An array of <code>S3Config</code>, <code>Schema</code>, and <code>Format</code> elements that describe
     *         the replacement time series.
     */
    public final TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource() {
        return timeSeriesReplacementsDataSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the ForecastTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasForecastTypes() {
        return forecastTypes != null && !(forecastTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The quantiles at which probabilistic forecasts are generated. You can specify up to five quantiles per what-if
     * forecast in the <a>CreateWhatIfForecast</a> operation. If you didn't specify quantiles, the default values are
     * <code>["0.1", "0.5", "0.9"]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForecastTypes} method.
     * </p>
     * 
     * @return The quantiles at which probabilistic forecasts are generated. You can specify up to five quantiles per
     *         what-if forecast in the <a>CreateWhatIfForecast</a> operation. If you didn't specify quantiles, the
     *         default values are <code>["0.1", "0.5", "0.9"]</code>.
     */
    public final List<String> forecastTypes() {
        return forecastTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(whatIfForecastName());
        hashCode = 31 * hashCode + Objects.hashCode(whatIfForecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(whatIfAnalysisArn());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeRemainingInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTimeSeriesTransformations() ? timeSeriesTransformations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesReplacementsDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasForecastTypes() ? forecastTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWhatIfForecastResponse)) {
            return false;
        }
        DescribeWhatIfForecastResponse other = (DescribeWhatIfForecastResponse) obj;
        return Objects.equals(whatIfForecastName(), other.whatIfForecastName())
                && Objects.equals(whatIfForecastArn(), other.whatIfForecastArn())
                && Objects.equals(whatIfAnalysisArn(), other.whatIfAnalysisArn())
                && Objects.equals(estimatedTimeRemainingInMinutes(), other.estimatedTimeRemainingInMinutes())
                && Objects.equals(status(), other.status()) && Objects.equals(message(), other.message())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime())
                && hasTimeSeriesTransformations() == other.hasTimeSeriesTransformations()
                && Objects.equals(timeSeriesTransformations(), other.timeSeriesTransformations())
                && Objects.equals(timeSeriesReplacementsDataSource(), other.timeSeriesReplacementsDataSource())
                && hasForecastTypes() == other.hasForecastTypes() && Objects.equals(forecastTypes(), other.forecastTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWhatIfForecastResponse").add("WhatIfForecastName", whatIfForecastName())
                .add("WhatIfForecastArn", whatIfForecastArn()).add("WhatIfAnalysisArn", whatIfAnalysisArn())
                .add("EstimatedTimeRemainingInMinutes", estimatedTimeRemainingInMinutes()).add("Status", status())
                .add("Message", message()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime())
                .add("TimeSeriesTransformations", hasTimeSeriesTransformations() ? timeSeriesTransformations() : null)
                .add("TimeSeriesReplacementsDataSource", timeSeriesReplacementsDataSource())
                .add("ForecastTypes", hasForecastTypes() ? forecastTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WhatIfForecastName":
            return Optional.ofNullable(clazz.cast(whatIfForecastName()));
        case "WhatIfForecastArn":
            return Optional.ofNullable(clazz.cast(whatIfForecastArn()));
        case "WhatIfAnalysisArn":
            return Optional.ofNullable(clazz.cast(whatIfAnalysisArn()));
        case "EstimatedTimeRemainingInMinutes":
            return Optional.ofNullable(clazz.cast(estimatedTimeRemainingInMinutes()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "TimeSeriesTransformations":
            return Optional.ofNullable(clazz.cast(timeSeriesTransformations()));
        case "TimeSeriesReplacementsDataSource":
            return Optional.ofNullable(clazz.cast(timeSeriesReplacementsDataSource()));
        case "ForecastTypes":
            return Optional.ofNullable(clazz.cast(forecastTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WhatIfForecastName", WHAT_IF_FORECAST_NAME_FIELD);
        map.put("WhatIfForecastArn", WHAT_IF_FORECAST_ARN_FIELD);
        map.put("WhatIfAnalysisArn", WHAT_IF_ANALYSIS_ARN_FIELD);
        map.put("EstimatedTimeRemainingInMinutes", ESTIMATED_TIME_REMAINING_IN_MINUTES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        map.put("TimeSeriesTransformations", TIME_SERIES_TRANSFORMATIONS_FIELD);
        map.put("TimeSeriesReplacementsDataSource", TIME_SERIES_REPLACEMENTS_DATA_SOURCE_FIELD);
        map.put("ForecastTypes", FORECAST_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWhatIfForecastResponse, T> g) {
        return obj -> g.apply((DescribeWhatIfForecastResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWhatIfForecastResponse> {
        /**
         * <p>
         * The name of the what-if forecast.
         * </p>
         * 
         * @param whatIfForecastName
         *        The name of the what-if forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastName(String whatIfForecastName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the what-if forecast.
         * </p>
         * 
         * @param whatIfForecastArn
         *        The Amazon Resource Name (ARN) of the what-if forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastArn(String whatIfForecastArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the what-if analysis that contains this forecast.
         * </p>
         * 
         * @param whatIfAnalysisArn
         *        The Amazon Resource Name (ARN) of the what-if analysis that contains this forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfAnalysisArn(String whatIfAnalysisArn);

        /**
         * <p>
         * The approximate time remaining to complete the what-if forecast, in minutes.
         * </p>
         * 
         * @param estimatedTimeRemainingInMinutes
         *        The approximate time remaining to complete the what-if forecast, in minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes);

        /**
         * <p>
         * The status of the what-if forecast. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>Status</code> of the what-if forecast must be <code>ACTIVE</code> before you can access the
         * forecast.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the what-if forecast. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>Status</code> of the what-if forecast must be <code>ACTIVE</code> before you can access the
         *        forecast.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If an error occurred, an informational message about the error.
         * </p>
         * 
         * @param message
         *        If an error occurred, an informational message about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * When the what-if forecast was created.
         * </p>
         * 
         * @param creationTime
         *        When the what-if forecast was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPED</code> - When the job stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPED</code> - When the job stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * An array of <code>Action</code> and <code>TimeSeriesConditions</code> elements that describe what
         * transformations were applied to which time series.
         * </p>
         * 
         * @param timeSeriesTransformations
         *        An array of <code>Action</code> and <code>TimeSeriesConditions</code> elements that describe what
         *        transformations were applied to which time series.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesTransformations(Collection<TimeSeriesTransformation> timeSeriesTransformations);

        /**
         * <p>
         * An array of <code>Action</code> and <code>TimeSeriesConditions</code> elements that describe what
         * transformations were applied to which time series.
         * </p>
         * 
         * @param timeSeriesTransformations
         *        An array of <code>Action</code> and <code>TimeSeriesConditions</code> elements that describe what
         *        transformations were applied to which time series.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesTransformations(TimeSeriesTransformation... timeSeriesTransformations);

        /**
         * <p>
         * An array of <code>Action</code> and <code>TimeSeriesConditions</code> elements that describe what
         * transformations were applied to which time series.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation.Builder#build()} is called
         * immediately and its result is passed to {@link #timeSeriesTransformations(List<TimeSeriesTransformation>)}.
         * 
         * @param timeSeriesTransformations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesTransformations(java.util.Collection<TimeSeriesTransformation>)
         */
        Builder timeSeriesTransformations(Consumer<TimeSeriesTransformation.Builder>... timeSeriesTransformations);

        /**
         * <p>
         * An array of <code>S3Config</code>, <code>Schema</code>, and <code>Format</code> elements that describe the
         * replacement time series.
         * </p>
         * 
         * @param timeSeriesReplacementsDataSource
         *        An array of <code>S3Config</code>, <code>Schema</code>, and <code>Format</code> elements that describe
         *        the replacement time series.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource);

        /**
         * <p>
         * An array of <code>S3Config</code>, <code>Schema</code>, and <code>Format</code> elements that describe the
         * replacement time series.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeSeriesReplacementsDataSource.Builder}
         * avoiding the need to create one manually via {@link TimeSeriesReplacementsDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeSeriesReplacementsDataSource.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #timeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource)}.
         * 
         * @param timeSeriesReplacementsDataSource
         *        a consumer that will call methods on {@link TimeSeriesReplacementsDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource)
         */
        default Builder timeSeriesReplacementsDataSource(
                Consumer<TimeSeriesReplacementsDataSource.Builder> timeSeriesReplacementsDataSource) {
            return timeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource.builder()
                    .applyMutation(timeSeriesReplacementsDataSource).build());
        }

        /**
         * <p>
         * The quantiles at which probabilistic forecasts are generated. You can specify up to five quantiles per
         * what-if forecast in the <a>CreateWhatIfForecast</a> operation. If you didn't specify quantiles, the default
         * values are <code>["0.1", "0.5", "0.9"]</code>.
         * </p>
         * 
         * @param forecastTypes
         *        The quantiles at which probabilistic forecasts are generated. You can specify up to five quantiles per
         *        what-if forecast in the <a>CreateWhatIfForecast</a> operation. If you didn't specify quantiles, the
         *        default values are <code>["0.1", "0.5", "0.9"]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastTypes(Collection<String> forecastTypes);

        /**
         * <p>
         * The quantiles at which probabilistic forecasts are generated. You can specify up to five quantiles per
         * what-if forecast in the <a>CreateWhatIfForecast</a> operation. If you didn't specify quantiles, the default
         * values are <code>["0.1", "0.5", "0.9"]</code>.
         * </p>
         * 
         * @param forecastTypes
         *        The quantiles at which probabilistic forecasts are generated. You can specify up to five quantiles per
         *        what-if forecast in the <a>CreateWhatIfForecast</a> operation. If you didn't specify quantiles, the
         *        default values are <code>["0.1", "0.5", "0.9"]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastTypes(String... forecastTypes);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String whatIfForecastName;

        private String whatIfForecastArn;

        private String whatIfAnalysisArn;

        private Long estimatedTimeRemainingInMinutes;

        private String status;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private List<TimeSeriesTransformation> timeSeriesTransformations = DefaultSdkAutoConstructList.getInstance();

        private TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource;

        private List<String> forecastTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWhatIfForecastResponse model) {
            super(model);
            whatIfForecastName(model.whatIfForecastName);
            whatIfForecastArn(model.whatIfForecastArn);
            whatIfAnalysisArn(model.whatIfAnalysisArn);
            estimatedTimeRemainingInMinutes(model.estimatedTimeRemainingInMinutes);
            status(model.status);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
            timeSeriesTransformations(model.timeSeriesTransformations);
            timeSeriesReplacementsDataSource(model.timeSeriesReplacementsDataSource);
            forecastTypes(model.forecastTypes);
        }

        public final String getWhatIfForecastName() {
            return whatIfForecastName;
        }

        public final void setWhatIfForecastName(String whatIfForecastName) {
            this.whatIfForecastName = whatIfForecastName;
        }

        @Override
        public final Builder whatIfForecastName(String whatIfForecastName) {
            this.whatIfForecastName = whatIfForecastName;
            return this;
        }

        public final String getWhatIfForecastArn() {
            return whatIfForecastArn;
        }

        public final void setWhatIfForecastArn(String whatIfForecastArn) {
            this.whatIfForecastArn = whatIfForecastArn;
        }

        @Override
        public final Builder whatIfForecastArn(String whatIfForecastArn) {
            this.whatIfForecastArn = whatIfForecastArn;
            return this;
        }

        public final String getWhatIfAnalysisArn() {
            return whatIfAnalysisArn;
        }

        public final void setWhatIfAnalysisArn(String whatIfAnalysisArn) {
            this.whatIfAnalysisArn = whatIfAnalysisArn;
        }

        @Override
        public final Builder whatIfAnalysisArn(String whatIfAnalysisArn) {
            this.whatIfAnalysisArn = whatIfAnalysisArn;
            return this;
        }

        public final Long getEstimatedTimeRemainingInMinutes() {
            return estimatedTimeRemainingInMinutes;
        }

        public final void setEstimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
        }

        @Override
        public final Builder estimatedTimeRemainingInMinutes(Long estimatedTimeRemainingInMinutes) {
            this.estimatedTimeRemainingInMinutes = estimatedTimeRemainingInMinutes;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final List<TimeSeriesTransformation.Builder> getTimeSeriesTransformations() {
            List<TimeSeriesTransformation.Builder> result = TimeSeriesTransformationsCopier
                    .copyToBuilder(this.timeSeriesTransformations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeSeriesTransformations(Collection<TimeSeriesTransformation.BuilderImpl> timeSeriesTransformations) {
            this.timeSeriesTransformations = TimeSeriesTransformationsCopier.copyFromBuilder(timeSeriesTransformations);
        }

        @Override
        public final Builder timeSeriesTransformations(Collection<TimeSeriesTransformation> timeSeriesTransformations) {
            this.timeSeriesTransformations = TimeSeriesTransformationsCopier.copy(timeSeriesTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesTransformations(TimeSeriesTransformation... timeSeriesTransformations) {
            timeSeriesTransformations(Arrays.asList(timeSeriesTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesTransformations(Consumer<TimeSeriesTransformation.Builder>... timeSeriesTransformations) {
            timeSeriesTransformations(Stream.of(timeSeriesTransformations)
                    .map(c -> TimeSeriesTransformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TimeSeriesReplacementsDataSource.Builder getTimeSeriesReplacementsDataSource() {
            return timeSeriesReplacementsDataSource != null ? timeSeriesReplacementsDataSource.toBuilder() : null;
        }

        public final void setTimeSeriesReplacementsDataSource(
                TimeSeriesReplacementsDataSource.BuilderImpl timeSeriesReplacementsDataSource) {
            this.timeSeriesReplacementsDataSource = timeSeriesReplacementsDataSource != null ? timeSeriesReplacementsDataSource
                    .build() : null;
        }

        @Override
        public final Builder timeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource) {
            this.timeSeriesReplacementsDataSource = timeSeriesReplacementsDataSource;
            return this;
        }

        public final Collection<String> getForecastTypes() {
            if (forecastTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return forecastTypes;
        }

        public final void setForecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
        }

        @Override
        public final Builder forecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastTypes(String... forecastTypes) {
            forecastTypes(Arrays.asList(forecastTypes));
            return this;
        }

        @Override
        public DescribeWhatIfForecastResponse build() {
            return new DescribeWhatIfForecastResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
