/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that define how to split a dataset into training data and testing data, and the number of iterations to
 * perform. These parameters are specified in the predefined algorithms but you can override them in the
 * <a>CreatePredictor</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationParameters.Builder, EvaluationParameters> {
    private static final SdkField<Integer> NUMBER_OF_BACKTEST_WINDOWS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfBacktestWindows").getter(getter(EvaluationParameters::numberOfBacktestWindows))
            .setter(setter(Builder::numberOfBacktestWindows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfBacktestWindows").build())
            .build();

    private static final SdkField<Integer> BACK_TEST_WINDOW_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackTestWindowOffset").getter(getter(EvaluationParameters::backTestWindowOffset))
            .setter(setter(Builder::backTestWindowOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackTestWindowOffset").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_OF_BACKTEST_WINDOWS_FIELD, BACK_TEST_WINDOW_OFFSET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer numberOfBacktestWindows;

    private final Integer backTestWindowOffset;

    private EvaluationParameters(BuilderImpl builder) {
        this.numberOfBacktestWindows = builder.numberOfBacktestWindows;
        this.backTestWindowOffset = builder.backTestWindowOffset;
    }

    /**
     * <p>
     * The number of times to split the input data. The default is 1. Valid values are 1 through 5.
     * </p>
     * 
     * @return The number of times to split the input data. The default is 1. Valid values are 1 through 5.
     */
    public final Integer numberOfBacktestWindows() {
        return numberOfBacktestWindows;
    }

    /**
     * <p>
     * The point from the end of the dataset where you want to split the data for model training and testing
     * (evaluation). Specify the value as the number of data points. The default is the value of the forecast horizon.
     * <code>BackTestWindowOffset</code> can be used to mimic a past virtual forecast start date. This value must be
     * greater than or equal to the forecast horizon and less than half of the TARGET_TIME_SERIES dataset length.
     * </p>
     * <p>
     * <code>ForecastHorizon</code> &lt;= <code>BackTestWindowOffset</code> &lt; 1/2 * TARGET_TIME_SERIES dataset length
     * </p>
     * 
     * @return The point from the end of the dataset where you want to split the data for model training and testing
     *         (evaluation). Specify the value as the number of data points. The default is the value of the forecast
     *         horizon. <code>BackTestWindowOffset</code> can be used to mimic a past virtual forecast start date. This
     *         value must be greater than or equal to the forecast horizon and less than half of the TARGET_TIME_SERIES
     *         dataset length.</p>
     *         <p>
     *         <code>ForecastHorizon</code> &lt;= <code>BackTestWindowOffset</code> &lt; 1/2 * TARGET_TIME_SERIES
     *         dataset length
     */
    public final Integer backTestWindowOffset() {
        return backTestWindowOffset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfBacktestWindows());
        hashCode = 31 * hashCode + Objects.hashCode(backTestWindowOffset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationParameters)) {
            return false;
        }
        EvaluationParameters other = (EvaluationParameters) obj;
        return Objects.equals(numberOfBacktestWindows(), other.numberOfBacktestWindows())
                && Objects.equals(backTestWindowOffset(), other.backTestWindowOffset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationParameters").add("NumberOfBacktestWindows", numberOfBacktestWindows())
                .add("BackTestWindowOffset", backTestWindowOffset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfBacktestWindows":
            return Optional.ofNullable(clazz.cast(numberOfBacktestWindows()));
        case "BackTestWindowOffset":
            return Optional.ofNullable(clazz.cast(backTestWindowOffset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NumberOfBacktestWindows", NUMBER_OF_BACKTEST_WINDOWS_FIELD);
        map.put("BackTestWindowOffset", BACK_TEST_WINDOW_OFFSET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationParameters, T> g) {
        return obj -> g.apply((EvaluationParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationParameters> {
        /**
         * <p>
         * The number of times to split the input data. The default is 1. Valid values are 1 through 5.
         * </p>
         * 
         * @param numberOfBacktestWindows
         *        The number of times to split the input data. The default is 1. Valid values are 1 through 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfBacktestWindows(Integer numberOfBacktestWindows);

        /**
         * <p>
         * The point from the end of the dataset where you want to split the data for model training and testing
         * (evaluation). Specify the value as the number of data points. The default is the value of the forecast
         * horizon. <code>BackTestWindowOffset</code> can be used to mimic a past virtual forecast start date. This
         * value must be greater than or equal to the forecast horizon and less than half of the TARGET_TIME_SERIES
         * dataset length.
         * </p>
         * <p>
         * <code>ForecastHorizon</code> &lt;= <code>BackTestWindowOffset</code> &lt; 1/2 * TARGET_TIME_SERIES dataset
         * length
         * </p>
         * 
         * @param backTestWindowOffset
         *        The point from the end of the dataset where you want to split the data for model training and testing
         *        (evaluation). Specify the value as the number of data points. The default is the value of the forecast
         *        horizon. <code>BackTestWindowOffset</code> can be used to mimic a past virtual forecast start date.
         *        This value must be greater than or equal to the forecast horizon and less than half of the
         *        TARGET_TIME_SERIES dataset length.</p>
         *        <p>
         *        <code>ForecastHorizon</code> &lt;= <code>BackTestWindowOffset</code> &lt; 1/2 * TARGET_TIME_SERIES
         *        dataset length
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backTestWindowOffset(Integer backTestWindowOffset);
    }

    static final class BuilderImpl implements Builder {
        private Integer numberOfBacktestWindows;

        private Integer backTestWindowOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationParameters model) {
            numberOfBacktestWindows(model.numberOfBacktestWindows);
            backTestWindowOffset(model.backTestWindowOffset);
        }

        public final Integer getNumberOfBacktestWindows() {
            return numberOfBacktestWindows;
        }

        public final void setNumberOfBacktestWindows(Integer numberOfBacktestWindows) {
            this.numberOfBacktestWindows = numberOfBacktestWindows;
        }

        @Override
        public final Builder numberOfBacktestWindows(Integer numberOfBacktestWindows) {
            this.numberOfBacktestWindows = numberOfBacktestWindows;
            return this;
        }

        public final Integer getBackTestWindowOffset() {
            return backTestWindowOffset;
        }

        public final void setBackTestWindowOffset(Integer backTestWindowOffset) {
            this.backTestWindowOffset = backTestWindowOffset;
        }

        @Override
        public final Builder backTestWindowOffset(Integer backTestWindowOffset) {
            this.backTestWindowOffset = backTestWindowOffset;
            return this;
        }

        @Override
        public EvaluationParameters build() {
            return new EvaluationParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
