/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about a predictor event, such as a retraining.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictorEvent implements SdkPojo, Serializable, ToCopyableBuilder<PredictorEvent.Builder, PredictorEvent> {
    private static final SdkField<String> DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Detail")
            .getter(getter(PredictorEvent::detail)).setter(setter(Builder::detail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detail").build()).build();

    private static final SdkField<Instant> DATETIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Datetime").getter(getter(PredictorEvent::datetime)).setter(setter(Builder::datetime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datetime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAIL_FIELD, DATETIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String detail;

    private final Instant datetime;

    private PredictorEvent(BuilderImpl builder) {
        this.detail = builder.detail;
        this.datetime = builder.datetime;
    }

    /**
     * <p>
     * The type of event. For example, <code>Retrain</code>. A retraining event denotes the timepoint when a predictor
     * was retrained. Any monitor results from before the <code>Datetime</code> are from the previous predictor. Any new
     * metrics are for the newly retrained predictor.
     * </p>
     * 
     * @return The type of event. For example, <code>Retrain</code>. A retraining event denotes the timepoint when a
     *         predictor was retrained. Any monitor results from before the <code>Datetime</code> are from the previous
     *         predictor. Any new metrics are for the newly retrained predictor.
     */
    public final String detail() {
        return detail;
    }

    /**
     * <p>
     * The timestamp for when the event occurred.
     * </p>
     * 
     * @return The timestamp for when the event occurred.
     */
    public final Instant datetime() {
        return datetime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detail());
        hashCode = 31 * hashCode + Objects.hashCode(datetime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictorEvent)) {
            return false;
        }
        PredictorEvent other = (PredictorEvent) obj;
        return Objects.equals(detail(), other.detail()) && Objects.equals(datetime(), other.datetime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictorEvent").add("Detail", detail()).add("Datetime", datetime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Detail":
            return Optional.ofNullable(clazz.cast(detail()));
        case "Datetime":
            return Optional.ofNullable(clazz.cast(datetime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Detail", DETAIL_FIELD);
        map.put("Datetime", DATETIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictorEvent, T> g) {
        return obj -> g.apply((PredictorEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictorEvent> {
        /**
         * <p>
         * The type of event. For example, <code>Retrain</code>. A retraining event denotes the timepoint when a
         * predictor was retrained. Any monitor results from before the <code>Datetime</code> are from the previous
         * predictor. Any new metrics are for the newly retrained predictor.
         * </p>
         * 
         * @param detail
         *        The type of event. For example, <code>Retrain</code>. A retraining event denotes the timepoint when a
         *        predictor was retrained. Any monitor results from before the <code>Datetime</code> are from the
         *        previous predictor. Any new metrics are for the newly retrained predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detail(String detail);

        /**
         * <p>
         * The timestamp for when the event occurred.
         * </p>
         * 
         * @param datetime
         *        The timestamp for when the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datetime(Instant datetime);
    }

    static final class BuilderImpl implements Builder {
        private String detail;

        private Instant datetime;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictorEvent model) {
            detail(model.detail);
            datetime(model.datetime);
        }

        public final String getDetail() {
            return detail;
        }

        public final void setDetail(String detail) {
            this.detail = detail;
        }

        @Override
        public final Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public final Instant getDatetime() {
            return datetime;
        }

        public final void setDatetime(Instant datetime) {
            this.datetime = datetime;
        }

        @Override
        public final Builder datetime(Instant datetime) {
            this.datetime = datetime;
            return this;
        }

        @Override
        public PredictorEvent build() {
            return new PredictorEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
