/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the results of a monitor evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictorMonitorEvaluation implements SdkPojo, Serializable,
        ToCopyableBuilder<PredictorMonitorEvaluation.Builder, PredictorMonitorEvaluation> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(PredictorMonitorEvaluation::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorArn").getter(getter(PredictorMonitorEvaluation::monitorArn)).setter(setter(Builder::monitorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()).build();

    private static final SdkField<Instant> EVALUATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EvaluationTime").getter(getter(PredictorMonitorEvaluation::evaluationTime))
            .setter(setter(Builder::evaluationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationTime").build()).build();

    private static final SdkField<String> EVALUATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationState").getter(getter(PredictorMonitorEvaluation::evaluationState))
            .setter(setter(Builder::evaluationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationState").build()).build();

    private static final SdkField<Instant> WINDOW_START_DATETIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("WindowStartDatetime").getter(getter(PredictorMonitorEvaluation::windowStartDatetime))
            .setter(setter(Builder::windowStartDatetime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowStartDatetime").build())
            .build();

    private static final SdkField<Instant> WINDOW_END_DATETIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("WindowEndDatetime").getter(getter(PredictorMonitorEvaluation::windowEndDatetime))
            .setter(setter(Builder::windowEndDatetime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowEndDatetime").build()).build();

    private static final SdkField<PredictorEvent> PREDICTOR_EVENT_FIELD = SdkField
            .<PredictorEvent> builder(MarshallingType.SDK_POJO).memberName("PredictorEvent")
            .getter(getter(PredictorMonitorEvaluation::predictorEvent)).setter(setter(Builder::predictorEvent))
            .constructor(PredictorEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorEvent").build()).build();

    private static final SdkField<MonitorDataSource> MONITOR_DATA_SOURCE_FIELD = SdkField
            .<MonitorDataSource> builder(MarshallingType.SDK_POJO).memberName("MonitorDataSource")
            .getter(getter(PredictorMonitorEvaluation::monitorDataSource)).setter(setter(Builder::monitorDataSource))
            .constructor(MonitorDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorDataSource").build()).build();

    private static final SdkField<List<MetricResult>> METRIC_RESULTS_FIELD = SdkField
            .<List<MetricResult>> builder(MarshallingType.LIST)
            .memberName("MetricResults")
            .getter(getter(PredictorMonitorEvaluation::metricResults))
            .setter(setter(Builder::metricResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> NUM_ITEMS_EVALUATED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumItemsEvaluated").getter(getter(PredictorMonitorEvaluation::numItemsEvaluated))
            .setter(setter(Builder::numItemsEvaluated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumItemsEvaluated").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(PredictorMonitorEvaluation::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            MONITOR_ARN_FIELD, EVALUATION_TIME_FIELD, EVALUATION_STATE_FIELD, WINDOW_START_DATETIME_FIELD,
            WINDOW_END_DATETIME_FIELD, PREDICTOR_EVENT_FIELD, MONITOR_DATA_SOURCE_FIELD, METRIC_RESULTS_FIELD,
            NUM_ITEMS_EVALUATED_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String monitorArn;

    private final Instant evaluationTime;

    private final String evaluationState;

    private final Instant windowStartDatetime;

    private final Instant windowEndDatetime;

    private final PredictorEvent predictorEvent;

    private final MonitorDataSource monitorDataSource;

    private final List<MetricResult> metricResults;

    private final Long numItemsEvaluated;

    private final String message;

    private PredictorMonitorEvaluation(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.monitorArn = builder.monitorArn;
        this.evaluationTime = builder.evaluationTime;
        this.evaluationState = builder.evaluationState;
        this.windowStartDatetime = builder.windowStartDatetime;
        this.windowEndDatetime = builder.windowEndDatetime;
        this.predictorEvent = builder.predictorEvent;
        this.monitorDataSource = builder.monitorDataSource;
        this.metricResults = builder.metricResults;
        this.numItemsEvaluated = builder.numItemsEvaluated;
        this.message = builder.message;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource to monitor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource to monitor.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the monitor resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the monitor resource.
     */
    public final String monitorArn() {
        return monitorArn;
    }

    /**
     * <p>
     * The timestamp that indicates when the monitor evaluation was started.
     * </p>
     * 
     * @return The timestamp that indicates when the monitor evaluation was started.
     */
    public final Instant evaluationTime() {
        return evaluationTime;
    }

    /**
     * <p>
     * The status of the monitor evaluation. The state can be <code>SUCCESS</code> or <code>FAILURE</code>.
     * </p>
     * 
     * @return The status of the monitor evaluation. The state can be <code>SUCCESS</code> or <code>FAILURE</code>.
     */
    public final String evaluationState() {
        return evaluationState;
    }

    /**
     * <p>
     * The timestamp that indicates the start of the window that is used for monitor evaluation.
     * </p>
     * 
     * @return The timestamp that indicates the start of the window that is used for monitor evaluation.
     */
    public final Instant windowStartDatetime() {
        return windowStartDatetime;
    }

    /**
     * <p>
     * The timestamp that indicates the end of the window that is used for monitor evaluation.
     * </p>
     * 
     * @return The timestamp that indicates the end of the window that is used for monitor evaluation.
     */
    public final Instant windowEndDatetime() {
        return windowEndDatetime;
    }

    /**
     * <p>
     * Provides details about a predictor event, such as a retraining.
     * </p>
     * 
     * @return Provides details about a predictor event, such as a retraining.
     */
    public final PredictorEvent predictorEvent() {
        return predictorEvent;
    }

    /**
     * <p>
     * The source of the data the monitor resource used during the evaluation.
     * </p>
     * 
     * @return The source of the data the monitor resource used during the evaluation.
     */
    public final MonitorDataSource monitorDataSource() {
        return monitorDataSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricResults() {
        return metricResults != null && !(metricResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of metrics Forecast calculated when monitoring a predictor. You can compare the value for each metric in
     * the list to the metric's value in the <a>Baseline</a> to see how your predictor's performance is changing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricResults} method.
     * </p>
     * 
     * @return A list of metrics Forecast calculated when monitoring a predictor. You can compare the value for each
     *         metric in the list to the metric's value in the <a>Baseline</a> to see how your predictor's performance
     *         is changing.
     */
    public final List<MetricResult> metricResults() {
        return metricResults;
    }

    /**
     * <p>
     * The number of items considered during the evaluation.
     * </p>
     * 
     * @return The number of items considered during the evaluation.
     */
    public final Long numItemsEvaluated() {
        return numItemsEvaluated;
    }

    /**
     * <p>
     * Information about any errors that may have occurred during the monitor evaluation.
     * </p>
     * 
     * @return Information about any errors that may have occurred during the monitor evaluation.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationState());
        hashCode = 31 * hashCode + Objects.hashCode(windowStartDatetime());
        hashCode = 31 * hashCode + Objects.hashCode(windowEndDatetime());
        hashCode = 31 * hashCode + Objects.hashCode(predictorEvent());
        hashCode = 31 * hashCode + Objects.hashCode(monitorDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricResults() ? metricResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numItemsEvaluated());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictorMonitorEvaluation)) {
            return false;
        }
        PredictorMonitorEvaluation other = (PredictorMonitorEvaluation) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(monitorArn(), other.monitorArn())
                && Objects.equals(evaluationTime(), other.evaluationTime())
                && Objects.equals(evaluationState(), other.evaluationState())
                && Objects.equals(windowStartDatetime(), other.windowStartDatetime())
                && Objects.equals(windowEndDatetime(), other.windowEndDatetime())
                && Objects.equals(predictorEvent(), other.predictorEvent())
                && Objects.equals(monitorDataSource(), other.monitorDataSource())
                && hasMetricResults() == other.hasMetricResults() && Objects.equals(metricResults(), other.metricResults())
                && Objects.equals(numItemsEvaluated(), other.numItemsEvaluated()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictorMonitorEvaluation").add("ResourceArn", resourceArn()).add("MonitorArn", monitorArn())
                .add("EvaluationTime", evaluationTime()).add("EvaluationState", evaluationState())
                .add("WindowStartDatetime", windowStartDatetime()).add("WindowEndDatetime", windowEndDatetime())
                .add("PredictorEvent", predictorEvent()).add("MonitorDataSource", monitorDataSource())
                .add("MetricResults", hasMetricResults() ? metricResults() : null).add("NumItemsEvaluated", numItemsEvaluated())
                .add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "MonitorArn":
            return Optional.ofNullable(clazz.cast(monitorArn()));
        case "EvaluationTime":
            return Optional.ofNullable(clazz.cast(evaluationTime()));
        case "EvaluationState":
            return Optional.ofNullable(clazz.cast(evaluationState()));
        case "WindowStartDatetime":
            return Optional.ofNullable(clazz.cast(windowStartDatetime()));
        case "WindowEndDatetime":
            return Optional.ofNullable(clazz.cast(windowEndDatetime()));
        case "PredictorEvent":
            return Optional.ofNullable(clazz.cast(predictorEvent()));
        case "MonitorDataSource":
            return Optional.ofNullable(clazz.cast(monitorDataSource()));
        case "MetricResults":
            return Optional.ofNullable(clazz.cast(metricResults()));
        case "NumItemsEvaluated":
            return Optional.ofNullable(clazz.cast(numItemsEvaluated()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("MonitorArn", MONITOR_ARN_FIELD);
        map.put("EvaluationTime", EVALUATION_TIME_FIELD);
        map.put("EvaluationState", EVALUATION_STATE_FIELD);
        map.put("WindowStartDatetime", WINDOW_START_DATETIME_FIELD);
        map.put("WindowEndDatetime", WINDOW_END_DATETIME_FIELD);
        map.put("PredictorEvent", PREDICTOR_EVENT_FIELD);
        map.put("MonitorDataSource", MONITOR_DATA_SOURCE_FIELD);
        map.put("MetricResults", METRIC_RESULTS_FIELD);
        map.put("NumItemsEvaluated", NUM_ITEMS_EVALUATED_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictorMonitorEvaluation, T> g) {
        return obj -> g.apply((PredictorMonitorEvaluation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictorMonitorEvaluation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource to monitor.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource to monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the monitor resource.
         * </p>
         * 
         * @param monitorArn
         *        The Amazon Resource Name (ARN) of the monitor resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArn(String monitorArn);

        /**
         * <p>
         * The timestamp that indicates when the monitor evaluation was started.
         * </p>
         * 
         * @param evaluationTime
         *        The timestamp that indicates when the monitor evaluation was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationTime(Instant evaluationTime);

        /**
         * <p>
         * The status of the monitor evaluation. The state can be <code>SUCCESS</code> or <code>FAILURE</code>.
         * </p>
         * 
         * @param evaluationState
         *        The status of the monitor evaluation. The state can be <code>SUCCESS</code> or <code>FAILURE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationState(String evaluationState);

        /**
         * <p>
         * The timestamp that indicates the start of the window that is used for monitor evaluation.
         * </p>
         * 
         * @param windowStartDatetime
         *        The timestamp that indicates the start of the window that is used for monitor evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowStartDatetime(Instant windowStartDatetime);

        /**
         * <p>
         * The timestamp that indicates the end of the window that is used for monitor evaluation.
         * </p>
         * 
         * @param windowEndDatetime
         *        The timestamp that indicates the end of the window that is used for monitor evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowEndDatetime(Instant windowEndDatetime);

        /**
         * <p>
         * Provides details about a predictor event, such as a retraining.
         * </p>
         * 
         * @param predictorEvent
         *        Provides details about a predictor event, such as a retraining.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorEvent(PredictorEvent predictorEvent);

        /**
         * <p>
         * Provides details about a predictor event, such as a retraining.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredictorEvent.Builder} avoiding the need
         * to create one manually via {@link PredictorEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredictorEvent.Builder#build()} is called immediately and its
         * result is passed to {@link #predictorEvent(PredictorEvent)}.
         * 
         * @param predictorEvent
         *        a consumer that will call methods on {@link PredictorEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictorEvent(PredictorEvent)
         */
        default Builder predictorEvent(Consumer<PredictorEvent.Builder> predictorEvent) {
            return predictorEvent(PredictorEvent.builder().applyMutation(predictorEvent).build());
        }

        /**
         * <p>
         * The source of the data the monitor resource used during the evaluation.
         * </p>
         * 
         * @param monitorDataSource
         *        The source of the data the monitor resource used during the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorDataSource(MonitorDataSource monitorDataSource);

        /**
         * <p>
         * The source of the data the monitor resource used during the evaluation.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitorDataSource.Builder} avoiding the
         * need to create one manually via {@link MonitorDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitorDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #monitorDataSource(MonitorDataSource)}.
         * 
         * @param monitorDataSource
         *        a consumer that will call methods on {@link MonitorDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitorDataSource(MonitorDataSource)
         */
        default Builder monitorDataSource(Consumer<MonitorDataSource.Builder> monitorDataSource) {
            return monitorDataSource(MonitorDataSource.builder().applyMutation(monitorDataSource).build());
        }

        /**
         * <p>
         * A list of metrics Forecast calculated when monitoring a predictor. You can compare the value for each metric
         * in the list to the metric's value in the <a>Baseline</a> to see how your predictor's performance is changing.
         * </p>
         * 
         * @param metricResults
         *        A list of metrics Forecast calculated when monitoring a predictor. You can compare the value for each
         *        metric in the list to the metric's value in the <a>Baseline</a> to see how your predictor's
         *        performance is changing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricResults(Collection<MetricResult> metricResults);

        /**
         * <p>
         * A list of metrics Forecast calculated when monitoring a predictor. You can compare the value for each metric
         * in the list to the metric's value in the <a>Baseline</a> to see how your predictor's performance is changing.
         * </p>
         * 
         * @param metricResults
         *        A list of metrics Forecast calculated when monitoring a predictor. You can compare the value for each
         *        metric in the list to the metric's value in the <a>Baseline</a> to see how your predictor's
         *        performance is changing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricResults(MetricResult... metricResults);

        /**
         * <p>
         * A list of metrics Forecast calculated when monitoring a predictor. You can compare the value for each metric
         * in the list to the metric's value in the <a>Baseline</a> to see how your predictor's performance is changing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.MetricResult.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.forecast.model.MetricResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.MetricResult.Builder#build()} is called immediately and
         * its result is passed to {@link #metricResults(List<MetricResult>)}.
         * 
         * @param metricResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.MetricResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricResults(java.util.Collection<MetricResult>)
         */
        Builder metricResults(Consumer<MetricResult.Builder>... metricResults);

        /**
         * <p>
         * The number of items considered during the evaluation.
         * </p>
         * 
         * @param numItemsEvaluated
         *        The number of items considered during the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numItemsEvaluated(Long numItemsEvaluated);

        /**
         * <p>
         * Information about any errors that may have occurred during the monitor evaluation.
         * </p>
         * 
         * @param message
         *        Information about any errors that may have occurred during the monitor evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String monitorArn;

        private Instant evaluationTime;

        private String evaluationState;

        private Instant windowStartDatetime;

        private Instant windowEndDatetime;

        private PredictorEvent predictorEvent;

        private MonitorDataSource monitorDataSource;

        private List<MetricResult> metricResults = DefaultSdkAutoConstructList.getInstance();

        private Long numItemsEvaluated;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictorMonitorEvaluation model) {
            resourceArn(model.resourceArn);
            monitorArn(model.monitorArn);
            evaluationTime(model.evaluationTime);
            evaluationState(model.evaluationState);
            windowStartDatetime(model.windowStartDatetime);
            windowEndDatetime(model.windowEndDatetime);
            predictorEvent(model.predictorEvent);
            monitorDataSource(model.monitorDataSource);
            metricResults(model.metricResults);
            numItemsEvaluated(model.numItemsEvaluated);
            message(model.message);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getMonitorArn() {
            return monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final Instant getEvaluationTime() {
            return evaluationTime;
        }

        public final void setEvaluationTime(Instant evaluationTime) {
            this.evaluationTime = evaluationTime;
        }

        @Override
        public final Builder evaluationTime(Instant evaluationTime) {
            this.evaluationTime = evaluationTime;
            return this;
        }

        public final String getEvaluationState() {
            return evaluationState;
        }

        public final void setEvaluationState(String evaluationState) {
            this.evaluationState = evaluationState;
        }

        @Override
        public final Builder evaluationState(String evaluationState) {
            this.evaluationState = evaluationState;
            return this;
        }

        public final Instant getWindowStartDatetime() {
            return windowStartDatetime;
        }

        public final void setWindowStartDatetime(Instant windowStartDatetime) {
            this.windowStartDatetime = windowStartDatetime;
        }

        @Override
        public final Builder windowStartDatetime(Instant windowStartDatetime) {
            this.windowStartDatetime = windowStartDatetime;
            return this;
        }

        public final Instant getWindowEndDatetime() {
            return windowEndDatetime;
        }

        public final void setWindowEndDatetime(Instant windowEndDatetime) {
            this.windowEndDatetime = windowEndDatetime;
        }

        @Override
        public final Builder windowEndDatetime(Instant windowEndDatetime) {
            this.windowEndDatetime = windowEndDatetime;
            return this;
        }

        public final PredictorEvent.Builder getPredictorEvent() {
            return predictorEvent != null ? predictorEvent.toBuilder() : null;
        }

        public final void setPredictorEvent(PredictorEvent.BuilderImpl predictorEvent) {
            this.predictorEvent = predictorEvent != null ? predictorEvent.build() : null;
        }

        @Override
        public final Builder predictorEvent(PredictorEvent predictorEvent) {
            this.predictorEvent = predictorEvent;
            return this;
        }

        public final MonitorDataSource.Builder getMonitorDataSource() {
            return monitorDataSource != null ? monitorDataSource.toBuilder() : null;
        }

        public final void setMonitorDataSource(MonitorDataSource.BuilderImpl monitorDataSource) {
            this.monitorDataSource = monitorDataSource != null ? monitorDataSource.build() : null;
        }

        @Override
        public final Builder monitorDataSource(MonitorDataSource monitorDataSource) {
            this.monitorDataSource = monitorDataSource;
            return this;
        }

        public final List<MetricResult.Builder> getMetricResults() {
            List<MetricResult.Builder> result = MetricResultsCopier.copyToBuilder(this.metricResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricResults(Collection<MetricResult.BuilderImpl> metricResults) {
            this.metricResults = MetricResultsCopier.copyFromBuilder(metricResults);
        }

        @Override
        public final Builder metricResults(Collection<MetricResult> metricResults) {
            this.metricResults = MetricResultsCopier.copy(metricResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(MetricResult... metricResults) {
            metricResults(Arrays.asList(metricResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(Consumer<MetricResult.Builder>... metricResults) {
            metricResults(Stream.of(metricResults).map(c -> MetricResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getNumItemsEvaluated() {
            return numItemsEvaluated;
        }

        public final void setNumItemsEvaluated(Long numItemsEvaluated) {
            this.numItemsEvaluated = numItemsEvaluated;
        }

        @Override
        public final Builder numItemsEvaluated(Long numItemsEvaluated) {
            this.numItemsEvaluated = numItemsEvaluated;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public PredictorMonitorEvaluation build() {
            return new PredictorMonitorEvaluation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
