/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An attribute of a schema, which defines a dataset field. A schema attribute is required for every field in a dataset.
 * The <a href="https://docs.aws.amazon.com/forecast/latest/dg/API_Schema.html">Schema</a> object contains an array of
 * <code>SchemaAttribute</code> objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaAttribute implements SdkPojo, Serializable, ToCopyableBuilder<SchemaAttribute.Builder, SchemaAttribute> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(SchemaAttribute::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<String> ATTRIBUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeType").getter(getter(SchemaAttribute::attributeTypeAsString))
            .setter(setter(Builder::attributeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            ATTRIBUTE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final String attributeType;

    private SchemaAttribute(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeType = builder.attributeType;
    }

    /**
     * <p>
     * The name of the dataset field.
     * </p>
     * 
     * @return The name of the dataset field.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The data type of the field.
     * </p>
     * <p>
     * For a related time series dataset, other than date, item_id, and forecast dimensions attributes, all attributes
     * should be of numerical type (integer/float).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeType}
     * will return {@link AttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeTypeAsString}.
     * </p>
     * 
     * @return The data type of the field.</p>
     *         <p>
     *         For a related time series dataset, other than date, item_id, and forecast dimensions attributes, all
     *         attributes should be of numerical type (integer/float).
     * @see AttributeType
     */
    public final AttributeType attributeType() {
        return AttributeType.fromValue(attributeType);
    }

    /**
     * <p>
     * The data type of the field.
     * </p>
     * <p>
     * For a related time series dataset, other than date, item_id, and forecast dimensions attributes, all attributes
     * should be of numerical type (integer/float).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeType}
     * will return {@link AttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeTypeAsString}.
     * </p>
     * 
     * @return The data type of the field.</p>
     *         <p>
     *         For a related time series dataset, other than date, item_id, and forecast dimensions attributes, all
     *         attributes should be of numerical type (integer/float).
     * @see AttributeType
     */
    public final String attributeTypeAsString() {
        return attributeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaAttribute)) {
            return false;
        }
        SchemaAttribute other = (SchemaAttribute) obj;
        return Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(attributeTypeAsString(), other.attributeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaAttribute").add("AttributeName", attributeName())
                .add("AttributeType", attributeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "AttributeType":
            return Optional.ofNullable(clazz.cast(attributeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("AttributeType", ATTRIBUTE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaAttribute, T> g) {
        return obj -> g.apply((SchemaAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaAttribute> {
        /**
         * <p>
         * The name of the dataset field.
         * </p>
         * 
         * @param attributeName
         *        The name of the dataset field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The data type of the field.
         * </p>
         * <p>
         * For a related time series dataset, other than date, item_id, and forecast dimensions attributes, all
         * attributes should be of numerical type (integer/float).
         * </p>
         * 
         * @param attributeType
         *        The data type of the field.</p>
         *        <p>
         *        For a related time series dataset, other than date, item_id, and forecast dimensions attributes, all
         *        attributes should be of numerical type (integer/float).
         * @see AttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeType
         */
        Builder attributeType(String attributeType);

        /**
         * <p>
         * The data type of the field.
         * </p>
         * <p>
         * For a related time series dataset, other than date, item_id, and forecast dimensions attributes, all
         * attributes should be of numerical type (integer/float).
         * </p>
         * 
         * @param attributeType
         *        The data type of the field.</p>
         *        <p>
         *        For a related time series dataset, other than date, item_id, and forecast dimensions attributes, all
         *        attributes should be of numerical type (integer/float).
         * @see AttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeType
         */
        Builder attributeType(AttributeType attributeType);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private String attributeType;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaAttribute model) {
            attributeName(model.attributeName);
            attributeType(model.attributeType);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getAttributeType() {
            return attributeType;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        @Override
        public final Builder attributeType(AttributeType attributeType) {
            this.attributeType(attributeType == null ? null : attributeType.toString());
            return this;
        }

        @Override
        public SchemaAttribute build() {
            return new SchemaAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
