/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides statistics for each data field imported into to an Amazon Forecast dataset with the <a
 * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html">CreateDatasetImportJob</a>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Statistics implements SdkPojo, Serializable, ToCopyableBuilder<Statistics.Builder, Statistics> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(Statistics::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<Integer> COUNT_DISTINCT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CountDistinct").getter(getter(Statistics::countDistinct)).setter(setter(Builder::countDistinct))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountDistinct").build()).build();

    private static final SdkField<Integer> COUNT_NULL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CountNull").getter(getter(Statistics::countNull)).setter(setter(Builder::countNull))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountNull").build()).build();

    private static final SdkField<Integer> COUNT_NAN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CountNan").getter(getter(Statistics::countNan)).setter(setter(Builder::countNan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountNan").build()).build();

    private static final SdkField<String> MIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Min")
            .getter(getter(Statistics::min)).setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Min").build()).build();

    private static final SdkField<String> MAX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Max")
            .getter(getter(Statistics::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()).build();

    private static final SdkField<Double> AVG_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Avg")
            .getter(getter(Statistics::avg)).setter(setter(Builder::avg))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Avg").build()).build();

    private static final SdkField<Double> STDDEV_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Stddev")
            .getter(getter(Statistics::stddev)).setter(setter(Builder::stddev))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stddev").build()).build();

    private static final SdkField<Long> COUNT_LONG_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("CountLong")
            .getter(getter(Statistics::countLong)).setter(setter(Builder::countLong))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountLong").build()).build();

    private static final SdkField<Long> COUNT_DISTINCT_LONG_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CountDistinctLong").getter(getter(Statistics::countDistinctLong))
            .setter(setter(Builder::countDistinctLong))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountDistinctLong").build()).build();

    private static final SdkField<Long> COUNT_NULL_LONG_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CountNullLong").getter(getter(Statistics::countNullLong)).setter(setter(Builder::countNullLong))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountNullLong").build()).build();

    private static final SdkField<Long> COUNT_NAN_LONG_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CountNanLong").getter(getter(Statistics::countNanLong)).setter(setter(Builder::countNanLong))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountNanLong").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD,
            COUNT_DISTINCT_FIELD, COUNT_NULL_FIELD, COUNT_NAN_FIELD, MIN_FIELD, MAX_FIELD, AVG_FIELD, STDDEV_FIELD,
            COUNT_LONG_FIELD, COUNT_DISTINCT_LONG_FIELD, COUNT_NULL_LONG_FIELD, COUNT_NAN_LONG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer count;

    private final Integer countDistinct;

    private final Integer countNull;

    private final Integer countNan;

    private final String min;

    private final String max;

    private final Double avg;

    private final Double stddev;

    private final Long countLong;

    private final Long countDistinctLong;

    private final Long countNullLong;

    private final Long countNanLong;

    private Statistics(BuilderImpl builder) {
        this.count = builder.count;
        this.countDistinct = builder.countDistinct;
        this.countNull = builder.countNull;
        this.countNan = builder.countNan;
        this.min = builder.min;
        this.max = builder.max;
        this.avg = builder.avg;
        this.stddev = builder.stddev;
        this.countLong = builder.countLong;
        this.countDistinctLong = builder.countDistinctLong;
        this.countNullLong = builder.countNullLong;
        this.countNanLong = builder.countNanLong;
    }

    /**
     * <p>
     * The number of values in the field. If the response value is -1, refer to <code>CountLong</code>.
     * </p>
     * 
     * @return The number of values in the field. If the response value is -1, refer to <code>CountLong</code>.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The number of distinct values in the field. If the response value is -1, refer to <code>CountDistinctLong</code>.
     * </p>
     * 
     * @return The number of distinct values in the field. If the response value is -1, refer to
     *         <code>CountDistinctLong</code>.
     */
    public final Integer countDistinct() {
        return countDistinct;
    }

    /**
     * <p>
     * The number of null values in the field. If the response value is -1, refer to <code>CountNullLong</code>.
     * </p>
     * 
     * @return The number of null values in the field. If the response value is -1, refer to <code>CountNullLong</code>.
     */
    public final Integer countNull() {
        return countNull;
    }

    /**
     * <p>
     * The number of NAN (not a number) values in the field. If the response value is -1, refer to
     * <code>CountNanLong</code>.
     * </p>
     * 
     * @return The number of NAN (not a number) values in the field. If the response value is -1, refer to
     *         <code>CountNanLong</code>.
     */
    public final Integer countNan() {
        return countNan;
    }

    /**
     * <p>
     * For a numeric field, the minimum value in the field.
     * </p>
     * 
     * @return For a numeric field, the minimum value in the field.
     */
    public final String min() {
        return min;
    }

    /**
     * <p>
     * For a numeric field, the maximum value in the field.
     * </p>
     * 
     * @return For a numeric field, the maximum value in the field.
     */
    public final String max() {
        return max;
    }

    /**
     * <p>
     * For a numeric field, the average value in the field.
     * </p>
     * 
     * @return For a numeric field, the average value in the field.
     */
    public final Double avg() {
        return avg;
    }

    /**
     * <p>
     * For a numeric field, the standard deviation.
     * </p>
     * 
     * @return For a numeric field, the standard deviation.
     */
    public final Double stddev() {
        return stddev;
    }

    /**
     * <p>
     * The number of values in the field. <code>CountLong</code> is used instead of <code>Count</code> if the value is
     * greater than 2,147,483,647.
     * </p>
     * 
     * @return The number of values in the field. <code>CountLong</code> is used instead of <code>Count</code> if the
     *         value is greater than 2,147,483,647.
     */
    public final Long countLong() {
        return countLong;
    }

    /**
     * <p>
     * The number of distinct values in the field. <code>CountDistinctLong</code> is used instead of
     * <code>CountDistinct</code> if the value is greater than 2,147,483,647.
     * </p>
     * 
     * @return The number of distinct values in the field. <code>CountDistinctLong</code> is used instead of
     *         <code>CountDistinct</code> if the value is greater than 2,147,483,647.
     */
    public final Long countDistinctLong() {
        return countDistinctLong;
    }

    /**
     * <p>
     * The number of null values in the field. <code>CountNullLong</code> is used instead of <code>CountNull</code> if
     * the value is greater than 2,147,483,647.
     * </p>
     * 
     * @return The number of null values in the field. <code>CountNullLong</code> is used instead of
     *         <code>CountNull</code> if the value is greater than 2,147,483,647.
     */
    public final Long countNullLong() {
        return countNullLong;
    }

    /**
     * <p>
     * The number of NAN (not a number) values in the field. <code>CountNanLong</code> is used instead of
     * <code>CountNan</code> if the value is greater than 2,147,483,647.
     * </p>
     * 
     * @return The number of NAN (not a number) values in the field. <code>CountNanLong</code> is used instead of
     *         <code>CountNan</code> if the value is greater than 2,147,483,647.
     */
    public final Long countNanLong() {
        return countNanLong;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(countDistinct());
        hashCode = 31 * hashCode + Objects.hashCode(countNull());
        hashCode = 31 * hashCode + Objects.hashCode(countNan());
        hashCode = 31 * hashCode + Objects.hashCode(min());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        hashCode = 31 * hashCode + Objects.hashCode(avg());
        hashCode = 31 * hashCode + Objects.hashCode(stddev());
        hashCode = 31 * hashCode + Objects.hashCode(countLong());
        hashCode = 31 * hashCode + Objects.hashCode(countDistinctLong());
        hashCode = 31 * hashCode + Objects.hashCode(countNullLong());
        hashCode = 31 * hashCode + Objects.hashCode(countNanLong());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statistics)) {
            return false;
        }
        Statistics other = (Statistics) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(countDistinct(), other.countDistinct())
                && Objects.equals(countNull(), other.countNull()) && Objects.equals(countNan(), other.countNan())
                && Objects.equals(min(), other.min()) && Objects.equals(max(), other.max()) && Objects.equals(avg(), other.avg())
                && Objects.equals(stddev(), other.stddev()) && Objects.equals(countLong(), other.countLong())
                && Objects.equals(countDistinctLong(), other.countDistinctLong())
                && Objects.equals(countNullLong(), other.countNullLong()) && Objects.equals(countNanLong(), other.countNanLong());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Statistics").add("Count", count()).add("CountDistinct", countDistinct())
                .add("CountNull", countNull()).add("CountNan", countNan()).add("Min", min()).add("Max", max()).add("Avg", avg())
                .add("Stddev", stddev()).add("CountLong", countLong()).add("CountDistinctLong", countDistinctLong())
                .add("CountNullLong", countNullLong()).add("CountNanLong", countNanLong()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "CountDistinct":
            return Optional.ofNullable(clazz.cast(countDistinct()));
        case "CountNull":
            return Optional.ofNullable(clazz.cast(countNull()));
        case "CountNan":
            return Optional.ofNullable(clazz.cast(countNan()));
        case "Min":
            return Optional.ofNullable(clazz.cast(min()));
        case "Max":
            return Optional.ofNullable(clazz.cast(max()));
        case "Avg":
            return Optional.ofNullable(clazz.cast(avg()));
        case "Stddev":
            return Optional.ofNullable(clazz.cast(stddev()));
        case "CountLong":
            return Optional.ofNullable(clazz.cast(countLong()));
        case "CountDistinctLong":
            return Optional.ofNullable(clazz.cast(countDistinctLong()));
        case "CountNullLong":
            return Optional.ofNullable(clazz.cast(countNullLong()));
        case "CountNanLong":
            return Optional.ofNullable(clazz.cast(countNanLong()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Count", COUNT_FIELD);
        map.put("CountDistinct", COUNT_DISTINCT_FIELD);
        map.put("CountNull", COUNT_NULL_FIELD);
        map.put("CountNan", COUNT_NAN_FIELD);
        map.put("Min", MIN_FIELD);
        map.put("Max", MAX_FIELD);
        map.put("Avg", AVG_FIELD);
        map.put("Stddev", STDDEV_FIELD);
        map.put("CountLong", COUNT_LONG_FIELD);
        map.put("CountDistinctLong", COUNT_DISTINCT_LONG_FIELD);
        map.put("CountNullLong", COUNT_NULL_LONG_FIELD);
        map.put("CountNanLong", COUNT_NAN_LONG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Statistics, T> g) {
        return obj -> g.apply((Statistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Statistics> {
        /**
         * <p>
         * The number of values in the field. If the response value is -1, refer to <code>CountLong</code>.
         * </p>
         * 
         * @param count
         *        The number of values in the field. If the response value is -1, refer to <code>CountLong</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The number of distinct values in the field. If the response value is -1, refer to
         * <code>CountDistinctLong</code>.
         * </p>
         * 
         * @param countDistinct
         *        The number of distinct values in the field. If the response value is -1, refer to
         *        <code>CountDistinctLong</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countDistinct(Integer countDistinct);

        /**
         * <p>
         * The number of null values in the field. If the response value is -1, refer to <code>CountNullLong</code>.
         * </p>
         * 
         * @param countNull
         *        The number of null values in the field. If the response value is -1, refer to
         *        <code>CountNullLong</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countNull(Integer countNull);

        /**
         * <p>
         * The number of NAN (not a number) values in the field. If the response value is -1, refer to
         * <code>CountNanLong</code>.
         * </p>
         * 
         * @param countNan
         *        The number of NAN (not a number) values in the field. If the response value is -1, refer to
         *        <code>CountNanLong</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countNan(Integer countNan);

        /**
         * <p>
         * For a numeric field, the minimum value in the field.
         * </p>
         * 
         * @param min
         *        For a numeric field, the minimum value in the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(String min);

        /**
         * <p>
         * For a numeric field, the maximum value in the field.
         * </p>
         * 
         * @param max
         *        For a numeric field, the maximum value in the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(String max);

        /**
         * <p>
         * For a numeric field, the average value in the field.
         * </p>
         * 
         * @param avg
         *        For a numeric field, the average value in the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avg(Double avg);

        /**
         * <p>
         * For a numeric field, the standard deviation.
         * </p>
         * 
         * @param stddev
         *        For a numeric field, the standard deviation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stddev(Double stddev);

        /**
         * <p>
         * The number of values in the field. <code>CountLong</code> is used instead of <code>Count</code> if the value
         * is greater than 2,147,483,647.
         * </p>
         * 
         * @param countLong
         *        The number of values in the field. <code>CountLong</code> is used instead of <code>Count</code> if the
         *        value is greater than 2,147,483,647.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countLong(Long countLong);

        /**
         * <p>
         * The number of distinct values in the field. <code>CountDistinctLong</code> is used instead of
         * <code>CountDistinct</code> if the value is greater than 2,147,483,647.
         * </p>
         * 
         * @param countDistinctLong
         *        The number of distinct values in the field. <code>CountDistinctLong</code> is used instead of
         *        <code>CountDistinct</code> if the value is greater than 2,147,483,647.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countDistinctLong(Long countDistinctLong);

        /**
         * <p>
         * The number of null values in the field. <code>CountNullLong</code> is used instead of <code>CountNull</code>
         * if the value is greater than 2,147,483,647.
         * </p>
         * 
         * @param countNullLong
         *        The number of null values in the field. <code>CountNullLong</code> is used instead of
         *        <code>CountNull</code> if the value is greater than 2,147,483,647.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countNullLong(Long countNullLong);

        /**
         * <p>
         * The number of NAN (not a number) values in the field. <code>CountNanLong</code> is used instead of
         * <code>CountNan</code> if the value is greater than 2,147,483,647.
         * </p>
         * 
         * @param countNanLong
         *        The number of NAN (not a number) values in the field. <code>CountNanLong</code> is used instead of
         *        <code>CountNan</code> if the value is greater than 2,147,483,647.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countNanLong(Long countNanLong);
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private Integer countDistinct;

        private Integer countNull;

        private Integer countNan;

        private String min;

        private String max;

        private Double avg;

        private Double stddev;

        private Long countLong;

        private Long countDistinctLong;

        private Long countNullLong;

        private Long countNanLong;

        private BuilderImpl() {
        }

        private BuilderImpl(Statistics model) {
            count(model.count);
            countDistinct(model.countDistinct);
            countNull(model.countNull);
            countNan(model.countNan);
            min(model.min);
            max(model.max);
            avg(model.avg);
            stddev(model.stddev);
            countLong(model.countLong);
            countDistinctLong(model.countDistinctLong);
            countNullLong(model.countNullLong);
            countNanLong(model.countNanLong);
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Integer getCountDistinct() {
            return countDistinct;
        }

        public final void setCountDistinct(Integer countDistinct) {
            this.countDistinct = countDistinct;
        }

        @Override
        public final Builder countDistinct(Integer countDistinct) {
            this.countDistinct = countDistinct;
            return this;
        }

        public final Integer getCountNull() {
            return countNull;
        }

        public final void setCountNull(Integer countNull) {
            this.countNull = countNull;
        }

        @Override
        public final Builder countNull(Integer countNull) {
            this.countNull = countNull;
            return this;
        }

        public final Integer getCountNan() {
            return countNan;
        }

        public final void setCountNan(Integer countNan) {
            this.countNan = countNan;
        }

        @Override
        public final Builder countNan(Integer countNan) {
            this.countNan = countNan;
            return this;
        }

        public final String getMin() {
            return min;
        }

        public final void setMin(String min) {
            this.min = min;
        }

        @Override
        public final Builder min(String min) {
            this.min = min;
            return this;
        }

        public final String getMax() {
            return max;
        }

        public final void setMax(String max) {
            this.max = max;
        }

        @Override
        public final Builder max(String max) {
            this.max = max;
            return this;
        }

        public final Double getAvg() {
            return avg;
        }

        public final void setAvg(Double avg) {
            this.avg = avg;
        }

        @Override
        public final Builder avg(Double avg) {
            this.avg = avg;
            return this;
        }

        public final Double getStddev() {
            return stddev;
        }

        public final void setStddev(Double stddev) {
            this.stddev = stddev;
        }

        @Override
        public final Builder stddev(Double stddev) {
            this.stddev = stddev;
            return this;
        }

        public final Long getCountLong() {
            return countLong;
        }

        public final void setCountLong(Long countLong) {
            this.countLong = countLong;
        }

        @Override
        public final Builder countLong(Long countLong) {
            this.countLong = countLong;
            return this;
        }

        public final Long getCountDistinctLong() {
            return countDistinctLong;
        }

        public final void setCountDistinctLong(Long countDistinctLong) {
            this.countDistinctLong = countDistinctLong;
        }

        @Override
        public final Builder countDistinctLong(Long countDistinctLong) {
            this.countDistinctLong = countDistinctLong;
            return this;
        }

        public final Long getCountNullLong() {
            return countNullLong;
        }

        public final void setCountNullLong(Long countNullLong) {
            this.countNullLong = countNullLong;
        }

        @Override
        public final Builder countNullLong(Long countNullLong) {
            this.countNullLong = countNullLong;
            return this;
        }

        public final Long getCountNanLong() {
            return countNanLong;
        }

        public final void setCountNanLong(Long countNanLong) {
            this.countNanLong = countNanLong;
        }

        @Override
        public final Builder countNanLong(Long countNanLong) {
            this.countNanLong = countNanLong;
            return this;
        }

        @Override
        public Statistics build() {
            return new Statistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
