/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates a subset of items within an attribute that are modified. For example, you can use this operation to create a
 * subset of items that cost $5 or less. To do this, you specify <code>"AttributeName": "price"</code>,
 * <code>"AttributeValue": "5"</code>, and <code>"Condition": "LESS_THAN"</code>. Pair this operation with the
 * <a>Action</a> operation within the <a>CreateWhatIfForecastRequest$TimeSeriesTransformations</a> operation to define
 * how the attribute is modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSeriesCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeSeriesCondition.Builder, TimeSeriesCondition> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(TimeSeriesCondition::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<String> ATTRIBUTE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeValue").getter(getter(TimeSeriesCondition::attributeValue))
            .setter(setter(Builder::attributeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()).build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Condition").getter(getter(TimeSeriesCondition::conditionAsString)).setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            ATTRIBUTE_VALUE_FIELD, CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final String attributeValue;

    private final String condition;

    private TimeSeriesCondition(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
        this.condition = builder.condition;
    }

    /**
     * <p>
     * The item_id, dimension name, IM name, or timestamp that you are modifying.
     * </p>
     * 
     * @return The item_id, dimension name, IM name, or timestamp that you are modifying.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The value that is applied for the chosen <code>Condition</code>.
     * </p>
     * 
     * @return The value that is applied for the chosen <code>Condition</code>.
     */
    public final String attributeValue() {
        return attributeValue;
    }

    /**
     * <p>
     * The condition to apply. Valid values are <code>EQUALS</code>, <code>NOT_EQUALS</code>, <code>LESS_THAN</code> and
     * <code>GREATER_THAN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link Condition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionAsString}.
     * </p>
     * 
     * @return The condition to apply. Valid values are <code>EQUALS</code>, <code>NOT_EQUALS</code>,
     *         <code>LESS_THAN</code> and <code>GREATER_THAN</code>.
     * @see Condition
     */
    public final Condition condition() {
        return Condition.fromValue(condition);
    }

    /**
     * <p>
     * The condition to apply. Valid values are <code>EQUALS</code>, <code>NOT_EQUALS</code>, <code>LESS_THAN</code> and
     * <code>GREATER_THAN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link Condition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionAsString}.
     * </p>
     * 
     * @return The condition to apply. Valid values are <code>EQUALS</code>, <code>NOT_EQUALS</code>,
     *         <code>LESS_THAN</code> and <code>GREATER_THAN</code>.
     * @see Condition
     */
    public final String conditionAsString() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeValue());
        hashCode = 31 * hashCode + Objects.hashCode(conditionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesCondition)) {
            return false;
        }
        TimeSeriesCondition other = (TimeSeriesCondition) obj;
        return Objects.equals(attributeName(), other.attributeName()) && Objects.equals(attributeValue(), other.attributeValue())
                && Objects.equals(conditionAsString(), other.conditionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSeriesCondition").add("AttributeName", attributeName())
                .add("AttributeValue", attributeValue()).add("Condition", conditionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "AttributeValue":
            return Optional.ofNullable(clazz.cast(attributeValue()));
        case "Condition":
            return Optional.ofNullable(clazz.cast(conditionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("AttributeValue", ATTRIBUTE_VALUE_FIELD);
        map.put("Condition", CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesCondition, T> g) {
        return obj -> g.apply((TimeSeriesCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSeriesCondition> {
        /**
         * <p>
         * The item_id, dimension name, IM name, or timestamp that you are modifying.
         * </p>
         * 
         * @param attributeName
         *        The item_id, dimension name, IM name, or timestamp that you are modifying.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The value that is applied for the chosen <code>Condition</code>.
         * </p>
         * 
         * @param attributeValue
         *        The value that is applied for the chosen <code>Condition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValue(String attributeValue);

        /**
         * <p>
         * The condition to apply. Valid values are <code>EQUALS</code>, <code>NOT_EQUALS</code>, <code>LESS_THAN</code>
         * and <code>GREATER_THAN</code>.
         * </p>
         * 
         * @param condition
         *        The condition to apply. Valid values are <code>EQUALS</code>, <code>NOT_EQUALS</code>,
         *        <code>LESS_THAN</code> and <code>GREATER_THAN</code>.
         * @see Condition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Condition
         */
        Builder condition(String condition);

        /**
         * <p>
         * The condition to apply. Valid values are <code>EQUALS</code>, <code>NOT_EQUALS</code>, <code>LESS_THAN</code>
         * and <code>GREATER_THAN</code>.
         * </p>
         * 
         * @param condition
         *        The condition to apply. Valid values are <code>EQUALS</code>, <code>NOT_EQUALS</code>,
         *        <code>LESS_THAN</code> and <code>GREATER_THAN</code>.
         * @see Condition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Condition
         */
        Builder condition(Condition condition);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private String attributeValue;

        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesCondition model) {
            attributeName(model.attributeName);
            attributeValue(model.attributeValue);
            condition(model.condition);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getAttributeValue() {
            return attributeValue;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final String getCondition() {
            return condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public final Builder condition(Condition condition) {
            this.condition(condition == null ? null : condition.toString());
            return this;
        }

        @Override
        public TimeSeriesCondition build() {
            return new TimeSeriesCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
