/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the import file that contains the time series for which you want to create forecasts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSeriesIdentifiers implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeSeriesIdentifiers.Builder, TimeSeriesIdentifiers> {
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(TimeSeriesIdentifiers::dataSource)).setter(setter(Builder::dataSource))
            .constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.<Schema> builder(MarshallingType.SDK_POJO).memberName("Schema")
            .getter(getter(TimeSeriesIdentifiers::schema)).setter(setter(Builder::schema)).constructor(Schema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(TimeSeriesIdentifiers::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD,
            SCHEMA_FIELD, FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataSource dataSource;

    private final Schema schema;

    private final String format;

    private TimeSeriesIdentifiers(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.schema = builder.schema;
        this.format = builder.format;
    }

    /**
     * Returns the value of the DataSource property for this object.
     * 
     * @return The value of the DataSource property for this object.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * Returns the value of the Schema property for this object.
     * 
     * @return The value of the Schema property for this object.
     */
    public final Schema schema() {
        return schema;
    }

    /**
     * <p>
     * The format of the data, either CSV or PARQUET.
     * </p>
     * 
     * @return The format of the data, either CSV or PARQUET.
     */
    public final String format() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesIdentifiers)) {
            return false;
        }
        TimeSeriesIdentifiers other = (TimeSeriesIdentifiers) obj;
        return Objects.equals(dataSource(), other.dataSource()) && Objects.equals(schema(), other.schema())
                && Objects.equals(format(), other.format());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSeriesIdentifiers").add("DataSource", dataSource()).add("Schema", schema())
                .add("Format", format()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        map.put("Format", FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesIdentifiers, T> g) {
        return obj -> g.apply((TimeSeriesIdentifiers) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSeriesIdentifiers> {
        /**
         * Sets the value of the DataSource property for this object.
         *
         * @param dataSource
         *        The new value for the DataSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * Sets the value of the DataSource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * Sets the value of the Schema property for this object.
         *
         * @param schema
         *        The new value for the Schema property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Schema schema);

        /**
         * Sets the value of the Schema property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Schema.Builder} avoiding the need to
         * create one manually via {@link Schema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schema.Builder#build()} is called immediately and its result is
         * passed to {@link #schema(Schema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link Schema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(Schema)
         */
        default Builder schema(Consumer<Schema.Builder> schema) {
            return schema(Schema.builder().applyMutation(schema).build());
        }

        /**
         * <p>
         * The format of the data, either CSV or PARQUET.
         * </p>
         * 
         * @param format
         *        The format of the data, either CSV or PARQUET.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);
    }

    static final class BuilderImpl implements Builder {
        private DataSource dataSource;

        private Schema schema;

        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesIdentifiers model) {
            dataSource(model.dataSource);
            schema(model.schema);
            format(model.format);
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final Schema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public TimeSeriesIdentifiers build() {
            return new TimeSeriesIdentifiers(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
