/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPredictorsResponse extends ForecastResponse implements
        ToCopyableBuilder<ListPredictorsResponse.Builder, ListPredictorsResponse> {
    private static final SdkField<List<PredictorSummary>> PREDICTORS_FIELD = SdkField
            .<List<PredictorSummary>> builder(MarshallingType.LIST)
            .memberName("Predictors")
            .getter(getter(ListPredictorsResponse::predictors))
            .setter(setter(Builder::predictors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predictors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PredictorSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PredictorSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPredictorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTORS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PredictorSummary> predictors;

    private final String nextToken;

    private ListPredictorsResponse(BuilderImpl builder) {
        super(builder);
        this.predictors = builder.predictors;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Predictors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPredictors() {
        return predictors != null && !(predictors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that summarize each predictor's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPredictors} method.
     * </p>
     * 
     * @return An array of objects that summarize each predictor's properties.
     */
    public final List<PredictorSummary> predictors() {
        return predictors;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use the
     * token in the next request.
     * </p>
     * 
     * @return If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
     *         use the token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPredictors() ? predictors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPredictorsResponse)) {
            return false;
        }
        ListPredictorsResponse other = (ListPredictorsResponse) obj;
        return hasPredictors() == other.hasPredictors() && Objects.equals(predictors(), other.predictors())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPredictorsResponse").add("Predictors", hasPredictors() ? predictors() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Predictors":
            return Optional.ofNullable(clazz.cast(predictors()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Predictors", PREDICTORS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPredictorsResponse, T> g) {
        return obj -> g.apply((ListPredictorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPredictorsResponse> {
        /**
         * <p>
         * An array of objects that summarize each predictor's properties.
         * </p>
         * 
         * @param predictors
         *        An array of objects that summarize each predictor's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictors(Collection<PredictorSummary> predictors);

        /**
         * <p>
         * An array of objects that summarize each predictor's properties.
         * </p>
         * 
         * @param predictors
         *        An array of objects that summarize each predictor's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictors(PredictorSummary... predictors);

        /**
         * <p>
         * An array of objects that summarize each predictor's properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.PredictorSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.forecast.model.PredictorSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.PredictorSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #predictors(List<PredictorSummary>)}.
         * 
         * @param predictors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.PredictorSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictors(java.util.Collection<PredictorSummary>)
         */
        Builder predictors(Consumer<PredictorSummary.Builder>... predictors);

        /**
         * <p>
         * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use
         * the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
         *        use the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private List<PredictorSummary> predictors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPredictorsResponse model) {
            super(model);
            predictors(model.predictors);
            nextToken(model.nextToken);
        }

        public final List<PredictorSummary.Builder> getPredictors() {
            List<PredictorSummary.Builder> result = PredictorsCopier.copyToBuilder(this.predictors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredictors(Collection<PredictorSummary.BuilderImpl> predictors) {
            this.predictors = PredictorsCopier.copyFromBuilder(predictors);
        }

        @Override
        public final Builder predictors(Collection<PredictorSummary> predictors) {
            this.predictors = PredictorsCopier.copy(predictors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictors(PredictorSummary... predictors) {
            predictors(Arrays.asList(predictors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictors(Consumer<PredictorSummary.Builder>... predictors) {
            predictors(Stream.of(predictors).map(c -> PredictorSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPredictorsResponse build() {
            return new ListPredictorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
