/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transformation function is a pair of operations that select and modify the rows in a related time series. You
 * select the rows that you want with a condition operation and you modify the rows with a transformation operation. All
 * conditions are joined with an AND operation, meaning that all conditions must be true for the transformation to be
 * applied. Transformations are applied in the order that they are listed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSeriesTransformation implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeSeriesTransformation.Builder, TimeSeriesTransformation> {
    private static final SdkField<Action> ACTION_FIELD = SdkField.<Action> builder(MarshallingType.SDK_POJO).memberName("Action")
            .getter(getter(TimeSeriesTransformation::action)).setter(setter(Builder::action)).constructor(Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<List<TimeSeriesCondition>> TIME_SERIES_CONDITIONS_FIELD = SdkField
            .<List<TimeSeriesCondition>> builder(MarshallingType.LIST)
            .memberName("TimeSeriesConditions")
            .getter(getter(TimeSeriesTransformation::timeSeriesConditions))
            .setter(setter(Builder::timeSeriesConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeSeriesCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeSeriesCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            TIME_SERIES_CONDITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Action action;

    private final List<TimeSeriesCondition> timeSeriesConditions;

    private TimeSeriesTransformation(BuilderImpl builder) {
        this.action = builder.action;
        this.timeSeriesConditions = builder.timeSeriesConditions;
    }

    /**
     * <p>
     * An array of actions that define a time series and how it is transformed. These transformations create a new time
     * series that is used for the what-if analysis.
     * </p>
     * 
     * @return An array of actions that define a time series and how it is transformed. These transformations create a
     *         new time series that is used for the what-if analysis.
     */
    public final Action action() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the TimeSeriesConditions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTimeSeriesConditions() {
        return timeSeriesConditions != null && !(timeSeriesConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of conditions that define which members of the related time series are transformed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimeSeriesConditions} method.
     * </p>
     * 
     * @return An array of conditions that define which members of the related time series are transformed.
     */
    public final List<TimeSeriesCondition> timeSeriesConditions() {
        return timeSeriesConditions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(hasTimeSeriesConditions() ? timeSeriesConditions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesTransformation)) {
            return false;
        }
        TimeSeriesTransformation other = (TimeSeriesTransformation) obj;
        return Objects.equals(action(), other.action()) && hasTimeSeriesConditions() == other.hasTimeSeriesConditions()
                && Objects.equals(timeSeriesConditions(), other.timeSeriesConditions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSeriesTransformation").add("Action", action())
                .add("TimeSeriesConditions", hasTimeSeriesConditions() ? timeSeriesConditions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "TimeSeriesConditions":
            return Optional.ofNullable(clazz.cast(timeSeriesConditions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Action", ACTION_FIELD);
        map.put("TimeSeriesConditions", TIME_SERIES_CONDITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesTransformation, T> g) {
        return obj -> g.apply((TimeSeriesTransformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSeriesTransformation> {
        /**
         * <p>
         * An array of actions that define a time series and how it is transformed. These transformations create a new
         * time series that is used for the what-if analysis.
         * </p>
         * 
         * @param action
         *        An array of actions that define a time series and how it is transformed. These transformations create
         *        a new time series that is used for the what-if analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Action action);

        /**
         * <p>
         * An array of actions that define a time series and how it is transformed. These transformations create a new
         * time series that is used for the what-if analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link Action.Builder} avoiding the need to
         * create one manually via {@link Action#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Action.Builder#build()} is called immediately and its result is
         * passed to {@link #action(Action)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(Action)
         */
        default Builder action(Consumer<Action.Builder> action) {
            return action(Action.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * An array of conditions that define which members of the related time series are transformed.
         * </p>
         * 
         * @param timeSeriesConditions
         *        An array of conditions that define which members of the related time series are transformed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesConditions(Collection<TimeSeriesCondition> timeSeriesConditions);

        /**
         * <p>
         * An array of conditions that define which members of the related time series are transformed.
         * </p>
         * 
         * @param timeSeriesConditions
         *        An array of conditions that define which members of the related time series are transformed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesConditions(TimeSeriesCondition... timeSeriesConditions);

        /**
         * <p>
         * An array of conditions that define which members of the related time series are transformed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.TimeSeriesCondition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.forecast.model.TimeSeriesCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.TimeSeriesCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #timeSeriesConditions(List<TimeSeriesCondition>)}.
         * 
         * @param timeSeriesConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.TimeSeriesCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesConditions(java.util.Collection<TimeSeriesCondition>)
         */
        Builder timeSeriesConditions(Consumer<TimeSeriesCondition.Builder>... timeSeriesConditions);
    }

    static final class BuilderImpl implements Builder {
        private Action action;

        private List<TimeSeriesCondition> timeSeriesConditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesTransformation model) {
            action(model.action);
            timeSeriesConditions(model.timeSeriesConditions);
        }

        public final Action.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final List<TimeSeriesCondition.Builder> getTimeSeriesConditions() {
            List<TimeSeriesCondition.Builder> result = TimeSeriesConditionsCopier.copyToBuilder(this.timeSeriesConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeSeriesConditions(Collection<TimeSeriesCondition.BuilderImpl> timeSeriesConditions) {
            this.timeSeriesConditions = TimeSeriesConditionsCopier.copyFromBuilder(timeSeriesConditions);
        }

        @Override
        public final Builder timeSeriesConditions(Collection<TimeSeriesCondition> timeSeriesConditions) {
            this.timeSeriesConditions = TimeSeriesConditionsCopier.copy(timeSeriesConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesConditions(TimeSeriesCondition... timeSeriesConditions) {
            timeSeriesConditions(Arrays.asList(timeSeriesConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesConditions(Consumer<TimeSeriesCondition.Builder>... timeSeriesConditions) {
            timeSeriesConditions(Stream.of(timeSeriesConditions).map(c -> TimeSeriesCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TimeSeriesTransformation build() {
            return new TimeSeriesTransformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
