/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.forecast.model.TransformationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeConfig> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(AttributeConfig.getter(AttributeConfig::attributeName)).setter(AttributeConfig.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<Map<String, String>> TRANSFORMATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Transformations").getter(AttributeConfig.getter(AttributeConfig::transformations)).setter(AttributeConfig.setter(Builder::transformations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transformations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD, TRANSFORMATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttributeConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attributeName;
    private final Map<String, String> transformations;

    private AttributeConfig(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.transformations = builder.transformations;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final boolean hasTransformations() {
        return this.transformations != null && !(this.transformations instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> transformations() {
        return this.transformations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransformations() ? this.transformations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeConfig)) {
            return false;
        }
        AttributeConfig other = (AttributeConfig)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && this.hasTransformations() == other.hasTransformations() && Objects.equals(this.transformations(), other.transformations());
    }

    public final String toString() {
        return ToString.builder((String)"AttributeConfig").add("AttributeName", (Object)this.attributeName()).add("Transformations", this.hasTransformations() ? this.transformations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "Transformations": {
                return Optional.ofNullable(clazz.cast(this.transformations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("Transformations", TRANSFORMATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeConfig, T> g) {
        return obj -> g.apply((AttributeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private Map<String, String> transformations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeConfig model) {
            this.attributeName(model.attributeName);
            this.transformations(model.transformations);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final Map<String, String> getTransformations() {
            if (this.transformations instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.transformations;
        }

        public final void setTransformations(Map<String, String> transformations) {
            this.transformations = TransformationsCopier.copy(transformations);
        }

        @Override
        public final Builder transformations(Map<String, String> transformations) {
            this.transformations = TransformationsCopier.copy(transformations);
            return this;
        }

        public AttributeConfig build() {
            return new AttributeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeConfig> {
        public Builder attributeName(String var1);

        public Builder transformations(Map<String, String> var1);
    }
}

