/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the dataset group properties used in the <a>ListDatasetGroups</a> operation. To get the
 * complete set of properties, call the <a>DescribeDatasetGroup</a> operation, and provide the listed
 * <code>DatasetGroupArn</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetGroupSummary.Builder, DatasetGroupSummary> {
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatasetGroupSummary::datasetGroupArn)).setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupArn").build()).build();

    private static final SdkField<String> DATASET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DatasetGroupSummary::datasetGroupName)).setter(setter(Builder::datasetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DatasetGroupSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DatasetGroupSummary::lastModificationTime)).setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_GROUP_ARN_FIELD,
            DATASET_GROUP_NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datasetGroupArn;

    private final String datasetGroupName;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private DatasetGroupSummary(BuilderImpl builder) {
        this.datasetGroupArn = builder.datasetGroupArn;
        this.datasetGroupName = builder.datasetGroupName;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset group.
     */
    public String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * The name of the dataset group.
     * </p>
     * 
     * @return The name of the dataset group.
     */
    public String datasetGroupName() {
        return datasetGroupName;
    }

    /**
     * <p>
     * When the datase group was created.
     * </p>
     * 
     * @return When the datase group was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the dataset group was created or last updated from a call to the <a>UpdateDatasetGroup</a> operation. While
     * the dataset group is being updated, <code>LastModificationTime</code> is the current query time.
     * </p>
     * 
     * @return When the dataset group was created or last updated from a call to the <a>UpdateDatasetGroup</a>
     *         operation. While the dataset group is being updated, <code>LastModificationTime</code> is the current
     *         query time.
     */
    public Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetGroupSummary)) {
            return false;
        }
        DatasetGroupSummary other = (DatasetGroupSummary) obj;
        return Objects.equals(datasetGroupArn(), other.datasetGroupArn())
                && Objects.equals(datasetGroupName(), other.datasetGroupName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DatasetGroupSummary").add("DatasetGroupArn", datasetGroupArn())
                .add("DatasetGroupName", datasetGroupName()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "DatasetGroupName":
            return Optional.ofNullable(clazz.cast(datasetGroupName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetGroupSummary, T> g) {
        return obj -> g.apply((DatasetGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetGroupSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset group.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * The name of the dataset group.
         * </p>
         * 
         * @param datasetGroupName
         *        The name of the dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupName(String datasetGroupName);

        /**
         * <p>
         * When the datase group was created.
         * </p>
         * 
         * @param creationTime
         *        When the datase group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the dataset group was created or last updated from a call to the <a>UpdateDatasetGroup</a> operation.
         * While the dataset group is being updated, <code>LastModificationTime</code> is the current query time.
         * </p>
         * 
         * @param lastModificationTime
         *        When the dataset group was created or last updated from a call to the <a>UpdateDatasetGroup</a>
         *        operation. While the dataset group is being updated, <code>LastModificationTime</code> is the current
         *        query time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String datasetGroupArn;

        private String datasetGroupName;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetGroupSummary model) {
            datasetGroupArn(model.datasetGroupArn);
            datasetGroupName(model.datasetGroupName);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        public final String getDatasetGroupName() {
            return datasetGroupName;
        }

        @Override
        public final Builder datasetGroupName(String datasetGroupName) {
            this.datasetGroupName = datasetGroupName;
            return this;
        }

        public final void setDatasetGroupName(String datasetGroupName) {
            this.datasetGroupName = datasetGroupName;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public DatasetGroupSummary build() {
            return new DatasetGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
