/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.ForecastSummary;
import software.amazon.awssdk.services.forecast.model.ForecastsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListForecastsResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, ListForecastsResponse> {
    private static final SdkField<List<ForecastSummary>> FORECASTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListForecastsResponse.getter(ListForecastsResponse::forecasts)).setter(ListForecastsResponse.setter(Builder::forecasts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Forecasts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ForecastSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListForecastsResponse.getter(ListForecastsResponse::nextToken)).setter(ListForecastsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECASTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ForecastSummary> forecasts;
    private final String nextToken;

    private ListForecastsResponse(BuilderImpl builder) {
        super(builder);
        this.forecasts = builder.forecasts;
        this.nextToken = builder.nextToken;
    }

    public List<ForecastSummary> forecasts() {
        return this.forecasts;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.forecasts());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListForecastsResponse)) {
            return false;
        }
        ListForecastsResponse other = (ListForecastsResponse)((Object)obj);
        return Objects.equals(this.forecasts(), other.forecasts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListForecastsResponse").add("Forecasts", this.forecasts()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Forecasts": {
                return Optional.ofNullable(clazz.cast(this.forecasts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListForecastsResponse, T> g) {
        return obj -> g.apply((ListForecastsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private List<ForecastSummary> forecasts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListForecastsResponse model) {
            super(model);
            this.forecasts(model.forecasts);
            this.nextToken(model.nextToken);
        }

        public final Collection<ForecastSummary.Builder> getForecasts() {
            return this.forecasts != null ? (Collection)this.forecasts.stream().map(ForecastSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder forecasts(Collection<ForecastSummary> forecasts) {
            this.forecasts = ForecastsCopier.copy(forecasts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecasts(ForecastSummary ... forecasts) {
            this.forecasts(Arrays.asList(forecasts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecasts(Consumer<ForecastSummary.Builder> ... forecasts) {
            this.forecasts(Stream.of(forecasts).map(c -> (ForecastSummary)((ForecastSummary.Builder)ForecastSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setForecasts(Collection<ForecastSummary.BuilderImpl> forecasts) {
            this.forecasts = ForecastsCopier.copyFromBuilder(forecasts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListForecastsResponse build() {
            return new ListForecastsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListForecastsResponse> {
        public Builder forecasts(Collection<ForecastSummary> var1);

        public Builder forecasts(ForecastSummary ... var1);

        public Builder forecasts(Consumer<ForecastSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

