/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the forecast properties used in the <a>ListForecasts</a> operation. To get the complete set of
 * properties, call the <a>DescribeForecast</a> operation, and provide the listed <code>ForecastArn</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ForecastSummary implements SdkPojo, Serializable, ToCopyableBuilder<ForecastSummary.Builder, ForecastSummary> {
    private static final SdkField<String> FORECAST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ForecastSummary::forecastArn)).setter(setter(Builder::forecastArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastArn").build()).build();

    private static final SdkField<String> FORECAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ForecastSummary::forecastName)).setter(setter(Builder::forecastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastName").build()).build();

    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ForecastSummary::predictorArn)).setter(setter(Builder::predictorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()).build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ForecastSummary::datasetGroupArn)).setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ForecastSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ForecastSummary::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ForecastSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ForecastSummary::lastModificationTime)).setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_ARN_FIELD,
            FORECAST_NAME_FIELD, PREDICTOR_ARN_FIELD, DATASET_GROUP_ARN_FIELD, STATUS_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFICATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String forecastArn;

    private final String forecastName;

    private final String predictorArn;

    private final String datasetGroupArn;

    private final String status;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private ForecastSummary(BuilderImpl builder) {
        this.forecastArn = builder.forecastArn;
        this.forecastName = builder.forecastName;
        this.predictorArn = builder.predictorArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The ARN of the forecast.
     * </p>
     * 
     * @return The ARN of the forecast.
     */
    public String forecastArn() {
        return forecastArn;
    }

    /**
     * <p>
     * The name of the forecast.
     * </p>
     * 
     * @return The name of the forecast.
     */
    public String forecastName() {
        return forecastName;
    }

    /**
     * <p>
     * The ARN of the predictor used to generate the forecast.
     * </p>
     * 
     * @return The ARN of the predictor used to generate the forecast.
     */
    public String predictorArn() {
        return predictorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset group that provided the data used to train the predictor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset group that provided the data used to train the predictor.
     */
    public String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * The status of the forecast. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the forecast.
     * </p>
     * </note>
     * 
     * @return The status of the forecast. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the
     *         forecast.
     *         </p>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @return If an error occurred, an informational message about the error.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * When the forecast creation task was created.
     * </p>
     * 
     * @return When the forecast creation task was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Initially, the same as <code>CreationTime</code> (status is <code>CREATE_PENDING</code>). Updated when inference
     * (creating the forecast) starts (status changed to <code>CREATE_IN_PROGRESS</code>), and when inference is
     * complete (status changed to <code>ACTIVE</code>) or fails (status changed to <code>CREATE_FAILED</code>).
     * </p>
     * 
     * @return Initially, the same as <code>CreationTime</code> (status is <code>CREATE_PENDING</code>). Updated when
     *         inference (creating the forecast) starts (status changed to <code>CREATE_IN_PROGRESS</code>), and when
     *         inference is complete (status changed to <code>ACTIVE</code>) or fails (status changed to
     *         <code>CREATE_FAILED</code>).
     */
    public Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(forecastName());
        hashCode = 31 * hashCode + Objects.hashCode(predictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastSummary)) {
            return false;
        }
        ForecastSummary other = (ForecastSummary) obj;
        return Objects.equals(forecastArn(), other.forecastArn()) && Objects.equals(forecastName(), other.forecastName())
                && Objects.equals(predictorArn(), other.predictorArn())
                && Objects.equals(datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(status(), other.status())
                && Objects.equals(message(), other.message()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ForecastSummary").add("ForecastArn", forecastArn()).add("ForecastName", forecastName())
                .add("PredictorArn", predictorArn()).add("DatasetGroupArn", datasetGroupArn()).add("Status", status())
                .add("Message", message()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForecastArn":
            return Optional.ofNullable(clazz.cast(forecastArn()));
        case "ForecastName":
            return Optional.ofNullable(clazz.cast(forecastName()));
        case "PredictorArn":
            return Optional.ofNullable(clazz.cast(predictorArn()));
        case "DatasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForecastSummary, T> g) {
        return obj -> g.apply((ForecastSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ForecastSummary> {
        /**
         * <p>
         * The ARN of the forecast.
         * </p>
         * 
         * @param forecastArn
         *        The ARN of the forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastArn(String forecastArn);

        /**
         * <p>
         * The name of the forecast.
         * </p>
         * 
         * @param forecastName
         *        The name of the forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastName(String forecastName);

        /**
         * <p>
         * The ARN of the predictor used to generate the forecast.
         * </p>
         * 
         * @param predictorArn
         *        The ARN of the predictor used to generate the forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorArn(String predictorArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset group that provided the data used to train the predictor.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the dataset group that provided the data used to train the
         *        predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * The status of the forecast. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the
         * forecast.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the forecast. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the
         *        forecast.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If an error occurred, an informational message about the error.
         * </p>
         * 
         * @param message
         *        If an error occurred, an informational message about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * When the forecast creation task was created.
         * </p>
         * 
         * @param creationTime
         *        When the forecast creation task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Initially, the same as <code>CreationTime</code> (status is <code>CREATE_PENDING</code>). Updated when
         * inference (creating the forecast) starts (status changed to <code>CREATE_IN_PROGRESS</code>), and when
         * inference is complete (status changed to <code>ACTIVE</code>) or fails (status changed to
         * <code>CREATE_FAILED</code>).
         * </p>
         * 
         * @param lastModificationTime
         *        Initially, the same as <code>CreationTime</code> (status is <code>CREATE_PENDING</code>). Updated when
         *        inference (creating the forecast) starts (status changed to <code>CREATE_IN_PROGRESS</code>), and when
         *        inference is complete (status changed to <code>ACTIVE</code>) or fails (status changed to
         *        <code>CREATE_FAILED</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String forecastArn;

        private String forecastName;

        private String predictorArn;

        private String datasetGroupArn;

        private String status;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastSummary model) {
            forecastArn(model.forecastArn);
            forecastName(model.forecastName);
            predictorArn(model.predictorArn);
            datasetGroupArn(model.datasetGroupArn);
            status(model.status);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getForecastArn() {
            return forecastArn;
        }

        @Override
        public final Builder forecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
            return this;
        }

        public final void setForecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
        }

        public final String getForecastName() {
            return forecastName;
        }

        @Override
        public final Builder forecastName(String forecastName) {
            this.forecastName = forecastName;
            return this;
        }

        public final void setForecastName(String forecastName) {
            this.forecastName = forecastName;
        }

        public final String getPredictorArn() {
            return predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public ForecastSummary build() {
            return new ForecastSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
