/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecastquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.forecastquery.model.DataPoint;
import software.amazon.awssdk.services.forecastquery.model.PredictionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Forecast
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Forecast> {
    private static final SdkField<Map<String, List<DataPoint>>> PREDICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Forecast.getter(Forecast::predictions)).setter(Forecast.setter(Builder::predictions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predictions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, List<DataPoint>> predictions;

    private Forecast(BuilderImpl builder) {
        this.predictions = builder.predictions;
    }

    public boolean hasPredictions() {
        return this.predictions != null && !(this.predictions instanceof SdkAutoConstructMap);
    }

    public Map<String, List<DataPoint>> predictions() {
        return this.predictions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.predictions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Forecast)) {
            return false;
        }
        Forecast other = (Forecast)obj;
        return Objects.equals(this.predictions(), other.predictions());
    }

    public String toString() {
        return ToString.builder((String)"Forecast").add("Predictions", this.predictions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Predictions": {
                return Optional.ofNullable(clazz.cast(this.predictions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Forecast, T> g) {
        return obj -> g.apply((Forecast)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, List<DataPoint>> predictions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Forecast model) {
            this.predictions(model.predictions);
        }

        public final Map<String, ? extends Collection<DataPoint>> getPredictions() {
            return this.predictions;
        }

        @Override
        public final Builder predictions(Map<String, ? extends Collection<DataPoint>> predictions) {
            this.predictions = PredictionsCopier.copy(predictions);
            return this;
        }

        public final void setPredictions(Map<String, ? extends Collection<DataPoint>> predictions) {
            this.predictions = PredictionsCopier.copy(predictions);
        }

        public Forecast build() {
            return new Forecast(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Forecast> {
        public Builder predictions(Map<String, ? extends Collection<DataPoint>> var1);
    }
}

