/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateVariableResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<BatchCreateVariableResponse.Builder, BatchCreateVariableResponse> {
    private static final SdkField<List<BatchCreateVariableError>> ERRORS_FIELD = SdkField
            .<List<BatchCreateVariableError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchCreateVariableResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchCreateVariableError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchCreateVariableError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD));

    private final List<BatchCreateVariableError> errors;

    private BatchCreateVariableResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the errors for the <code>BatchCreateVariable</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides the errors for the <code>BatchCreateVariable</code> request.
     */
    public final List<BatchCreateVariableError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateVariableResponse)) {
            return false;
        }
        BatchCreateVariableResponse other = (BatchCreateVariableResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateVariableResponse").add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateVariableResponse, T> g) {
        return obj -> g.apply((BatchCreateVariableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchCreateVariableResponse> {
        /**
         * <p>
         * Provides the errors for the <code>BatchCreateVariable</code> request.
         * </p>
         * 
         * @param errors
         *        Provides the errors for the <code>BatchCreateVariable</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchCreateVariableError> errors);

        /**
         * <p>
         * Provides the errors for the <code>BatchCreateVariable</code> request.
         * </p>
         * 
         * @param errors
         *        Provides the errors for the <code>BatchCreateVariable</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchCreateVariableError... errors);

        /**
         * <p>
         * Provides the errors for the <code>BatchCreateVariable</code> request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchCreateVariableError>.Builder} avoiding
         * the need to create one manually via {@link List<BatchCreateVariableError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchCreateVariableError>.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<BatchCreateVariableError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<BatchCreateVariableError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<BatchCreateVariableError>)
         */
        Builder errors(Consumer<BatchCreateVariableError.Builder>... errors);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<BatchCreateVariableError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateVariableResponse model) {
            super(model);
            errors(model.errors);
        }

        public final List<BatchCreateVariableError.Builder> getErrors() {
            List<BatchCreateVariableError.Builder> result = BatchCreateVariableErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder errors(Collection<BatchCreateVariableError> errors) {
            this.errors = BatchCreateVariableErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchCreateVariableError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchCreateVariableError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchCreateVariableError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchCreateVariableError.BuilderImpl> errors) {
            this.errors = BatchCreateVariableErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchCreateVariableResponse build() {
            return new BatchCreateVariableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
