/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The batch prediction details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPrediction implements SdkPojo, Serializable, ToCopyableBuilder<BatchPrediction.Builder, BatchPrediction> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(BatchPrediction::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BatchPrediction::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(BatchPrediction::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startTime").getter(getter(BatchPrediction::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> COMPLETION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("completionTime").getter(getter(BatchPrediction::completionTime)).setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build()).build();

    private static final SdkField<String> LAST_HEARTBEAT_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastHeartbeatTime").getter(getter(BatchPrediction::lastHeartbeatTime))
            .setter(setter(Builder::lastHeartbeatTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastHeartbeatTime").build()).build();

    private static final SdkField<String> INPUT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputPath").getter(getter(BatchPrediction::inputPath)).setter(setter(Builder::inputPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPath").build()).build();

    private static final SdkField<String> OUTPUT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputPath").getter(getter(BatchPrediction::outputPath)).setter(setter(Builder::outputPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputPath").build()).build();

    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTypeName").getter(getter(BatchPrediction::eventTypeName)).setter(setter(Builder::eventTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()).build();

    private static final SdkField<String> DETECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorName").getter(getter(BatchPrediction::detectorName)).setter(setter(Builder::detectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorName").build()).build();

    private static final SdkField<String> DETECTOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorVersion").getter(getter(BatchPrediction::detectorVersion))
            .setter(setter(Builder::detectorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersion").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamRoleArn").getter(getter(BatchPrediction::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(BatchPrediction::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Integer> PROCESSED_RECORDS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("processedRecordsCount").getter(getter(BatchPrediction::processedRecordsCount))
            .setter(setter(Builder::processedRecordsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processedRecordsCount").build())
            .build();

    private static final SdkField<Integer> TOTAL_RECORDS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalRecordsCount").getter(getter(BatchPrediction::totalRecordsCount))
            .setter(setter(Builder::totalRecordsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalRecordsCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, STATUS_FIELD,
            FAILURE_REASON_FIELD, START_TIME_FIELD, COMPLETION_TIME_FIELD, LAST_HEARTBEAT_TIME_FIELD, INPUT_PATH_FIELD,
            OUTPUT_PATH_FIELD, EVENT_TYPE_NAME_FIELD, DETECTOR_NAME_FIELD, DETECTOR_VERSION_FIELD, IAM_ROLE_ARN_FIELD, ARN_FIELD,
            PROCESSED_RECORDS_COUNT_FIELD, TOTAL_RECORDS_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String status;

    private final String failureReason;

    private final String startTime;

    private final String completionTime;

    private final String lastHeartbeatTime;

    private final String inputPath;

    private final String outputPath;

    private final String eventTypeName;

    private final String detectorName;

    private final String detectorVersion;

    private final String iamRoleArn;

    private final String arn;

    private final Integer processedRecordsCount;

    private final Integer totalRecordsCount;

    private BatchPrediction(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.startTime = builder.startTime;
        this.completionTime = builder.completionTime;
        this.lastHeartbeatTime = builder.lastHeartbeatTime;
        this.inputPath = builder.inputPath;
        this.outputPath = builder.outputPath;
        this.eventTypeName = builder.eventTypeName;
        this.detectorName = builder.detectorName;
        this.detectorVersion = builder.detectorVersion;
        this.iamRoleArn = builder.iamRoleArn;
        this.arn = builder.arn;
        this.processedRecordsCount = builder.processedRecordsCount;
        this.totalRecordsCount = builder.totalRecordsCount;
    }

    /**
     * <p>
     * The job ID for the batch prediction.
     * </p>
     * 
     * @return The job ID for the batch prediction.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The batch prediction status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AsyncJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The batch prediction status.
     * @see AsyncJobStatus
     */
    public final AsyncJobStatus status() {
        return AsyncJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The batch prediction status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AsyncJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The batch prediction status.
     * @see AsyncJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason a batch prediction job failed.
     * </p>
     * 
     * @return The reason a batch prediction job failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Timestamp of when the batch prediction job started.
     * </p>
     * 
     * @return Timestamp of when the batch prediction job started.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * Timestamp of when the batch prediction job comleted.
     * </p>
     * 
     * @return Timestamp of when the batch prediction job comleted.
     */
    public final String completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * Timestamp of most recent heartbeat indicating the batch prediction job was making progress.
     * </p>
     * 
     * @return Timestamp of most recent heartbeat indicating the batch prediction job was making progress.
     */
    public final String lastHeartbeatTime() {
        return lastHeartbeatTime;
    }

    /**
     * <p>
     * The Amazon S3 location of your training file.
     * </p>
     * 
     * @return The Amazon S3 location of your training file.
     */
    public final String inputPath() {
        return inputPath;
    }

    /**
     * <p>
     * The Amazon S3 location of your output file.
     * </p>
     * 
     * @return The Amazon S3 location of your output file.
     */
    public final String outputPath() {
        return outputPath;
    }

    /**
     * <p>
     * The name of the event type.
     * </p>
     * 
     * @return The name of the event type.
     */
    public final String eventTypeName() {
        return eventTypeName;
    }

    /**
     * <p>
     * The name of the detector.
     * </p>
     * 
     * @return The name of the detector.
     */
    public final String detectorName() {
        return detectorName;
    }

    /**
     * <p>
     * The detector version.
     * </p>
     * 
     * @return The detector version.
     */
    public final String detectorVersion() {
        return detectorVersion;
    }

    /**
     * <p>
     * The ARN of the IAM role to use for this job request.
     * </p>
     * 
     * @return The ARN of the IAM role to use for this job request.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The ARN of batch prediction job.
     * </p>
     * 
     * @return The ARN of batch prediction job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The number of records processed by the batch prediction job.
     * </p>
     * 
     * @return The number of records processed by the batch prediction job.
     */
    public final Integer processedRecordsCount() {
        return processedRecordsCount;
    }

    /**
     * <p>
     * The total number of records in the batch prediction job.
     * </p>
     * 
     * @return The total number of records in the batch prediction job.
     */
    public final Integer totalRecordsCount() {
        return totalRecordsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastHeartbeatTime());
        hashCode = 31 * hashCode + Objects.hashCode(inputPath());
        hashCode = 31 * hashCode + Objects.hashCode(outputPath());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(detectorName());
        hashCode = 31 * hashCode + Objects.hashCode(detectorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(processedRecordsCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalRecordsCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPrediction)) {
            return false;
        }
        BatchPrediction other = (BatchPrediction) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(lastHeartbeatTime(), other.lastHeartbeatTime())
                && Objects.equals(inputPath(), other.inputPath()) && Objects.equals(outputPath(), other.outputPath())
                && Objects.equals(eventTypeName(), other.eventTypeName()) && Objects.equals(detectorName(), other.detectorName())
                && Objects.equals(detectorVersion(), other.detectorVersion()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(arn(), other.arn()) && Objects.equals(processedRecordsCount(), other.processedRecordsCount())
                && Objects.equals(totalRecordsCount(), other.totalRecordsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPrediction").add("JobId", jobId()).add("Status", statusAsString())
                .add("FailureReason", failureReason()).add("StartTime", startTime()).add("CompletionTime", completionTime())
                .add("LastHeartbeatTime", lastHeartbeatTime()).add("InputPath", inputPath()).add("OutputPath", outputPath())
                .add("EventTypeName", eventTypeName()).add("DetectorName", detectorName())
                .add("DetectorVersion", detectorVersion()).add("IamRoleArn", iamRoleArn()).add("Arn", arn())
                .add("ProcessedRecordsCount", processedRecordsCount()).add("TotalRecordsCount", totalRecordsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "completionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "lastHeartbeatTime":
            return Optional.ofNullable(clazz.cast(lastHeartbeatTime()));
        case "inputPath":
            return Optional.ofNullable(clazz.cast(inputPath()));
        case "outputPath":
            return Optional.ofNullable(clazz.cast(outputPath()));
        case "eventTypeName":
            return Optional.ofNullable(clazz.cast(eventTypeName()));
        case "detectorName":
            return Optional.ofNullable(clazz.cast(detectorName()));
        case "detectorVersion":
            return Optional.ofNullable(clazz.cast(detectorVersion()));
        case "iamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "processedRecordsCount":
            return Optional.ofNullable(clazz.cast(processedRecordsCount()));
        case "totalRecordsCount":
            return Optional.ofNullable(clazz.cast(totalRecordsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPrediction, T> g) {
        return obj -> g.apply((BatchPrediction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchPrediction> {
        /**
         * <p>
         * The job ID for the batch prediction.
         * </p>
         * 
         * @param jobId
         *        The job ID for the batch prediction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The batch prediction status.
         * </p>
         * 
         * @param status
         *        The batch prediction status.
         * @see AsyncJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsyncJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The batch prediction status.
         * </p>
         * 
         * @param status
         *        The batch prediction status.
         * @see AsyncJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsyncJobStatus
         */
        Builder status(AsyncJobStatus status);

        /**
         * <p>
         * The reason a batch prediction job failed.
         * </p>
         * 
         * @param failureReason
         *        The reason a batch prediction job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Timestamp of when the batch prediction job started.
         * </p>
         * 
         * @param startTime
         *        Timestamp of when the batch prediction job started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * Timestamp of when the batch prediction job comleted.
         * </p>
         * 
         * @param completionTime
         *        Timestamp of when the batch prediction job comleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(String completionTime);

        /**
         * <p>
         * Timestamp of most recent heartbeat indicating the batch prediction job was making progress.
         * </p>
         * 
         * @param lastHeartbeatTime
         *        Timestamp of most recent heartbeat indicating the batch prediction job was making progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastHeartbeatTime(String lastHeartbeatTime);

        /**
         * <p>
         * The Amazon S3 location of your training file.
         * </p>
         * 
         * @param inputPath
         *        The Amazon S3 location of your training file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputPath(String inputPath);

        /**
         * <p>
         * The Amazon S3 location of your output file.
         * </p>
         * 
         * @param outputPath
         *        The Amazon S3 location of your output file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputPath(String outputPath);

        /**
         * <p>
         * The name of the event type.
         * </p>
         * 
         * @param eventTypeName
         *        The name of the event type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeName(String eventTypeName);

        /**
         * <p>
         * The name of the detector.
         * </p>
         * 
         * @param detectorName
         *        The name of the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorName(String detectorName);

        /**
         * <p>
         * The detector version.
         * </p>
         * 
         * @param detectorVersion
         *        The detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorVersion(String detectorVersion);

        /**
         * <p>
         * The ARN of the IAM role to use for this job request.
         * </p>
         * 
         * @param iamRoleArn
         *        The ARN of the IAM role to use for this job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The ARN of batch prediction job.
         * </p>
         * 
         * @param arn
         *        The ARN of batch prediction job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The number of records processed by the batch prediction job.
         * </p>
         * 
         * @param processedRecordsCount
         *        The number of records processed by the batch prediction job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedRecordsCount(Integer processedRecordsCount);

        /**
         * <p>
         * The total number of records in the batch prediction job.
         * </p>
         * 
         * @param totalRecordsCount
         *        The total number of records in the batch prediction job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRecordsCount(Integer totalRecordsCount);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String status;

        private String failureReason;

        private String startTime;

        private String completionTime;

        private String lastHeartbeatTime;

        private String inputPath;

        private String outputPath;

        private String eventTypeName;

        private String detectorName;

        private String detectorVersion;

        private String iamRoleArn;

        private String arn;

        private Integer processedRecordsCount;

        private Integer totalRecordsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPrediction model) {
            jobId(model.jobId);
            status(model.status);
            failureReason(model.failureReason);
            startTime(model.startTime);
            completionTime(model.completionTime);
            lastHeartbeatTime(model.lastHeartbeatTime);
            inputPath(model.inputPath);
            outputPath(model.outputPath);
            eventTypeName(model.eventTypeName);
            detectorName(model.detectorName);
            detectorVersion(model.detectorVersion);
            iamRoleArn(model.iamRoleArn);
            arn(model.arn);
            processedRecordsCount(model.processedRecordsCount);
            totalRecordsCount(model.totalRecordsCount);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AsyncJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public final String getCompletionTime() {
            return completionTime;
        }

        @Override
        public final Builder completionTime(String completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final void setCompletionTime(String completionTime) {
            this.completionTime = completionTime;
        }

        public final String getLastHeartbeatTime() {
            return lastHeartbeatTime;
        }

        @Override
        public final Builder lastHeartbeatTime(String lastHeartbeatTime) {
            this.lastHeartbeatTime = lastHeartbeatTime;
            return this;
        }

        public final void setLastHeartbeatTime(String lastHeartbeatTime) {
            this.lastHeartbeatTime = lastHeartbeatTime;
        }

        public final String getInputPath() {
            return inputPath;
        }

        @Override
        public final Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public final void setInputPath(String inputPath) {
            this.inputPath = inputPath;
        }

        public final String getOutputPath() {
            return outputPath;
        }

        @Override
        public final Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public final void setOutputPath(String outputPath) {
            this.outputPath = outputPath;
        }

        public final String getEventTypeName() {
            return eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        public final String getDetectorName() {
            return detectorName;
        }

        @Override
        public final Builder detectorName(String detectorName) {
            this.detectorName = detectorName;
            return this;
        }

        public final void setDetectorName(String detectorName) {
            this.detectorName = detectorName;
        }

        public final String getDetectorVersion() {
            return detectorVersion;
        }

        @Override
        public final Builder detectorVersion(String detectorVersion) {
            this.detectorVersion = detectorVersion;
            return this;
        }

        public final void setDetectorVersion(String detectorVersion) {
            this.detectorVersion = detectorVersion;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Integer getProcessedRecordsCount() {
            return processedRecordsCount;
        }

        @Override
        public final Builder processedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
            return this;
        }

        public final void setProcessedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
        }

        public final Integer getTotalRecordsCount() {
            return totalRecordsCount;
        }

        @Override
        public final Builder totalRecordsCount(Integer totalRecordsCount) {
            this.totalRecordsCount = totalRecordsCount;
            return this;
        }

        public final void setTotalRecordsCount(Integer totalRecordsCount) {
            this.totalRecordsCount = totalRecordsCount;
        }

        @Override
        public BatchPrediction build() {
            return new BatchPrediction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
