/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEntityTypesResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetEntityTypesResponse.Builder, GetEntityTypesResponse> {
    private static final SdkField<List<EntityType>> ENTITY_TYPES_FIELD = SdkField
            .<List<EntityType>> builder(MarshallingType.LIST)
            .memberName("entityTypes")
            .getter(getter(GetEntityTypesResponse::entityTypes))
            .setter(setter(Builder::entityTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityType> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetEntityTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_TYPES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EntityType> entityTypes;

    private final String nextToken;

    private GetEntityTypesResponse(BuilderImpl builder) {
        super(builder);
        this.entityTypes = builder.entityTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the EntityTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEntityTypes() {
        return entityTypes != null && !(entityTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of entity types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntityTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of entity types.
     */
    public final List<EntityType> entityTypes() {
        return entityTypes;
    }

    /**
     * <p>
     * The next page token.
     * </p>
     * 
     * @return The next page token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityTypes() ? entityTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEntityTypesResponse)) {
            return false;
        }
        GetEntityTypesResponse other = (GetEntityTypesResponse) obj;
        return hasEntityTypes() == other.hasEntityTypes() && Objects.equals(entityTypes(), other.entityTypes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEntityTypesResponse").add("EntityTypes", hasEntityTypes() ? entityTypes() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityTypes":
            return Optional.ofNullable(clazz.cast(entityTypes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEntityTypesResponse, T> g) {
        return obj -> g.apply((GetEntityTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEntityTypesResponse> {
        /**
         * <p>
         * An array of entity types.
         * </p>
         * 
         * @param entityTypes
         *        An array of entity types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypes(Collection<EntityType> entityTypes);

        /**
         * <p>
         * An array of entity types.
         * </p>
         * 
         * @param entityTypes
         *        An array of entity types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypes(EntityType... entityTypes);

        /**
         * <p>
         * An array of entity types.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EntityType>.Builder} avoiding the need to
         * create one manually via {@link List<EntityType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EntityType>.Builder#build()} is called immediately and its
         * result is passed to {@link #entityTypes(List<EntityType>)}.
         * 
         * @param entityTypes
         *        a consumer that will call methods on {@link List<EntityType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityTypes(List<EntityType>)
         */
        Builder entityTypes(Consumer<EntityType.Builder>... entityTypes);

        /**
         * <p>
         * The next page token.
         * </p>
         * 
         * @param nextToken
         *        The next page token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<EntityType> entityTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEntityTypesResponse model) {
            super(model);
            entityTypes(model.entityTypes);
            nextToken(model.nextToken);
        }

        public final List<EntityType.Builder> getEntityTypes() {
            List<EntityType.Builder> result = _entityTypeListCopier.copyToBuilder(this.entityTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder entityTypes(Collection<EntityType> entityTypes) {
            this.entityTypes = _entityTypeListCopier.copy(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(EntityType... entityTypes) {
            entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(Consumer<EntityType.Builder>... entityTypes) {
            entityTypes(Stream.of(entityTypes).map(c -> EntityType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntityTypes(Collection<EntityType.BuilderImpl> entityTypes) {
            this.entityTypes = _entityTypeListCopier.copyFromBuilder(entityTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetEntityTypesResponse build() {
            return new GetEntityTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
