/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEventPredictionResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetEventPredictionResponse.Builder, GetEventPredictionResponse> {
    private static final SdkField<List<ModelScores>> MODEL_SCORES_FIELD = SdkField
            .<List<ModelScores>> builder(MarshallingType.LIST)
            .memberName("modelScores")
            .getter(getter(GetEventPredictionResponse::modelScores))
            .setter(setter(Builder::modelScores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelScores").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelScores> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelScores::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RuleResult>> RULE_RESULTS_FIELD = SdkField
            .<List<RuleResult>> builder(MarshallingType.LIST)
            .memberName("ruleResults")
            .getter(getter(GetEventPredictionResponse::ruleResults))
            .setter(setter(Builder::ruleResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_SCORES_FIELD,
            RULE_RESULTS_FIELD));

    private final List<ModelScores> modelScores;

    private final List<RuleResult> ruleResults;

    private GetEventPredictionResponse(BuilderImpl builder) {
        super(builder);
        this.modelScores = builder.modelScores;
        this.ruleResults = builder.ruleResults;
    }

    /**
     * Returns true if the ModelScores property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasModelScores() {
        return modelScores != null && !(modelScores instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The model scores. Amazon Fraud Detector generates model scores between 0 and 1000, where 0 is low fraud risk and
     * 1000 is high fraud risk. Model scores are directly related to the false positive rate (FPR). For example, a score
     * of 600 corresponds to an estimated 10% false positive rate whereas a score of 900 corresponds to an estimated 2%
     * false positive rate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasModelScores()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The model scores. Amazon Fraud Detector generates model scores between 0 and 1000, where 0 is low fraud
     *         risk and 1000 is high fraud risk. Model scores are directly related to the false positive rate (FPR). For
     *         example, a score of 600 corresponds to an estimated 10% false positive rate whereas a score of 900
     *         corresponds to an estimated 2% false positive rate.
     */
    public final List<ModelScores> modelScores() {
        return modelScores;
    }

    /**
     * Returns true if the RuleResults property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRuleResults() {
        return ruleResults != null && !(ruleResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRuleResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The results.
     */
    public final List<RuleResult> ruleResults() {
        return ruleResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasModelScores() ? modelScores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleResults() ? ruleResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventPredictionResponse)) {
            return false;
        }
        GetEventPredictionResponse other = (GetEventPredictionResponse) obj;
        return hasModelScores() == other.hasModelScores() && Objects.equals(modelScores(), other.modelScores())
                && hasRuleResults() == other.hasRuleResults() && Objects.equals(ruleResults(), other.ruleResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEventPredictionResponse").add("ModelScores", hasModelScores() ? modelScores() : null)
                .add("RuleResults", hasRuleResults() ? ruleResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelScores":
            return Optional.ofNullable(clazz.cast(modelScores()));
        case "ruleResults":
            return Optional.ofNullable(clazz.cast(ruleResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEventPredictionResponse, T> g) {
        return obj -> g.apply((GetEventPredictionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEventPredictionResponse> {
        /**
         * <p>
         * The model scores. Amazon Fraud Detector generates model scores between 0 and 1000, where 0 is low fraud risk
         * and 1000 is high fraud risk. Model scores are directly related to the false positive rate (FPR). For example,
         * a score of 600 corresponds to an estimated 10% false positive rate whereas a score of 900 corresponds to an
         * estimated 2% false positive rate.
         * </p>
         * 
         * @param modelScores
         *        The model scores. Amazon Fraud Detector generates model scores between 0 and 1000, where 0 is low
         *        fraud risk and 1000 is high fraud risk. Model scores are directly related to the false positive rate
         *        (FPR). For example, a score of 600 corresponds to an estimated 10% false positive rate whereas a score
         *        of 900 corresponds to an estimated 2% false positive rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelScores(Collection<ModelScores> modelScores);

        /**
         * <p>
         * The model scores. Amazon Fraud Detector generates model scores between 0 and 1000, where 0 is low fraud risk
         * and 1000 is high fraud risk. Model scores are directly related to the false positive rate (FPR). For example,
         * a score of 600 corresponds to an estimated 10% false positive rate whereas a score of 900 corresponds to an
         * estimated 2% false positive rate.
         * </p>
         * 
         * @param modelScores
         *        The model scores. Amazon Fraud Detector generates model scores between 0 and 1000, where 0 is low
         *        fraud risk and 1000 is high fraud risk. Model scores are directly related to the false positive rate
         *        (FPR). For example, a score of 600 corresponds to an estimated 10% false positive rate whereas a score
         *        of 900 corresponds to an estimated 2% false positive rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelScores(ModelScores... modelScores);

        /**
         * <p>
         * The model scores. Amazon Fraud Detector generates model scores between 0 and 1000, where 0 is low fraud risk
         * and 1000 is high fraud risk. Model scores are directly related to the false positive rate (FPR). For example,
         * a score of 600 corresponds to an estimated 10% false positive rate whereas a score of 900 corresponds to an
         * estimated 2% false positive rate.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModelScores>.Builder} avoiding the need to
         * create one manually via {@link List<ModelScores>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModelScores>.Builder#build()} is called immediately and its
         * result is passed to {@link #modelScores(List<ModelScores>)}.
         * 
         * @param modelScores
         *        a consumer that will call methods on {@link List<ModelScores>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelScores(List<ModelScores>)
         */
        Builder modelScores(Consumer<ModelScores.Builder>... modelScores);

        /**
         * <p>
         * The results.
         * </p>
         * 
         * @param ruleResults
         *        The results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleResults(Collection<RuleResult> ruleResults);

        /**
         * <p>
         * The results.
         * </p>
         * 
         * @param ruleResults
         *        The results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleResults(RuleResult... ruleResults);

        /**
         * <p>
         * The results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RuleResult>.Builder} avoiding the need to
         * create one manually via {@link List<RuleResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RuleResult>.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleResults(List<RuleResult>)}.
         * 
         * @param ruleResults
         *        a consumer that will call methods on {@link List<RuleResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleResults(List<RuleResult>)
         */
        Builder ruleResults(Consumer<RuleResult.Builder>... ruleResults);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<ModelScores> modelScores = DefaultSdkAutoConstructList.getInstance();

        private List<RuleResult> ruleResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventPredictionResponse model) {
            super(model);
            modelScores(model.modelScores);
            ruleResults(model.ruleResults);
        }

        public final List<ModelScores.Builder> getModelScores() {
            List<ModelScores.Builder> result = ListOfModelScoresCopier.copyToBuilder(this.modelScores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder modelScores(Collection<ModelScores> modelScores) {
            this.modelScores = ListOfModelScoresCopier.copy(modelScores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelScores(ModelScores... modelScores) {
            modelScores(Arrays.asList(modelScores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelScores(Consumer<ModelScores.Builder>... modelScores) {
            modelScores(Stream.of(modelScores).map(c -> ModelScores.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setModelScores(Collection<ModelScores.BuilderImpl> modelScores) {
            this.modelScores = ListOfModelScoresCopier.copyFromBuilder(modelScores);
        }

        public final List<RuleResult.Builder> getRuleResults() {
            List<RuleResult.Builder> result = ListOfRuleResultsCopier.copyToBuilder(this.ruleResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ruleResults(Collection<RuleResult> ruleResults) {
            this.ruleResults = ListOfRuleResultsCopier.copy(ruleResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleResults(RuleResult... ruleResults) {
            ruleResults(Arrays.asList(ruleResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleResults(Consumer<RuleResult.Builder>... ruleResults) {
            ruleResults(Stream.of(ruleResults).map(c -> RuleResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRuleResults(Collection<RuleResult.BuilderImpl> ruleResults) {
            this.ruleResults = ListOfRuleResultsCopier.copyFromBuilder(ruleResults);
        }

        @Override
        public GetEventPredictionResponse build() {
            return new GetEventPredictionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
