/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The training result details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingResult implements SdkPojo, Serializable, ToCopyableBuilder<TrainingResult.Builder, TrainingResult> {
    private static final SdkField<DataValidationMetrics> DATA_VALIDATION_METRICS_FIELD = SdkField
            .<DataValidationMetrics> builder(MarshallingType.SDK_POJO).memberName("dataValidationMetrics")
            .getter(getter(TrainingResult::dataValidationMetrics)).setter(setter(Builder::dataValidationMetrics))
            .constructor(DataValidationMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataValidationMetrics").build())
            .build();

    private static final SdkField<TrainingMetrics> TRAINING_METRICS_FIELD = SdkField
            .<TrainingMetrics> builder(MarshallingType.SDK_POJO).memberName("trainingMetrics")
            .getter(getter(TrainingResult::trainingMetrics)).setter(setter(Builder::trainingMetrics))
            .constructor(TrainingMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMetrics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_VALIDATION_METRICS_FIELD,
            TRAINING_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataValidationMetrics dataValidationMetrics;

    private final TrainingMetrics trainingMetrics;

    private TrainingResult(BuilderImpl builder) {
        this.dataValidationMetrics = builder.dataValidationMetrics;
        this.trainingMetrics = builder.trainingMetrics;
    }

    /**
     * <p>
     * The validation metrics.
     * </p>
     * 
     * @return The validation metrics.
     */
    public final DataValidationMetrics dataValidationMetrics() {
        return dataValidationMetrics;
    }

    /**
     * <p>
     * The training metric details.
     * </p>
     * 
     * @return The training metric details.
     */
    public final TrainingMetrics trainingMetrics() {
        return trainingMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataValidationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(trainingMetrics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingResult)) {
            return false;
        }
        TrainingResult other = (TrainingResult) obj;
        return Objects.equals(dataValidationMetrics(), other.dataValidationMetrics())
                && Objects.equals(trainingMetrics(), other.trainingMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainingResult").add("DataValidationMetrics", dataValidationMetrics())
                .add("TrainingMetrics", trainingMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataValidationMetrics":
            return Optional.ofNullable(clazz.cast(dataValidationMetrics()));
        case "trainingMetrics":
            return Optional.ofNullable(clazz.cast(trainingMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingResult, T> g) {
        return obj -> g.apply((TrainingResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingResult> {
        /**
         * <p>
         * The validation metrics.
         * </p>
         * 
         * @param dataValidationMetrics
         *        The validation metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataValidationMetrics(DataValidationMetrics dataValidationMetrics);

        /**
         * <p>
         * The validation metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link DataValidationMetrics.Builder} avoiding the need
         * to create one manually via {@link DataValidationMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataValidationMetrics.Builder#build()} is called immediately and
         * its result is passed to {@link #dataValidationMetrics(DataValidationMetrics)}.
         * 
         * @param dataValidationMetrics
         *        a consumer that will call methods on {@link DataValidationMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataValidationMetrics(DataValidationMetrics)
         */
        default Builder dataValidationMetrics(Consumer<DataValidationMetrics.Builder> dataValidationMetrics) {
            return dataValidationMetrics(DataValidationMetrics.builder().applyMutation(dataValidationMetrics).build());
        }

        /**
         * <p>
         * The training metric details.
         * </p>
         * 
         * @param trainingMetrics
         *        The training metric details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingMetrics(TrainingMetrics trainingMetrics);

        /**
         * <p>
         * The training metric details.
         * </p>
         * This is a convenience that creates an instance of the {@link TrainingMetrics.Builder} avoiding the need to
         * create one manually via {@link TrainingMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingMetrics(TrainingMetrics)}.
         * 
         * @param trainingMetrics
         *        a consumer that will call methods on {@link TrainingMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingMetrics(TrainingMetrics)
         */
        default Builder trainingMetrics(Consumer<TrainingMetrics.Builder> trainingMetrics) {
            return trainingMetrics(TrainingMetrics.builder().applyMutation(trainingMetrics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataValidationMetrics dataValidationMetrics;

        private TrainingMetrics trainingMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingResult model) {
            dataValidationMetrics(model.dataValidationMetrics);
            trainingMetrics(model.trainingMetrics);
        }

        public final DataValidationMetrics.Builder getDataValidationMetrics() {
            return dataValidationMetrics != null ? dataValidationMetrics.toBuilder() : null;
        }

        @Override
        public final Builder dataValidationMetrics(DataValidationMetrics dataValidationMetrics) {
            this.dataValidationMetrics = dataValidationMetrics;
            return this;
        }

        public final void setDataValidationMetrics(DataValidationMetrics.BuilderImpl dataValidationMetrics) {
            this.dataValidationMetrics = dataValidationMetrics != null ? dataValidationMetrics.build() : null;
        }

        public final TrainingMetrics.Builder getTrainingMetrics() {
            return trainingMetrics != null ? trainingMetrics.toBuilder() : null;
        }

        @Override
        public final Builder trainingMetrics(TrainingMetrics trainingMetrics) {
            this.trainingMetrics = trainingMetrics;
            return this;
        }

        public final void setTrainingMetrics(TrainingMetrics.BuilderImpl trainingMetrics) {
            this.trainingMetrics = trainingMetrics != null ? trainingMetrics.build() : null;
        }

        @Override
        public TrainingResult build() {
            return new TrainingResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
