/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDetectorVersionMetadataRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<UpdateDetectorVersionMetadataRequest.Builder, UpdateDetectorVersionMetadataRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorId").getter(getter(UpdateDetectorVersionMetadataRequest::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorVersionId").getter(getter(UpdateDetectorVersionMetadataRequest::detectorVersionId))
            .setter(setter(Builder::detectorVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateDetectorVersionMetadataRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            DETECTOR_VERSION_ID_FIELD, DESCRIPTION_FIELD));

    private final String detectorId;

    private final String detectorVersionId;

    private final String description;

    private UpdateDetectorVersionMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.description = builder.description;
    }

    /**
     * <p>
     * The detector ID.
     * </p>
     * 
     * @return The detector ID.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The detector version ID.
     * </p>
     * 
     * @return The detector version ID.
     */
    public final String detectorVersionId() {
        return detectorVersionId;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDetectorVersionMetadataRequest)) {
            return false;
        }
        UpdateDetectorVersionMetadataRequest other = (UpdateDetectorVersionMetadataRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(detectorVersionId(), other.detectorVersionId())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDetectorVersionMetadataRequest").add("DetectorId", detectorId())
                .add("DetectorVersionId", detectorVersionId()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "detectorVersionId":
            return Optional.ofNullable(clazz.cast(detectorVersionId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDetectorVersionMetadataRequest, T> g) {
        return obj -> g.apply((UpdateDetectorVersionMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDetectorVersionMetadataRequest> {
        /**
         * <p>
         * The detector ID.
         * </p>
         * 
         * @param detectorId
         *        The detector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The detector version ID.
         * </p>
         * 
         * @param detectorVersionId
         *        The detector version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorVersionId(String detectorVersionId);

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param description
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String detectorVersionId;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDetectorVersionMetadataRequest model) {
            super(model);
            detectorId(model.detectorId);
            detectorVersionId(model.detectorVersionId);
            description(model.description);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getDetectorVersionId() {
            return detectorVersionId;
        }

        @Override
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDetectorVersionMetadataRequest build() {
            return new UpdateDetectorVersionMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
