/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelVersionRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<CreateModelVersionRequest.Builder, CreateModelVersionRequest> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(CreateModelVersionRequest::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelType").getter(getter(CreateModelVersionRequest::modelTypeAsString))
            .setter(setter(Builder::modelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()).build();

    private static final SdkField<String> TRAINING_DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingDataSource").getter(getter(CreateModelVersionRequest::trainingDataSourceAsString))
            .setter(setter(Builder::trainingDataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSource").build())
            .build();

    private static final SdkField<TrainingDataSchema> TRAINING_DATA_SCHEMA_FIELD = SdkField
            .<TrainingDataSchema> builder(MarshallingType.SDK_POJO).memberName("trainingDataSchema")
            .getter(getter(CreateModelVersionRequest::trainingDataSchema)).setter(setter(Builder::trainingDataSchema))
            .constructor(TrainingDataSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSchema").build())
            .build();

    private static final SdkField<ExternalEventsDetail> EXTERNAL_EVENTS_DETAIL_FIELD = SdkField
            .<ExternalEventsDetail> builder(MarshallingType.SDK_POJO).memberName("externalEventsDetail")
            .getter(getter(CreateModelVersionRequest::externalEventsDetail)).setter(setter(Builder::externalEventsDetail))
            .constructor(ExternalEventsDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalEventsDetail").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateModelVersionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD,
            MODEL_TYPE_FIELD, TRAINING_DATA_SOURCE_FIELD, TRAINING_DATA_SCHEMA_FIELD, EXTERNAL_EVENTS_DETAIL_FIELD, TAGS_FIELD));

    private final String modelId;

    private final String modelType;

    private final String trainingDataSource;

    private final TrainingDataSchema trainingDataSchema;

    private final ExternalEventsDetail externalEventsDetail;

    private final List<Tag> tags;

    private CreateModelVersionRequest(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.modelType = builder.modelType;
        this.trainingDataSource = builder.trainingDataSource;
        this.trainingDataSchema = builder.trainingDataSchema;
        this.externalEventsDetail = builder.externalEventsDetail;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The model ID.
     * </p>
     * 
     * @return The model ID.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return The model type.
     * @see ModelTypeEnum
     */
    public final ModelTypeEnum modelType() {
        return ModelTypeEnum.fromValue(modelType);
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return The model type.
     * @see ModelTypeEnum
     */
    public final String modelTypeAsString() {
        return modelType;
    }

    /**
     * <p>
     * The training data source location in Amazon S3.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trainingDataSource} will return {@link TrainingDataSourceEnum#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trainingDataSourceAsString}.
     * </p>
     * 
     * @return The training data source location in Amazon S3.
     * @see TrainingDataSourceEnum
     */
    public final TrainingDataSourceEnum trainingDataSource() {
        return TrainingDataSourceEnum.fromValue(trainingDataSource);
    }

    /**
     * <p>
     * The training data source location in Amazon S3.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trainingDataSource} will return {@link TrainingDataSourceEnum#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trainingDataSourceAsString}.
     * </p>
     * 
     * @return The training data source location in Amazon S3.
     * @see TrainingDataSourceEnum
     */
    public final String trainingDataSourceAsString() {
        return trainingDataSource;
    }

    /**
     * <p>
     * The training data schema.
     * </p>
     * 
     * @return The training data schema.
     */
    public final TrainingDataSchema trainingDataSchema() {
        return trainingDataSchema;
    }

    /**
     * <p>
     * Details for the external events data used for model version training. Required if <code>trainingDataSource</code>
     * is <code>EXTERNAL_EVENTS</code>.
     * </p>
     * 
     * @return Details for the external events data used for model version training. Required if
     *         <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.
     */
    public final ExternalEventsDetail externalEventsDetail() {
        return externalEventsDetail;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of key and value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of key and value pairs.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(externalEventsDetail());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelVersionRequest)) {
            return false;
        }
        CreateModelVersionRequest other = (CreateModelVersionRequest) obj;
        return Objects.equals(modelId(), other.modelId()) && Objects.equals(modelTypeAsString(), other.modelTypeAsString())
                && Objects.equals(trainingDataSourceAsString(), other.trainingDataSourceAsString())
                && Objects.equals(trainingDataSchema(), other.trainingDataSchema())
                && Objects.equals(externalEventsDetail(), other.externalEventsDetail()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelVersionRequest").add("ModelId", modelId()).add("ModelType", modelTypeAsString())
                .add("TrainingDataSource", trainingDataSourceAsString()).add("TrainingDataSchema", trainingDataSchema())
                .add("ExternalEventsDetail", externalEventsDetail()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "modelType":
            return Optional.ofNullable(clazz.cast(modelTypeAsString()));
        case "trainingDataSource":
            return Optional.ofNullable(clazz.cast(trainingDataSourceAsString()));
        case "trainingDataSchema":
            return Optional.ofNullable(clazz.cast(trainingDataSchema()));
        case "externalEventsDetail":
            return Optional.ofNullable(clazz.cast(externalEventsDetail()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelVersionRequest, T> g) {
        return obj -> g.apply((CreateModelVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateModelVersionRequest> {
        /**
         * <p>
         * The model ID.
         * </p>
         * 
         * @param modelId
         *        The model ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The model type.
         * </p>
         * 
         * @param modelType
         *        The model type.
         * @see ModelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelTypeEnum
         */
        Builder modelType(String modelType);

        /**
         * <p>
         * The model type.
         * </p>
         * 
         * @param modelType
         *        The model type.
         * @see ModelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelTypeEnum
         */
        Builder modelType(ModelTypeEnum modelType);

        /**
         * <p>
         * The training data source location in Amazon S3.
         * </p>
         * 
         * @param trainingDataSource
         *        The training data source location in Amazon S3.
         * @see TrainingDataSourceEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingDataSourceEnum
         */
        Builder trainingDataSource(String trainingDataSource);

        /**
         * <p>
         * The training data source location in Amazon S3.
         * </p>
         * 
         * @param trainingDataSource
         *        The training data source location in Amazon S3.
         * @see TrainingDataSourceEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingDataSourceEnum
         */
        Builder trainingDataSource(TrainingDataSourceEnum trainingDataSource);

        /**
         * <p>
         * The training data schema.
         * </p>
         * 
         * @param trainingDataSchema
         *        The training data schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataSchema(TrainingDataSchema trainingDataSchema);

        /**
         * <p>
         * The training data schema.
         * </p>
         * This is a convenience that creates an instance of the {@link TrainingDataSchema.Builder} avoiding the need to
         * create one manually via {@link TrainingDataSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingDataSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingDataSchema(TrainingDataSchema)}.
         * 
         * @param trainingDataSchema
         *        a consumer that will call methods on {@link TrainingDataSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingDataSchema(TrainingDataSchema)
         */
        default Builder trainingDataSchema(Consumer<TrainingDataSchema.Builder> trainingDataSchema) {
            return trainingDataSchema(TrainingDataSchema.builder().applyMutation(trainingDataSchema).build());
        }

        /**
         * <p>
         * Details for the external events data used for model version training. Required if
         * <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.
         * </p>
         * 
         * @param externalEventsDetail
         *        Details for the external events data used for model version training. Required if
         *        <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalEventsDetail(ExternalEventsDetail externalEventsDetail);

        /**
         * <p>
         * Details for the external events data used for model version training. Required if
         * <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link ExternalEventsDetail.Builder} avoiding the need
         * to create one manually via {@link ExternalEventsDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExternalEventsDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #externalEventsDetail(ExternalEventsDetail)}.
         * 
         * @param externalEventsDetail
         *        a consumer that will call methods on {@link ExternalEventsDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalEventsDetail(ExternalEventsDetail)
         */
        default Builder externalEventsDetail(Consumer<ExternalEventsDetail.Builder> externalEventsDetail) {
            return externalEventsDetail(ExternalEventsDetail.builder().applyMutation(externalEventsDetail).build());
        }

        /**
         * <p>
         * A collection of key and value pairs.
         * </p>
         * 
         * @param tags
         *        A collection of key and value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A collection of key and value pairs.
         * </p>
         * 
         * @param tags
         *        A collection of key and value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A collection of key and value pairs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String modelId;

        private String modelType;

        private String trainingDataSource;

        private TrainingDataSchema trainingDataSchema;

        private ExternalEventsDetail externalEventsDetail;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelVersionRequest model) {
            super(model);
            modelId(model.modelId);
            modelType(model.modelType);
            trainingDataSource(model.trainingDataSource);
            trainingDataSchema(model.trainingDataSchema);
            externalEventsDetail(model.externalEventsDetail);
            tags(model.tags);
        }

        public final String getModelId() {
            return modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public final String getModelType() {
            return modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelTypeEnum modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        public final String getTrainingDataSource() {
            return trainingDataSource;
        }

        @Override
        public final Builder trainingDataSource(String trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
            return this;
        }

        @Override
        public final Builder trainingDataSource(TrainingDataSourceEnum trainingDataSource) {
            this.trainingDataSource(trainingDataSource == null ? null : trainingDataSource.toString());
            return this;
        }

        public final void setTrainingDataSource(String trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
        }

        public final TrainingDataSchema.Builder getTrainingDataSchema() {
            return trainingDataSchema != null ? trainingDataSchema.toBuilder() : null;
        }

        @Override
        public final Builder trainingDataSchema(TrainingDataSchema trainingDataSchema) {
            this.trainingDataSchema = trainingDataSchema;
            return this;
        }

        public final void setTrainingDataSchema(TrainingDataSchema.BuilderImpl trainingDataSchema) {
            this.trainingDataSchema = trainingDataSchema != null ? trainingDataSchema.build() : null;
        }

        public final ExternalEventsDetail.Builder getExternalEventsDetail() {
            return externalEventsDetail != null ? externalEventsDetail.toBuilder() : null;
        }

        @Override
        public final Builder externalEventsDetail(ExternalEventsDetail externalEventsDetail) {
            this.externalEventsDetail = externalEventsDetail;
            return this;
        }

        public final void setExternalEventsDetail(ExternalEventsDetail.BuilderImpl externalEventsDetail) {
            this.externalEventsDetail = externalEventsDetail != null ? externalEventsDetail.build() : null;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelVersionRequest build() {
            return new CreateModelVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
