/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLabelsResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetLabelsResponse.Builder, GetLabelsResponse> {
    private static final SdkField<List<Label>> LABELS_FIELD = SdkField
            .<List<Label>> builder(MarshallingType.LIST)
            .memberName("labels")
            .getter(getter(GetLabelsResponse::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Label> builder(MarshallingType.SDK_POJO)
                                            .constructor(Label::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetLabelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LABELS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Label> labels;

    private final String nextToken;

    private GetLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.labels = builder.labels;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Labels property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of labels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLabels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of labels.
     */
    public final List<Label> labels() {
        return labels;
    }

    /**
     * <p>
     * The next page token.
     * </p>
     * 
     * @return The next page token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLabelsResponse)) {
            return false;
        }
        GetLabelsResponse other = (GetLabelsResponse) obj;
        return hasLabels() == other.hasLabels() && Objects.equals(labels(), other.labels())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLabelsResponse").add("Labels", hasLabels() ? labels() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLabelsResponse, T> g) {
        return obj -> g.apply((GetLabelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLabelsResponse> {
        /**
         * <p>
         * An array of labels.
         * </p>
         * 
         * @param labels
         *        An array of labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<Label> labels);

        /**
         * <p>
         * An array of labels.
         * </p>
         * 
         * @param labels
         *        An array of labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Label... labels);

        /**
         * <p>
         * An array of labels.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Label>.Builder} avoiding the need to create
         * one manually via {@link List<Label>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Label>.Builder#build()} is called immediately and its result
         * is passed to {@link #labels(List<Label>)}.
         * 
         * @param labels
         *        a consumer that will call methods on {@link List<Label>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labels(List<Label>)
         */
        Builder labels(Consumer<Label.Builder>... labels);

        /**
         * <p>
         * The next page token.
         * </p>
         * 
         * @param nextToken
         *        The next page token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<Label> labels = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLabelsResponse model) {
            super(model);
            labels(model.labels);
            nextToken(model.nextToken);
        }

        public final List<Label.Builder> getLabels() {
            List<Label.Builder> result = _labelListCopier.copyToBuilder(this.labels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder labels(Collection<Label> labels) {
            this.labels = _labelListCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Label... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<Label.Builder>... labels) {
            labels(Stream.of(labels).map(c -> Label.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLabels(Collection<Label.BuilderImpl> labels) {
            this.labels = _labelListCopier.copyFromBuilder(labels);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetLabelsResponse build() {
            return new GetLabelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
