/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A variable in the list of variables for the batch create variable request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VariableEntry implements SdkPojo, Serializable, ToCopyableBuilder<VariableEntry.Builder, VariableEntry> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(VariableEntry::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(VariableEntry::dataType)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSource").getter(getter(VariableEntry::dataSource)).setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultValue").getter(getter(VariableEntry::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(VariableEntry::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> VARIABLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("variableType").getter(getter(VariableEntry::variableType)).setter(setter(Builder::variableType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATA_TYPE_FIELD,
            DATA_SOURCE_FIELD, DEFAULT_VALUE_FIELD, DESCRIPTION_FIELD, VARIABLE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String dataType;

    private final String dataSource;

    private final String defaultValue;

    private final String description;

    private final String variableType;

    private VariableEntry(BuilderImpl builder) {
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.dataSource = builder.dataSource;
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
        this.variableType = builder.variableType;
    }

    /**
     * <p>
     * The name of the variable.
     * </p>
     * 
     * @return The name of the variable.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The data type of the variable.
     * </p>
     * 
     * @return The data type of the variable.
     */
    public final String dataType() {
        return dataType;
    }

    /**
     * <p>
     * The data source of the variable.
     * </p>
     * 
     * @return The data source of the variable.
     */
    public final String dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The default value of the variable.
     * </p>
     * 
     * @return The default value of the variable.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The description of the variable.
     * </p>
     * 
     * @return The description of the variable.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of the variable. For more information see <a
     * href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable
     * types</a>.
     * </p>
     * <p>
     * Valid Values:
     * <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT </code>
     * </p>
     * 
     * @return The type of the variable. For more information see <a
     *         href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable
     *         types</a>.</p>
     *         <p>
     *         Valid Values:
     *         <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT </code>
     */
    public final String variableType() {
        return variableType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dataType());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(variableType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableEntry)) {
            return false;
        }
        VariableEntry other = (VariableEntry) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(dataType(), other.dataType())
                && Objects.equals(dataSource(), other.dataSource()) && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(description(), other.description()) && Objects.equals(variableType(), other.variableType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VariableEntry").add("Name", name()).add("DataType", dataType()).add("DataSource", dataSource())
                .add("DefaultValue", defaultValue()).add("Description", description()).add("VariableType", variableType())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataType()));
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "variableType":
            return Optional.ofNullable(clazz.cast(variableType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VariableEntry, T> g) {
        return obj -> g.apply((VariableEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VariableEntry> {
        /**
         * <p>
         * The name of the variable.
         * </p>
         * 
         * @param name
         *        The name of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data type of the variable.
         * </p>
         * 
         * @param dataType
         *        The data type of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The data source of the variable.
         * </p>
         * 
         * @param dataSource
         *        The data source of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * The default value of the variable.
         * </p>
         * 
         * @param defaultValue
         *        The default value of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The description of the variable.
         * </p>
         * 
         * @param description
         *        The description of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of the variable. For more information see <a
         * href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable
         * types</a>.
         * </p>
         * <p>
         * Valid Values:
         * <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT </code>
         * </p>
         * 
         * @param variableType
         *        The type of the variable. For more information see <a
         *        href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types"
         *        >Variable types</a>.</p>
         *        <p>
         *        Valid Values:
         *        <code>AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableType(String variableType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String dataType;

        private String dataSource;

        private String defaultValue;

        private String description;

        private String variableType;

        private BuilderImpl() {
        }

        private BuilderImpl(VariableEntry model) {
            name(model.name);
            dataType(model.dataType);
            dataSource(model.dataSource);
            defaultValue(model.defaultValue);
            description(model.description);
            variableType(model.variableType);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDataType() {
            return dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getDataSource() {
            return dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getVariableType() {
            return variableType;
        }

        @Override
        public final Builder variableType(String variableType) {
            this.variableType = variableType;
            return this;
        }

        public final void setVariableType(String variableType) {
            this.variableType = variableType;
        }

        @Override
        public VariableEntry build() {
            return new VariableEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
