/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The variable importance metrics details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VariableImportanceMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<VariableImportanceMetrics.Builder, VariableImportanceMetrics> {
    private static final SdkField<List<LogitMetric>> LOGIT_METRICS_FIELD = SdkField
            .<List<LogitMetric>> builder(MarshallingType.LIST)
            .memberName("LogitMetrics")
            .getter(getter(VariableImportanceMetrics::logitMetrics))
            .setter(setter(Builder::logitMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogitMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogitMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogitMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGIT_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<LogitMetric> logitMetrics;

    private VariableImportanceMetrics(BuilderImpl builder) {
        this.logitMetrics = builder.logitMetrics;
    }

    /**
     * Returns true if the LogitMetrics property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLogitMetrics() {
        return logitMetrics != null && !(logitMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of variable metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLogitMetrics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of variable metrics.
     */
    public final List<LogitMetric> logitMetrics() {
        return logitMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLogitMetrics() ? logitMetrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableImportanceMetrics)) {
            return false;
        }
        VariableImportanceMetrics other = (VariableImportanceMetrics) obj;
        return hasLogitMetrics() == other.hasLogitMetrics() && Objects.equals(logitMetrics(), other.logitMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VariableImportanceMetrics").add("LogitMetrics", hasLogitMetrics() ? logitMetrics() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogitMetrics":
            return Optional.ofNullable(clazz.cast(logitMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VariableImportanceMetrics, T> g) {
        return obj -> g.apply((VariableImportanceMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VariableImportanceMetrics> {
        /**
         * <p>
         * List of variable metrics.
         * </p>
         * 
         * @param logitMetrics
         *        List of variable metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logitMetrics(Collection<LogitMetric> logitMetrics);

        /**
         * <p>
         * List of variable metrics.
         * </p>
         * 
         * @param logitMetrics
         *        List of variable metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logitMetrics(LogitMetric... logitMetrics);

        /**
         * <p>
         * List of variable metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LogitMetric>.Builder} avoiding the need to
         * create one manually via {@link List<LogitMetric>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LogitMetric>.Builder#build()} is called immediately and its
         * result is passed to {@link #logitMetrics(List<LogitMetric>)}.
         * 
         * @param logitMetrics
         *        a consumer that will call methods on {@link List<LogitMetric>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logitMetrics(List<LogitMetric>)
         */
        Builder logitMetrics(Consumer<LogitMetric.Builder>... logitMetrics);
    }

    static final class BuilderImpl implements Builder {
        private List<LogitMetric> logitMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VariableImportanceMetrics model) {
            logitMetrics(model.logitMetrics);
        }

        public final List<LogitMetric.Builder> getLogitMetrics() {
            List<LogitMetric.Builder> result = ListOfLogitMetricsCopier.copyToBuilder(this.logitMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder logitMetrics(Collection<LogitMetric> logitMetrics) {
            this.logitMetrics = ListOfLogitMetricsCopier.copy(logitMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logitMetrics(LogitMetric... logitMetrics) {
            logitMetrics(Arrays.asList(logitMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logitMetrics(Consumer<LogitMetric.Builder>... logitMetrics) {
            logitMetrics(Stream.of(logitMetrics).map(c -> LogitMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLogitMetrics(Collection<LogitMetric.BuilderImpl> logitMetrics) {
            this.logitMetrics = ListOfLogitMetricsCopier.copyFromBuilder(logitMetrics);
        }

        @Override
        public VariableImportanceMetrics build() {
            return new VariableImportanceMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
