/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FieldValidationMessage;
import software.amazon.awssdk.services.frauddetector.model.FileValidationMessage;
import software.amazon.awssdk.services.frauddetector.model._fieldValidationMessageListCopier;
import software.amazon.awssdk.services.frauddetector.model._fileValidationMessageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataValidationMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataValidationMetrics> {
    private static final SdkField<List<FileValidationMessage>> FILE_LEVEL_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fileLevelMessages").getter(DataValidationMetrics.getter(DataValidationMetrics::fileLevelMessages)).setter(DataValidationMetrics.setter(Builder::fileLevelMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileLevelMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileValidationMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FieldValidationMessage>> FIELD_LEVEL_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fieldLevelMessages").getter(DataValidationMetrics.getter(DataValidationMetrics::fieldLevelMessages)).setter(DataValidationMetrics.setter(Builder::fieldLevelMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldLevelMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldValidationMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_LEVEL_MESSAGES_FIELD, FIELD_LEVEL_MESSAGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<FileValidationMessage> fileLevelMessages;
    private final List<FieldValidationMessage> fieldLevelMessages;

    private DataValidationMetrics(BuilderImpl builder) {
        this.fileLevelMessages = builder.fileLevelMessages;
        this.fieldLevelMessages = builder.fieldLevelMessages;
    }

    public final boolean hasFileLevelMessages() {
        return this.fileLevelMessages != null && !(this.fileLevelMessages instanceof SdkAutoConstructList);
    }

    public final List<FileValidationMessage> fileLevelMessages() {
        return this.fileLevelMessages;
    }

    public final boolean hasFieldLevelMessages() {
        return this.fieldLevelMessages != null && !(this.fieldLevelMessages instanceof SdkAutoConstructList);
    }

    public final List<FieldValidationMessage> fieldLevelMessages() {
        return this.fieldLevelMessages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileLevelMessages() ? this.fileLevelMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldLevelMessages() ? this.fieldLevelMessages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataValidationMetrics)) {
            return false;
        }
        DataValidationMetrics other = (DataValidationMetrics)obj;
        return this.hasFileLevelMessages() == other.hasFileLevelMessages() && Objects.equals(this.fileLevelMessages(), other.fileLevelMessages()) && this.hasFieldLevelMessages() == other.hasFieldLevelMessages() && Objects.equals(this.fieldLevelMessages(), other.fieldLevelMessages());
    }

    public final String toString() {
        return ToString.builder((String)"DataValidationMetrics").add("FileLevelMessages", this.hasFileLevelMessages() ? this.fileLevelMessages() : null).add("FieldLevelMessages", this.hasFieldLevelMessages() ? this.fieldLevelMessages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileLevelMessages": {
                return Optional.ofNullable(clazz.cast(this.fileLevelMessages()));
            }
            case "fieldLevelMessages": {
                return Optional.ofNullable(clazz.cast(this.fieldLevelMessages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataValidationMetrics, T> g) {
        return obj -> g.apply((DataValidationMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FileValidationMessage> fileLevelMessages = DefaultSdkAutoConstructList.getInstance();
        private List<FieldValidationMessage> fieldLevelMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataValidationMetrics model) {
            this.fileLevelMessages(model.fileLevelMessages);
            this.fieldLevelMessages(model.fieldLevelMessages);
        }

        public final List<FileValidationMessage.Builder> getFileLevelMessages() {
            List<FileValidationMessage.Builder> result = _fileValidationMessageListCopier.copyToBuilder(this.fileLevelMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder fileLevelMessages(Collection<FileValidationMessage> fileLevelMessages) {
            this.fileLevelMessages = _fileValidationMessageListCopier.copy(fileLevelMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileLevelMessages(FileValidationMessage ... fileLevelMessages) {
            this.fileLevelMessages(Arrays.asList(fileLevelMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileLevelMessages(Consumer<FileValidationMessage.Builder> ... fileLevelMessages) {
            this.fileLevelMessages(Stream.of(fileLevelMessages).map(c -> (FileValidationMessage)((FileValidationMessage.Builder)FileValidationMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFileLevelMessages(Collection<FileValidationMessage.BuilderImpl> fileLevelMessages) {
            this.fileLevelMessages = _fileValidationMessageListCopier.copyFromBuilder(fileLevelMessages);
        }

        public final List<FieldValidationMessage.Builder> getFieldLevelMessages() {
            List<FieldValidationMessage.Builder> result = _fieldValidationMessageListCopier.copyToBuilder(this.fieldLevelMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder fieldLevelMessages(Collection<FieldValidationMessage> fieldLevelMessages) {
            this.fieldLevelMessages = _fieldValidationMessageListCopier.copy(fieldLevelMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldLevelMessages(FieldValidationMessage ... fieldLevelMessages) {
            this.fieldLevelMessages(Arrays.asList(fieldLevelMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldLevelMessages(Consumer<FieldValidationMessage.Builder> ... fieldLevelMessages) {
            this.fieldLevelMessages(Stream.of(fieldLevelMessages).map(c -> (FieldValidationMessage)((FieldValidationMessage.Builder)FieldValidationMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFieldLevelMessages(Collection<FieldValidationMessage.BuilderImpl> fieldLevelMessages) {
            this.fieldLevelMessages = _fieldValidationMessageListCopier.copyFromBuilder(fieldLevelMessages);
        }

        public DataValidationMetrics build() {
            return new DataValidationMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataValidationMetrics> {
        public Builder fileLevelMessages(Collection<FileValidationMessage> var1);

        public Builder fileLevelMessages(FileValidationMessage ... var1);

        public Builder fileLevelMessages(Consumer<FileValidationMessage.Builder> ... var1);

        public Builder fieldLevelMessages(Collection<FieldValidationMessage> var1);

        public Builder fieldLevelMessages(FieldValidationMessage ... var1);

        public Builder fieldLevelMessages(Consumer<FieldValidationMessage.Builder> ... var1);
    }
}

