/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The entity details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Entity implements SdkPojo, Serializable, ToCopyableBuilder<Entity.Builder, Entity> {
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(Entity::entityType)).setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(Entity::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_TYPE_FIELD,
            ENTITY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entityType;

    private final String entityId;

    private Entity(BuilderImpl builder) {
        this.entityType = builder.entityType;
        this.entityId = builder.entityId;
    }

    /**
     * <p>
     * The entity type.
     * </p>
     * 
     * @return The entity type.
     */
    public final String entityType() {
        return entityType;
    }

    /**
     * <p>
     * The entity ID. If you do not know the <code>entityId</code>, you can pass <code>unknown</code>, which is
     * areserved string literal.
     * </p>
     * 
     * @return The entity ID. If you do not know the <code>entityId</code>, you can pass <code>unknown</code>, which is
     *         areserved string literal.
     */
    public final String entityId() {
        return entityId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityType());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity) obj;
        return Objects.equals(entityType(), other.entityType()) && Objects.equals(entityId(), other.entityId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Entity").add("EntityType", entityType()).add("EntityId", entityId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityType()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Entity, T> g) {
        return obj -> g.apply((Entity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Entity> {
        /**
         * <p>
         * The entity type.
         * </p>
         * 
         * @param entityType
         *        The entity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The entity ID. If you do not know the <code>entityId</code>, you can pass <code>unknown</code>, which is
         * areserved string literal.
         * </p>
         * 
         * @param entityId
         *        The entity ID. If you do not know the <code>entityId</code>, you can pass <code>unknown</code>, which
         *        is areserved string literal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);
    }

    static final class BuilderImpl implements Builder {
        private String entityType;

        private String entityId;

        private BuilderImpl() {
        }

        private BuilderImpl(Entity model) {
            entityType(model.entityType);
            entityId(model.entityId);
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        @Transient
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        @Transient
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        @Override
        public Entity build() {
            return new Entity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
