/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The fraud prediction scores from Amazon SageMaker model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalModelOutputs implements SdkPojo, Serializable,
        ToCopyableBuilder<ExternalModelOutputs.Builder, ExternalModelOutputs> {
    private static final SdkField<ExternalModelSummary> EXTERNAL_MODEL_FIELD = SdkField
            .<ExternalModelSummary> builder(MarshallingType.SDK_POJO).memberName("externalModel")
            .getter(getter(ExternalModelOutputs::externalModel)).setter(setter(Builder::externalModel))
            .constructor(ExternalModelSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalModel").build()).build();

    private static final SdkField<Map<String, String>> OUTPUTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("outputs")
            .getter(getter(ExternalModelOutputs::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_MODEL_FIELD,
            OUTPUTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ExternalModelSummary externalModel;

    private final Map<String, String> outputs;

    private ExternalModelOutputs(BuilderImpl builder) {
        this.externalModel = builder.externalModel;
        this.outputs = builder.outputs;
    }

    /**
     * <p>
     * The Amazon SageMaker model.
     * </p>
     * 
     * @return The Amazon SageMaker model.
     */
    public final ExternalModelSummary externalModel() {
        return externalModel;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The fraud prediction scores from Amazon SageMaker model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The fraud prediction scores from Amazon SageMaker model.
     */
    public final Map<String, String> outputs() {
        return outputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(externalModel());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalModelOutputs)) {
            return false;
        }
        ExternalModelOutputs other = (ExternalModelOutputs) obj;
        return Objects.equals(externalModel(), other.externalModel()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalModelOutputs").add("ExternalModel", externalModel())
                .add("Outputs", hasOutputs() ? outputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "externalModel":
            return Optional.ofNullable(clazz.cast(externalModel()));
        case "outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalModelOutputs, T> g) {
        return obj -> g.apply((ExternalModelOutputs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalModelOutputs> {
        /**
         * <p>
         * The Amazon SageMaker model.
         * </p>
         * 
         * @param externalModel
         *        The Amazon SageMaker model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalModel(ExternalModelSummary externalModel);

        /**
         * <p>
         * The Amazon SageMaker model.
         * </p>
         * This is a convenience that creates an instance of the {@link ExternalModelSummary.Builder} avoiding the need
         * to create one manually via {@link ExternalModelSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExternalModelSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #externalModel(ExternalModelSummary)}.
         * 
         * @param externalModel
         *        a consumer that will call methods on {@link ExternalModelSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalModel(ExternalModelSummary)
         */
        default Builder externalModel(Consumer<ExternalModelSummary.Builder> externalModel) {
            return externalModel(ExternalModelSummary.builder().applyMutation(externalModel).build());
        }

        /**
         * <p>
         * The fraud prediction scores from Amazon SageMaker model.
         * </p>
         * 
         * @param outputs
         *        The fraud prediction scores from Amazon SageMaker model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Map<String, String> outputs);
    }

    static final class BuilderImpl implements Builder {
        private ExternalModelSummary externalModel;

        private Map<String, String> outputs = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalModelOutputs model) {
            externalModel(model.externalModel);
            outputs(model.outputs);
        }

        public final ExternalModelSummary.Builder getExternalModel() {
            return externalModel != null ? externalModel.toBuilder() : null;
        }

        public final void setExternalModel(ExternalModelSummary.BuilderImpl externalModel) {
            this.externalModel = externalModel != null ? externalModel.build() : null;
        }

        @Override
        @Transient
        public final Builder externalModel(ExternalModelSummary externalModel) {
            this.externalModel = externalModel;
            return this;
        }

        public final Map<String, String> getOutputs() {
            if (outputs instanceof SdkAutoConstructMap) {
                return null;
            }
            return outputs;
        }

        public final void setOutputs(Map<String, String> outputs) {
            this.outputs = ExternalModelPredictionMapCopier.copy(outputs);
        }

        @Override
        @Transient
        public final Builder outputs(Map<String, String> outputs) {
            this.outputs = ExternalModelPredictionMapCopier.copy(outputs);
            return this;
        }

        @Override
        public ExternalModelOutputs build() {
            return new ExternalModelOutputs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
