/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A pre-formed Amazon SageMaker model input you can include if your detector version includes an imported Amazon
 * SageMaker model endpoint with pass-through input configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelEndpointDataBlob implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelEndpointDataBlob.Builder, ModelEndpointDataBlob> {
    private static final SdkField<SdkBytes> BYTE_BUFFER_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("byteBuffer").getter(getter(ModelEndpointDataBlob::byteBuffer)).setter(setter(Builder::byteBuffer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("byteBuffer").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(ModelEndpointDataBlob::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_BUFFER_FIELD,
            CONTENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes byteBuffer;

    private final String contentType;

    private ModelEndpointDataBlob(BuilderImpl builder) {
        this.byteBuffer = builder.byteBuffer;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The byte buffer of the Amazon SageMaker model endpoint input data blob.
     * </p>
     * 
     * @return The byte buffer of the Amazon SageMaker model endpoint input data blob.
     */
    public final SdkBytes byteBuffer() {
        return byteBuffer;
    }

    /**
     * <p>
     * The content type of the Amazon SageMaker model endpoint input data blob.
     * </p>
     * 
     * @return The content type of the Amazon SageMaker model endpoint input data blob.
     */
    public final String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(byteBuffer());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelEndpointDataBlob)) {
            return false;
        }
        ModelEndpointDataBlob other = (ModelEndpointDataBlob) obj;
        return Objects.equals(byteBuffer(), other.byteBuffer()) && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelEndpointDataBlob").add("ByteBuffer", byteBuffer()).add("ContentType", contentType())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "byteBuffer":
            return Optional.ofNullable(clazz.cast(byteBuffer()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelEndpointDataBlob, T> g) {
        return obj -> g.apply((ModelEndpointDataBlob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelEndpointDataBlob> {
        /**
         * <p>
         * The byte buffer of the Amazon SageMaker model endpoint input data blob.
         * </p>
         * 
         * @param byteBuffer
         *        The byte buffer of the Amazon SageMaker model endpoint input data blob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteBuffer(SdkBytes byteBuffer);

        /**
         * <p>
         * The content type of the Amazon SageMaker model endpoint input data blob.
         * </p>
         * 
         * @param contentType
         *        The content type of the Amazon SageMaker model endpoint input data blob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes byteBuffer;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelEndpointDataBlob model) {
            byteBuffer(model.byteBuffer);
            contentType(model.contentType);
        }

        public final ByteBuffer getByteBuffer() {
            return byteBuffer == null ? null : byteBuffer.asByteBuffer();
        }

        public final void setByteBuffer(ByteBuffer byteBuffer) {
            byteBuffer(byteBuffer == null ? null : SdkBytes.fromByteBuffer(byteBuffer));
        }

        @Override
        @Transient
        public final Builder byteBuffer(SdkBytes byteBuffer) {
            this.byteBuffer = byteBuffer;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public ModelEndpointDataBlob build() {
            return new ModelEndpointDataBlob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
