/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleDetail implements SdkPojo, Serializable, ToCopyableBuilder<RuleDetail.Builder, RuleDetail> {
    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ruleId")
            .getter(getter(RuleDetail::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(RuleDetail::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorId").getter(getter(RuleDetail::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleVersion").getter(getter(RuleDetail::ruleVersion)).setter(setter(Builder::ruleVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleVersion").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expression").getter(getter(RuleDetail::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(RuleDetail::languageAsString)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<List<String>> OUTCOMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("outcomes")
            .getter(getter(RuleDetail::outcomes))
            .setter(setter(Builder::outcomes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedTime").getter(getter(RuleDetail::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdTime").getter(getter(RuleDetail::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RuleDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ID_FIELD,
            DESCRIPTION_FIELD, DETECTOR_ID_FIELD, RULE_VERSION_FIELD, EXPRESSION_FIELD, LANGUAGE_FIELD, OUTCOMES_FIELD,
            LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleId;

    private final String description;

    private final String detectorId;

    private final String ruleVersion;

    private final String expression;

    private final String language;

    private final List<String> outcomes;

    private final String lastUpdatedTime;

    private final String createdTime;

    private final String arn;

    private RuleDetail(BuilderImpl builder) {
        this.ruleId = builder.ruleId;
        this.description = builder.description;
        this.detectorId = builder.detectorId;
        this.ruleVersion = builder.ruleVersion;
        this.expression = builder.expression;
        this.language = builder.language;
        this.outcomes = builder.outcomes;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The rule ID.
     * </p>
     * 
     * @return The rule ID.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * The rule description.
     * </p>
     * 
     * @return The rule description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The detector for which the rule is associated.
     * </p>
     * 
     * @return The detector for which the rule is associated.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The rule version.
     * </p>
     * 
     * @return The rule version.
     */
    public final String ruleVersion() {
        return ruleVersion;
    }

    /**
     * <p>
     * The rule expression.
     * </p>
     * 
     * @return The rule expression.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * The rule language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link Language#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageAsString}.
     * </p>
     * 
     * @return The rule language.
     * @see Language
     */
    public final Language language() {
        return Language.fromValue(language);
    }

    /**
     * <p>
     * The rule language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link Language#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageAsString}.
     * </p>
     * 
     * @return The rule language.
     * @see Language
     */
    public final String languageAsString() {
        return language;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outcomes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutcomes() {
        return outcomes != null && !(outcomes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rule outcomes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutcomes} method.
     * </p>
     * 
     * @return The rule outcomes.
     */
    public final List<String> outcomes() {
        return outcomes;
    }

    /**
     * <p>
     * Timestamp of the last time the rule was updated.
     * </p>
     * 
     * @return Timestamp of the last time the rule was updated.
     */
    public final String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The timestamp of when the rule was created.
     * </p>
     * 
     * @return The timestamp of when the rule was created.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The rule ARN.
     * </p>
     * 
     * @return The rule ARN.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleVersion());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutcomes() ? outcomes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleDetail)) {
            return false;
        }
        RuleDetail other = (RuleDetail) obj;
        return Objects.equals(ruleId(), other.ruleId()) && Objects.equals(description(), other.description())
                && Objects.equals(detectorId(), other.detectorId()) && Objects.equals(ruleVersion(), other.ruleVersion())
                && Objects.equals(expression(), other.expression())
                && Objects.equals(languageAsString(), other.languageAsString()) && hasOutcomes() == other.hasOutcomes()
                && Objects.equals(outcomes(), other.outcomes()) && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleDetail").add("RuleId", ruleId()).add("Description", description())
                .add("DetectorId", detectorId()).add("RuleVersion", ruleVersion())
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Language", languageAsString()).add("Outcomes", hasOutcomes() ? outcomes() : null)
                .add("LastUpdatedTime", lastUpdatedTime()).add("CreatedTime", createdTime()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "ruleVersion":
            return Optional.ofNullable(clazz.cast(ruleVersion()));
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "language":
            return Optional.ofNullable(clazz.cast(languageAsString()));
        case "outcomes":
            return Optional.ofNullable(clazz.cast(outcomes()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleDetail, T> g) {
        return obj -> g.apply((RuleDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleDetail> {
        /**
         * <p>
         * The rule ID.
         * </p>
         * 
         * @param ruleId
         *        The rule ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The rule description.
         * </p>
         * 
         * @param description
         *        The rule description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The detector for which the rule is associated.
         * </p>
         * 
         * @param detectorId
         *        The detector for which the rule is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The rule version.
         * </p>
         * 
         * @param ruleVersion
         *        The rule version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleVersion(String ruleVersion);

        /**
         * <p>
         * The rule expression.
         * </p>
         * 
         * @param expression
         *        The rule expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * The rule language.
         * </p>
         * 
         * @param language
         *        The rule language.
         * @see Language
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Language
         */
        Builder language(String language);

        /**
         * <p>
         * The rule language.
         * </p>
         * 
         * @param language
         *        The rule language.
         * @see Language
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Language
         */
        Builder language(Language language);

        /**
         * <p>
         * The rule outcomes.
         * </p>
         * 
         * @param outcomes
         *        The rule outcomes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomes(Collection<String> outcomes);

        /**
         * <p>
         * The rule outcomes.
         * </p>
         * 
         * @param outcomes
         *        The rule outcomes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomes(String... outcomes);

        /**
         * <p>
         * Timestamp of the last time the rule was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        Timestamp of the last time the rule was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);

        /**
         * <p>
         * The timestamp of when the rule was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp of when the rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * The rule ARN.
         * </p>
         * 
         * @param arn
         *        The rule ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String ruleId;

        private String description;

        private String detectorId;

        private String ruleVersion;

        private String expression;

        private String language;

        private List<String> outcomes = DefaultSdkAutoConstructList.getInstance();

        private String lastUpdatedTime;

        private String createdTime;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleDetail model) {
            ruleId(model.ruleId);
            description(model.description);
            detectorId(model.detectorId);
            ruleVersion(model.ruleVersion);
            expression(model.expression);
            language(model.language);
            outcomes(model.outcomes);
            lastUpdatedTime(model.lastUpdatedTime);
            createdTime(model.createdTime);
            arn(model.arn);
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        @Transient
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        @Transient
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getRuleVersion() {
            return ruleVersion;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        @Override
        @Transient
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        @Transient
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        @Transient
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        @Transient
        public final Builder language(Language language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final Collection<String> getOutcomes() {
            if (outcomes instanceof SdkAutoConstructList) {
                return null;
            }
            return outcomes;
        }

        public final void setOutcomes(Collection<String> outcomes) {
            this.outcomes = NonEmptyListOfStringsCopier.copy(outcomes);
        }

        @Override
        @Transient
        public final Builder outcomes(Collection<String> outcomes) {
            this.outcomes = NonEmptyListOfStringsCopier.copy(outcomes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outcomes(String... outcomes) {
            outcomes(Arrays.asList(outcomes));
            return this;
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public RuleDetail build() {
            return new RuleDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
