/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The training metric details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingMetrics implements SdkPojo, Serializable, ToCopyableBuilder<TrainingMetrics.Builder, TrainingMetrics> {
    private static final SdkField<Float> AUC_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("auc")
            .getter(getter(TrainingMetrics::auc)).setter(setter(Builder::auc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auc").build()).build();

    private static final SdkField<List<MetricDataPoint>> METRIC_DATA_POINTS_FIELD = SdkField
            .<List<MetricDataPoint>> builder(MarshallingType.LIST)
            .memberName("metricDataPoints")
            .getter(getter(TrainingMetrics::metricDataPoints))
            .setter(setter(Builder::metricDataPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDataPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDataPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDataPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUC_FIELD,
            METRIC_DATA_POINTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float auc;

    private final List<MetricDataPoint> metricDataPoints;

    private TrainingMetrics(BuilderImpl builder) {
        this.auc = builder.auc;
        this.metricDataPoints = builder.metricDataPoints;
    }

    /**
     * <p>
     * The area under the curve. This summarizes true positive rate (TPR) and false positive rate (FPR) across all
     * possible model score thresholds. A model with no predictive power has an AUC of 0.5, whereas a perfect model has
     * a score of 1.0.
     * </p>
     * 
     * @return The area under the curve. This summarizes true positive rate (TPR) and false positive rate (FPR) across
     *         all possible model score thresholds. A model with no predictive power has an AUC of 0.5, whereas a
     *         perfect model has a score of 1.0.
     */
    public final Float auc() {
        return auc;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricDataPoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricDataPoints() {
        return metricDataPoints != null && !(metricDataPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data points details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricDataPoints} method.
     * </p>
     * 
     * @return The data points details.
     */
    public final List<MetricDataPoint> metricDataPoints() {
        return metricDataPoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(auc());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricDataPoints() ? metricDataPoints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingMetrics)) {
            return false;
        }
        TrainingMetrics other = (TrainingMetrics) obj;
        return Objects.equals(auc(), other.auc()) && hasMetricDataPoints() == other.hasMetricDataPoints()
                && Objects.equals(metricDataPoints(), other.metricDataPoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainingMetrics").add("Auc", auc())
                .add("MetricDataPoints", hasMetricDataPoints() ? metricDataPoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "auc":
            return Optional.ofNullable(clazz.cast(auc()));
        case "metricDataPoints":
            return Optional.ofNullable(clazz.cast(metricDataPoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingMetrics, T> g) {
        return obj -> g.apply((TrainingMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingMetrics> {
        /**
         * <p>
         * The area under the curve. This summarizes true positive rate (TPR) and false positive rate (FPR) across all
         * possible model score thresholds. A model with no predictive power has an AUC of 0.5, whereas a perfect model
         * has a score of 1.0.
         * </p>
         * 
         * @param auc
         *        The area under the curve. This summarizes true positive rate (TPR) and false positive rate (FPR)
         *        across all possible model score thresholds. A model with no predictive power has an AUC of 0.5,
         *        whereas a perfect model has a score of 1.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auc(Float auc);

        /**
         * <p>
         * The data points details.
         * </p>
         * 
         * @param metricDataPoints
         *        The data points details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDataPoints(Collection<MetricDataPoint> metricDataPoints);

        /**
         * <p>
         * The data points details.
         * </p>
         * 
         * @param metricDataPoints
         *        The data points details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDataPoints(MetricDataPoint... metricDataPoints);

        /**
         * <p>
         * The data points details.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricDataPoint>.Builder} avoiding the need
         * to create one manually via {@link List<MetricDataPoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricDataPoint>.Builder#build()} is called immediately and
         * its result is passed to {@link #metricDataPoints(List<MetricDataPoint>)}.
         * 
         * @param metricDataPoints
         *        a consumer that will call methods on {@link List<MetricDataPoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDataPoints(List<MetricDataPoint>)
         */
        Builder metricDataPoints(Consumer<MetricDataPoint.Builder>... metricDataPoints);
    }

    static final class BuilderImpl implements Builder {
        private Float auc;

        private List<MetricDataPoint> metricDataPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingMetrics model) {
            auc(model.auc);
            metricDataPoints(model.metricDataPoints);
        }

        public final Float getAuc() {
            return auc;
        }

        public final void setAuc(Float auc) {
            this.auc = auc;
        }

        @Override
        @Transient
        public final Builder auc(Float auc) {
            this.auc = auc;
            return this;
        }

        public final List<MetricDataPoint.Builder> getMetricDataPoints() {
            List<MetricDataPoint.Builder> result = _metricDataPointsListCopier.copyToBuilder(this.metricDataPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDataPoints(Collection<MetricDataPoint.BuilderImpl> metricDataPoints) {
            this.metricDataPoints = _metricDataPointsListCopier.copyFromBuilder(metricDataPoints);
        }

        @Override
        @Transient
        public final Builder metricDataPoints(Collection<MetricDataPoint> metricDataPoints) {
            this.metricDataPoints = _metricDataPointsListCopier.copy(metricDataPoints);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metricDataPoints(MetricDataPoint... metricDataPoints) {
            metricDataPoints(Arrays.asList(metricDataPoints));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metricDataPoints(Consumer<MetricDataPoint.Builder>... metricDataPoints) {
            metricDataPoints(Stream.of(metricDataPoints).map(c -> MetricDataPoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TrainingMetrics build() {
            return new TrainingMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
