/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetVariableResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<BatchGetVariableResponse.Builder, BatchGetVariableResponse> {
    private static final SdkField<List<Variable>> VARIABLES_FIELD = SdkField
            .<List<Variable>> builder(MarshallingType.LIST)
            .memberName("variables")
            .getter(getter(BatchGetVariableResponse::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Variable> builder(MarshallingType.SDK_POJO)
                                            .constructor(Variable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetVariableError>> ERRORS_FIELD = SdkField
            .<List<BatchGetVariableError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetVariableResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetVariableError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetVariableError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(VARIABLES_FIELD, ERRORS_FIELD));

    private final List<Variable> variables;

    private final List<BatchGetVariableError> errors;

    private BatchGetVariableResponse(BuilderImpl builder) {
        super(builder);
        this.variables = builder.variables;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Variables property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The returned variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariables} method.
     * </p>
     * 
     * @return The returned variables.
     */
    public final List<Variable> variables() {
        return variables;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The errors from the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return The errors from the request.
     */
    public final List<BatchGetVariableError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVariables() ? variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetVariableResponse)) {
            return false;
        }
        BatchGetVariableResponse other = (BatchGetVariableResponse) obj;
        return hasVariables() == other.hasVariables() && Objects.equals(variables(), other.variables())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetVariableResponse").add("Variables", hasVariables() ? variables() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetVariableResponse, T> g) {
        return obj -> g.apply((BatchGetVariableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetVariableResponse> {
        /**
         * <p>
         * The returned variables.
         * </p>
         * 
         * @param variables
         *        The returned variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Collection<Variable> variables);

        /**
         * <p>
         * The returned variables.
         * </p>
         * 
         * @param variables
         *        The returned variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Variable... variables);

        /**
         * <p>
         * The returned variables.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Variable>.Builder} avoiding the need
         * to create one manually via {@link List<Variable>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Variable>.Builder#build()} is called immediately and its
         * result is passed to {@link #variables(List<Variable>)}.
         * 
         * @param variables
         *        a consumer that will call methods on {@link List<Variable>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #variables(List<Variable>)
         */
        Builder variables(Consumer<Variable.Builder>... variables);

        /**
         * <p>
         * The errors from the request.
         * </p>
         * 
         * @param errors
         *        The errors from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchGetVariableError> errors);

        /**
         * <p>
         * The errors from the request.
         * </p>
         * 
         * @param errors
         *        The errors from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchGetVariableError... errors);

        /**
         * <p>
         * The errors from the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<BatchGetVariableError>.Builder}
         * avoiding the need to create one manually via {@link List<BatchGetVariableError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchGetVariableError>.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<BatchGetVariableError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<BatchGetVariableError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<BatchGetVariableError>)
         */
        Builder errors(Consumer<BatchGetVariableError.Builder>... errors);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<Variable> variables = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetVariableError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetVariableResponse model) {
            super(model);
            variables(model.variables);
            errors(model.errors);
        }

        public final List<Variable.Builder> getVariables() {
            List<Variable.Builder> result = VariableListCopier.copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariables(Collection<Variable.BuilderImpl> variables) {
            this.variables = VariableListCopier.copyFromBuilder(variables);
        }

        @Override
        public final Builder variables(Collection<Variable> variables) {
            this.variables = VariableListCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Variable... variables) {
            variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<Variable.Builder>... variables) {
            variables(Stream.of(variables).map(c -> Variable.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetVariableError.Builder> getErrors() {
            List<BatchGetVariableError.Builder> result = BatchGetVariableErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetVariableError.BuilderImpl> errors) {
            this.errors = BatchGetVariableErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetVariableError> errors) {
            this.errors = BatchGetVariableErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetVariableError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetVariableError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchGetVariableError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetVariableResponse build() {
            return new BatchGetVariableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
