/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeModelVersionsResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<DescribeModelVersionsResponse.Builder, DescribeModelVersionsResponse> {
    private static final SdkField<List<ModelVersionDetail>> MODEL_VERSION_DETAILS_FIELD = SdkField
            .<List<ModelVersionDetail>> builder(MarshallingType.LIST)
            .memberName("modelVersionDetails")
            .getter(getter(DescribeModelVersionsResponse::modelVersionDetails))
            .setter(setter(Builder::modelVersionDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersionDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelVersionDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelVersionDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeModelVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_VERSION_DETAILS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ModelVersionDetail> modelVersionDetails;

    private final String nextToken;

    private DescribeModelVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.modelVersionDetails = builder.modelVersionDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelVersionDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModelVersionDetails() {
        return modelVersionDetails != null && !(modelVersionDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The model version details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelVersionDetails} method.
     * </p>
     * 
     * @return The model version details.
     */
    public final List<ModelVersionDetail> modelVersionDetails() {
        return modelVersionDetails;
    }

    /**
     * <p>
     * The next token.
     * </p>
     * 
     * @return The next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasModelVersionDetails() ? modelVersionDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelVersionsResponse)) {
            return false;
        }
        DescribeModelVersionsResponse other = (DescribeModelVersionsResponse) obj;
        return hasModelVersionDetails() == other.hasModelVersionDetails()
                && Objects.equals(modelVersionDetails(), other.modelVersionDetails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeModelVersionsResponse")
                .add("ModelVersionDetails", hasModelVersionDetails() ? modelVersionDetails() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelVersionDetails":
            return Optional.ofNullable(clazz.cast(modelVersionDetails()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelVersionsResponse, T> g) {
        return obj -> g.apply((DescribeModelVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeModelVersionsResponse> {
        /**
         * <p>
         * The model version details.
         * </p>
         * 
         * @param modelVersionDetails
         *        The model version details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersionDetails(Collection<ModelVersionDetail> modelVersionDetails);

        /**
         * <p>
         * The model version details.
         * </p>
         * 
         * @param modelVersionDetails
         *        The model version details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersionDetails(ModelVersionDetail... modelVersionDetails);

        /**
         * <p>
         * The model version details.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ModelVersionDetail>.Builder}
         * avoiding the need to create one manually via {@link List<ModelVersionDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModelVersionDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #modelVersionDetails(List<ModelVersionDetail>)}.
         * 
         * @param modelVersionDetails
         *        a consumer that will call methods on {@link List<ModelVersionDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelVersionDetails(List<ModelVersionDetail>)
         */
        Builder modelVersionDetails(Consumer<ModelVersionDetail.Builder>... modelVersionDetails);

        /**
         * <p>
         * The next token.
         * </p>
         * 
         * @param nextToken
         *        The next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<ModelVersionDetail> modelVersionDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelVersionsResponse model) {
            super(model);
            modelVersionDetails(model.modelVersionDetails);
            nextToken(model.nextToken);
        }

        public final List<ModelVersionDetail.Builder> getModelVersionDetails() {
            List<ModelVersionDetail.Builder> result = _modelVersionDetailListCopier.copyToBuilder(this.modelVersionDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelVersionDetails(Collection<ModelVersionDetail.BuilderImpl> modelVersionDetails) {
            this.modelVersionDetails = _modelVersionDetailListCopier.copyFromBuilder(modelVersionDetails);
        }

        @Override
        public final Builder modelVersionDetails(Collection<ModelVersionDetail> modelVersionDetails) {
            this.modelVersionDetails = _modelVersionDetailListCopier.copy(modelVersionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersionDetails(ModelVersionDetail... modelVersionDetails) {
            modelVersionDetails(Arrays.asList(modelVersionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersionDetails(Consumer<ModelVersionDetail.Builder>... modelVersionDetails) {
            modelVersionDetails(Stream.of(modelVersionDetails).map(c -> ModelVersionDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeModelVersionsResponse build() {
            return new DescribeModelVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
