/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon SageMaker model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalModel implements SdkPojo, Serializable, ToCopyableBuilder<ExternalModel.Builder, ExternalModel> {
    private static final SdkField<String> MODEL_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelEndpoint").getter(getter(ExternalModel::modelEndpoint)).setter(setter(Builder::modelEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpoint").build()).build();

    private static final SdkField<String> MODEL_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelSource").getter(getter(ExternalModel::modelSourceAsString)).setter(setter(Builder::modelSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSource").build()).build();

    private static final SdkField<String> INVOKE_MODEL_ENDPOINT_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("invokeModelEndpointRoleArn")
            .getter(getter(ExternalModel::invokeModelEndpointRoleArn))
            .setter(setter(Builder::invokeModelEndpointRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invokeModelEndpointRoleArn").build())
            .build();

    private static final SdkField<ModelInputConfiguration> INPUT_CONFIGURATION_FIELD = SdkField
            .<ModelInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("inputConfiguration")
            .getter(getter(ExternalModel::inputConfiguration)).setter(setter(Builder::inputConfiguration))
            .constructor(ModelInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfiguration").build())
            .build();

    private static final SdkField<ModelOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField
            .<ModelOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("outputConfiguration")
            .getter(getter(ExternalModel::outputConfiguration)).setter(setter(Builder::outputConfiguration))
            .constructor(ModelOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build())
            .build();

    private static final SdkField<String> MODEL_ENDPOINT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelEndpointStatus").getter(getter(ExternalModel::modelEndpointStatusAsString))
            .setter(setter(Builder::modelEndpointStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpointStatus").build())
            .build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedTime").getter(getter(ExternalModel::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdTime").getter(getter(ExternalModel::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ExternalModel::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ENDPOINT_FIELD,
            MODEL_SOURCE_FIELD, INVOKE_MODEL_ENDPOINT_ROLE_ARN_FIELD, INPUT_CONFIGURATION_FIELD, OUTPUT_CONFIGURATION_FIELD,
            MODEL_ENDPOINT_STATUS_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelEndpoint;

    private final String modelSource;

    private final String invokeModelEndpointRoleArn;

    private final ModelInputConfiguration inputConfiguration;

    private final ModelOutputConfiguration outputConfiguration;

    private final String modelEndpointStatus;

    private final String lastUpdatedTime;

    private final String createdTime;

    private final String arn;

    private ExternalModel(BuilderImpl builder) {
        this.modelEndpoint = builder.modelEndpoint;
        this.modelSource = builder.modelSource;
        this.invokeModelEndpointRoleArn = builder.invokeModelEndpointRoleArn;
        this.inputConfiguration = builder.inputConfiguration;
        this.outputConfiguration = builder.outputConfiguration;
        this.modelEndpointStatus = builder.modelEndpointStatus;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The Amazon SageMaker model endpoints.
     * </p>
     * 
     * @return The Amazon SageMaker model endpoints.
     */
    public final String modelEndpoint() {
        return modelEndpoint;
    }

    /**
     * <p>
     * The source of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelSource} will
     * return {@link ModelSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelSourceAsString}.
     * </p>
     * 
     * @return The source of the model.
     * @see ModelSource
     */
    public final ModelSource modelSource() {
        return ModelSource.fromValue(modelSource);
    }

    /**
     * <p>
     * The source of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelSource} will
     * return {@link ModelSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelSourceAsString}.
     * </p>
     * 
     * @return The source of the model.
     * @see ModelSource
     */
    public final String modelSourceAsString() {
        return modelSource;
    }

    /**
     * <p>
     * The role used to invoke the model.
     * </p>
     * 
     * @return The role used to invoke the model.
     */
    public final String invokeModelEndpointRoleArn() {
        return invokeModelEndpointRoleArn;
    }

    /**
     * <p>
     * The input configuration.
     * </p>
     * 
     * @return The input configuration.
     */
    public final ModelInputConfiguration inputConfiguration() {
        return inputConfiguration;
    }

    /**
     * <p>
     * The output configuration.
     * </p>
     * 
     * @return The output configuration.
     */
    public final ModelOutputConfiguration outputConfiguration() {
        return outputConfiguration;
    }

    /**
     * <p>
     * The Amazon Fraud Detector status for the external model endpoint
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelEndpointStatus} will return {@link ModelEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #modelEndpointStatusAsString}.
     * </p>
     * 
     * @return The Amazon Fraud Detector status for the external model endpoint
     * @see ModelEndpointStatus
     */
    public final ModelEndpointStatus modelEndpointStatus() {
        return ModelEndpointStatus.fromValue(modelEndpointStatus);
    }

    /**
     * <p>
     * The Amazon Fraud Detector status for the external model endpoint
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelEndpointStatus} will return {@link ModelEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #modelEndpointStatusAsString}.
     * </p>
     * 
     * @return The Amazon Fraud Detector status for the external model endpoint
     * @see ModelEndpointStatus
     */
    public final String modelEndpointStatusAsString() {
        return modelEndpointStatus;
    }

    /**
     * <p>
     * Timestamp of when the model was last updated.
     * </p>
     * 
     * @return Timestamp of when the model was last updated.
     */
    public final String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Timestamp of when the model was last created.
     * </p>
     * 
     * @return Timestamp of when the model was last created.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The model ARN.
     * </p>
     * 
     * @return The model ARN.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(modelSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(invokeModelEndpointRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(modelEndpointStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalModel)) {
            return false;
        }
        ExternalModel other = (ExternalModel) obj;
        return Objects.equals(modelEndpoint(), other.modelEndpoint())
                && Objects.equals(modelSourceAsString(), other.modelSourceAsString())
                && Objects.equals(invokeModelEndpointRoleArn(), other.invokeModelEndpointRoleArn())
                && Objects.equals(inputConfiguration(), other.inputConfiguration())
                && Objects.equals(outputConfiguration(), other.outputConfiguration())
                && Objects.equals(modelEndpointStatusAsString(), other.modelEndpointStatusAsString())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalModel").add("ModelEndpoint", modelEndpoint()).add("ModelSource", modelSourceAsString())
                .add("InvokeModelEndpointRoleArn", invokeModelEndpointRoleArn()).add("InputConfiguration", inputConfiguration())
                .add("OutputConfiguration", outputConfiguration()).add("ModelEndpointStatus", modelEndpointStatusAsString())
                .add("LastUpdatedTime", lastUpdatedTime()).add("CreatedTime", createdTime()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelEndpoint":
            return Optional.ofNullable(clazz.cast(modelEndpoint()));
        case "modelSource":
            return Optional.ofNullable(clazz.cast(modelSourceAsString()));
        case "invokeModelEndpointRoleArn":
            return Optional.ofNullable(clazz.cast(invokeModelEndpointRoleArn()));
        case "inputConfiguration":
            return Optional.ofNullable(clazz.cast(inputConfiguration()));
        case "outputConfiguration":
            return Optional.ofNullable(clazz.cast(outputConfiguration()));
        case "modelEndpointStatus":
            return Optional.ofNullable(clazz.cast(modelEndpointStatusAsString()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalModel, T> g) {
        return obj -> g.apply((ExternalModel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalModel> {
        /**
         * <p>
         * The Amazon SageMaker model endpoints.
         * </p>
         * 
         * @param modelEndpoint
         *        The Amazon SageMaker model endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelEndpoint(String modelEndpoint);

        /**
         * <p>
         * The source of the model.
         * </p>
         * 
         * @param modelSource
         *        The source of the model.
         * @see ModelSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelSource
         */
        Builder modelSource(String modelSource);

        /**
         * <p>
         * The source of the model.
         * </p>
         * 
         * @param modelSource
         *        The source of the model.
         * @see ModelSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelSource
         */
        Builder modelSource(ModelSource modelSource);

        /**
         * <p>
         * The role used to invoke the model.
         * </p>
         * 
         * @param invokeModelEndpointRoleArn
         *        The role used to invoke the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invokeModelEndpointRoleArn(String invokeModelEndpointRoleArn);

        /**
         * <p>
         * The input configuration.
         * </p>
         * 
         * @param inputConfiguration
         *        The input configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfiguration(ModelInputConfiguration inputConfiguration);

        /**
         * <p>
         * The input configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelInputConfiguration.Builder} avoiding
         * the need to create one manually via {@link ModelInputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelInputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #inputConfiguration(ModelInputConfiguration)}.
         * 
         * @param inputConfiguration
         *        a consumer that will call methods on {@link ModelInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfiguration(ModelInputConfiguration)
         */
        default Builder inputConfiguration(Consumer<ModelInputConfiguration.Builder> inputConfiguration) {
            return inputConfiguration(ModelInputConfiguration.builder().applyMutation(inputConfiguration).build());
        }

        /**
         * <p>
         * The output configuration.
         * </p>
         * 
         * @param outputConfiguration
         *        The output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfiguration(ModelOutputConfiguration outputConfiguration);

        /**
         * <p>
         * The output configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link ModelOutputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelOutputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #outputConfiguration(ModelOutputConfiguration)}.
         * 
         * @param outputConfiguration
         *        a consumer that will call methods on {@link ModelOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfiguration(ModelOutputConfiguration)
         */
        default Builder outputConfiguration(Consumer<ModelOutputConfiguration.Builder> outputConfiguration) {
            return outputConfiguration(ModelOutputConfiguration.builder().applyMutation(outputConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Fraud Detector status for the external model endpoint
         * </p>
         * 
         * @param modelEndpointStatus
         *        The Amazon Fraud Detector status for the external model endpoint
         * @see ModelEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelEndpointStatus
         */
        Builder modelEndpointStatus(String modelEndpointStatus);

        /**
         * <p>
         * The Amazon Fraud Detector status for the external model endpoint
         * </p>
         * 
         * @param modelEndpointStatus
         *        The Amazon Fraud Detector status for the external model endpoint
         * @see ModelEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelEndpointStatus
         */
        Builder modelEndpointStatus(ModelEndpointStatus modelEndpointStatus);

        /**
         * <p>
         * Timestamp of when the model was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        Timestamp of when the model was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);

        /**
         * <p>
         * Timestamp of when the model was last created.
         * </p>
         * 
         * @param createdTime
         *        Timestamp of when the model was last created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * The model ARN.
         * </p>
         * 
         * @param arn
         *        The model ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String modelEndpoint;

        private String modelSource;

        private String invokeModelEndpointRoleArn;

        private ModelInputConfiguration inputConfiguration;

        private ModelOutputConfiguration outputConfiguration;

        private String modelEndpointStatus;

        private String lastUpdatedTime;

        private String createdTime;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalModel model) {
            modelEndpoint(model.modelEndpoint);
            modelSource(model.modelSource);
            invokeModelEndpointRoleArn(model.invokeModelEndpointRoleArn);
            inputConfiguration(model.inputConfiguration);
            outputConfiguration(model.outputConfiguration);
            modelEndpointStatus(model.modelEndpointStatus);
            lastUpdatedTime(model.lastUpdatedTime);
            createdTime(model.createdTime);
            arn(model.arn);
        }

        public final String getModelEndpoint() {
            return modelEndpoint;
        }

        public final void setModelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
        }

        @Override
        public final Builder modelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
            return this;
        }

        public final String getModelSource() {
            return modelSource;
        }

        public final void setModelSource(String modelSource) {
            this.modelSource = modelSource;
        }

        @Override
        public final Builder modelSource(String modelSource) {
            this.modelSource = modelSource;
            return this;
        }

        @Override
        public final Builder modelSource(ModelSource modelSource) {
            this.modelSource(modelSource == null ? null : modelSource.toString());
            return this;
        }

        public final String getInvokeModelEndpointRoleArn() {
            return invokeModelEndpointRoleArn;
        }

        public final void setInvokeModelEndpointRoleArn(String invokeModelEndpointRoleArn) {
            this.invokeModelEndpointRoleArn = invokeModelEndpointRoleArn;
        }

        @Override
        public final Builder invokeModelEndpointRoleArn(String invokeModelEndpointRoleArn) {
            this.invokeModelEndpointRoleArn = invokeModelEndpointRoleArn;
            return this;
        }

        public final ModelInputConfiguration.Builder getInputConfiguration() {
            return inputConfiguration != null ? inputConfiguration.toBuilder() : null;
        }

        public final void setInputConfiguration(ModelInputConfiguration.BuilderImpl inputConfiguration) {
            this.inputConfiguration = inputConfiguration != null ? inputConfiguration.build() : null;
        }

        @Override
        public final Builder inputConfiguration(ModelInputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            return this;
        }

        public final ModelOutputConfiguration.Builder getOutputConfiguration() {
            return outputConfiguration != null ? outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(ModelOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(ModelOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final String getModelEndpointStatus() {
            return modelEndpointStatus;
        }

        public final void setModelEndpointStatus(String modelEndpointStatus) {
            this.modelEndpointStatus = modelEndpointStatus;
        }

        @Override
        public final Builder modelEndpointStatus(String modelEndpointStatus) {
            this.modelEndpointStatus = modelEndpointStatus;
            return this;
        }

        @Override
        public final Builder modelEndpointStatus(ModelEndpointStatus modelEndpointStatus) {
            this.modelEndpointStatus(modelEndpointStatus == null ? null : modelEndpointStatus.toString());
            return this;
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public ExternalModel build() {
            return new ExternalModel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
