/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExternalModelsResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetExternalModelsResponse.Builder, GetExternalModelsResponse> {
    private static final SdkField<List<ExternalModel>> EXTERNAL_MODELS_FIELD = SdkField
            .<List<ExternalModel>> builder(MarshallingType.LIST)
            .memberName("externalModels")
            .getter(getter(GetExternalModelsResponse::externalModels))
            .setter(setter(Builder::externalModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExternalModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExternalModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetExternalModelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_MODELS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ExternalModel> externalModels;

    private final String nextToken;

    private GetExternalModelsResponse(BuilderImpl builder) {
        super(builder);
        this.externalModels = builder.externalModels;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExternalModels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExternalModels() {
        return externalModels != null && !(externalModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Gets the Amazon SageMaker models.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExternalModels} method.
     * </p>
     * 
     * @return Gets the Amazon SageMaker models.
     */
    public final List<ExternalModel> externalModels() {
        return externalModels;
    }

    /**
     * <p>
     * The next page token to be used in subsequent requests.
     * </p>
     * 
     * @return The next page token to be used in subsequent requests.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExternalModels() ? externalModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExternalModelsResponse)) {
            return false;
        }
        GetExternalModelsResponse other = (GetExternalModelsResponse) obj;
        return hasExternalModels() == other.hasExternalModels() && Objects.equals(externalModels(), other.externalModels())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExternalModelsResponse").add("ExternalModels", hasExternalModels() ? externalModels() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "externalModels":
            return Optional.ofNullable(clazz.cast(externalModels()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExternalModelsResponse, T> g) {
        return obj -> g.apply((GetExternalModelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetExternalModelsResponse> {
        /**
         * <p>
         * Gets the Amazon SageMaker models.
         * </p>
         * 
         * @param externalModels
         *        Gets the Amazon SageMaker models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalModels(Collection<ExternalModel> externalModels);

        /**
         * <p>
         * Gets the Amazon SageMaker models.
         * </p>
         * 
         * @param externalModels
         *        Gets the Amazon SageMaker models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalModels(ExternalModel... externalModels);

        /**
         * <p>
         * Gets the Amazon SageMaker models.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ExternalModel>.Builder} avoiding the
         * need to create one manually via {@link List<ExternalModel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExternalModel>.Builder#build()} is called immediately and
         * its result is passed to {@link #externalModels(List<ExternalModel>)}.
         * 
         * @param externalModels
         *        a consumer that will call methods on {@link List<ExternalModel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalModels(List<ExternalModel>)
         */
        Builder externalModels(Consumer<ExternalModel.Builder>... externalModels);

        /**
         * <p>
         * The next page token to be used in subsequent requests.
         * </p>
         * 
         * @param nextToken
         *        The next page token to be used in subsequent requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<ExternalModel> externalModels = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExternalModelsResponse model) {
            super(model);
            externalModels(model.externalModels);
            nextToken(model.nextToken);
        }

        public final List<ExternalModel.Builder> getExternalModels() {
            List<ExternalModel.Builder> result = ExternalModelListCopier.copyToBuilder(this.externalModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExternalModels(Collection<ExternalModel.BuilderImpl> externalModels) {
            this.externalModels = ExternalModelListCopier.copyFromBuilder(externalModels);
        }

        @Override
        public final Builder externalModels(Collection<ExternalModel> externalModels) {
            this.externalModels = ExternalModelListCopier.copy(externalModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalModels(ExternalModel... externalModels) {
            externalModels(Arrays.asList(externalModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalModels(Consumer<ExternalModel.Builder>... externalModels) {
            externalModels(Stream.of(externalModels).map(c -> ExternalModel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetExternalModelsResponse build() {
            return new GetExternalModelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
