/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventPredictionsRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<ListEventPredictionsRequest.Builder, ListEventPredictionsRequest> {
    private static final SdkField<FilterCondition> EVENT_ID_FIELD = SdkField.<FilterCondition> builder(MarshallingType.SDK_POJO)
            .memberName("eventId").getter(getter(ListEventPredictionsRequest::eventId)).setter(setter(Builder::eventId))
            .constructor(FilterCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<FilterCondition> EVENT_TYPE_FIELD = SdkField
            .<FilterCondition> builder(MarshallingType.SDK_POJO).memberName("eventType")
            .getter(getter(ListEventPredictionsRequest::eventType)).setter(setter(Builder::eventType))
            .constructor(FilterCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<FilterCondition> DETECTOR_ID_FIELD = SdkField
            .<FilterCondition> builder(MarshallingType.SDK_POJO).memberName("detectorId")
            .getter(getter(ListEventPredictionsRequest::detectorId)).setter(setter(Builder::detectorId))
            .constructor(FilterCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<FilterCondition> DETECTOR_VERSION_ID_FIELD = SdkField
            .<FilterCondition> builder(MarshallingType.SDK_POJO).memberName("detectorVersionId")
            .getter(getter(ListEventPredictionsRequest::detectorVersionId)).setter(setter(Builder::detectorVersionId))
            .constructor(FilterCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()).build();

    private static final SdkField<PredictionTimeRange> PREDICTION_TIME_RANGE_FIELD = SdkField
            .<PredictionTimeRange> builder(MarshallingType.SDK_POJO).memberName("predictionTimeRange")
            .getter(getter(ListEventPredictionsRequest::predictionTimeRange)).setter(setter(Builder::predictionTimeRange))
            .constructor(PredictionTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionTimeRange").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEventPredictionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListEventPredictionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            EVENT_TYPE_FIELD, DETECTOR_ID_FIELD, DETECTOR_VERSION_ID_FIELD, PREDICTION_TIME_RANGE_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private final FilterCondition eventId;

    private final FilterCondition eventType;

    private final FilterCondition detectorId;

    private final FilterCondition detectorVersionId;

    private final PredictionTimeRange predictionTimeRange;

    private final String nextToken;

    private final Integer maxResults;

    private ListEventPredictionsRequest(BuilderImpl builder) {
        super(builder);
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.predictionTimeRange = builder.predictionTimeRange;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The event ID.
     * </p>
     * 
     * @return The event ID.
     */
    public final FilterCondition eventId() {
        return eventId;
    }

    /**
     * <p>
     * The event type associated with the detector.
     * </p>
     * 
     * @return The event type associated with the detector.
     */
    public final FilterCondition eventType() {
        return eventType;
    }

    /**
     * <p>
     * The detector ID.
     * </p>
     * 
     * @return The detector ID.
     */
    public final FilterCondition detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The detector version ID.
     * </p>
     * 
     * @return The detector version ID.
     */
    public final FilterCondition detectorVersionId() {
        return detectorVersionId;
    }

    /**
     * <p>
     * The time period for when the predictions were generated.
     * </p>
     * 
     * @return The time period for when the predictions were generated.
     */
    public final PredictionTimeRange predictionTimeRange() {
        return predictionTimeRange;
    }

    /**
     * <p>
     * Identifies the next page of results to return. Use the token to make the call again to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours.
     * </p>
     * 
     * @return Identifies the next page of results to return. Use the token to make the call again to retrieve the next
     *         page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of predictions to return for the request.
     * </p>
     * 
     * @return The maximum number of predictions to return for the request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(predictionTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventPredictionsRequest)) {
            return false;
        }
        ListEventPredictionsRequest other = (ListEventPredictionsRequest) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(eventType(), other.eventType())
                && Objects.equals(detectorId(), other.detectorId())
                && Objects.equals(detectorVersionId(), other.detectorVersionId())
                && Objects.equals(predictionTimeRange(), other.predictionTimeRange())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEventPredictionsRequest").add("EventId", eventId()).add("EventType", eventType())
                .add("DetectorId", detectorId()).add("DetectorVersionId", detectorVersionId())
                .add("PredictionTimeRange", predictionTimeRange()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "detectorVersionId":
            return Optional.ofNullable(clazz.cast(detectorVersionId()));
        case "predictionTimeRange":
            return Optional.ofNullable(clazz.cast(predictionTimeRange()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventPredictionsRequest, T> g) {
        return obj -> g.apply((ListEventPredictionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListEventPredictionsRequest> {
        /**
         * <p>
         * The event ID.
         * </p>
         * 
         * @param eventId
         *        The event ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(FilterCondition eventId);

        /**
         * <p>
         * The event ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterCondition.Builder} avoiding the
         * need to create one manually via {@link FilterCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link FilterCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #eventId(FilterCondition)}.
         * 
         * @param eventId
         *        a consumer that will call methods on {@link FilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventId(FilterCondition)
         */
        default Builder eventId(Consumer<FilterCondition.Builder> eventId) {
            return eventId(FilterCondition.builder().applyMutation(eventId).build());
        }

        /**
         * <p>
         * The event type associated with the detector.
         * </p>
         * 
         * @param eventType
         *        The event type associated with the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(FilterCondition eventType);

        /**
         * <p>
         * The event type associated with the detector.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterCondition.Builder} avoiding the
         * need to create one manually via {@link FilterCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link FilterCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #eventType(FilterCondition)}.
         * 
         * @param eventType
         *        a consumer that will call methods on {@link FilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventType(FilterCondition)
         */
        default Builder eventType(Consumer<FilterCondition.Builder> eventType) {
            return eventType(FilterCondition.builder().applyMutation(eventType).build());
        }

        /**
         * <p>
         * The detector ID.
         * </p>
         * 
         * @param detectorId
         *        The detector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(FilterCondition detectorId);

        /**
         * <p>
         * The detector ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterCondition.Builder} avoiding the
         * need to create one manually via {@link FilterCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link FilterCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #detectorId(FilterCondition)}.
         * 
         * @param detectorId
         *        a consumer that will call methods on {@link FilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectorId(FilterCondition)
         */
        default Builder detectorId(Consumer<FilterCondition.Builder> detectorId) {
            return detectorId(FilterCondition.builder().applyMutation(detectorId).build());
        }

        /**
         * <p>
         * The detector version ID.
         * </p>
         * 
         * @param detectorVersionId
         *        The detector version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorVersionId(FilterCondition detectorVersionId);

        /**
         * <p>
         * The detector version ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterCondition.Builder} avoiding the
         * need to create one manually via {@link FilterCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link FilterCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #detectorVersionId(FilterCondition)}.
         * 
         * @param detectorVersionId
         *        a consumer that will call methods on {@link FilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectorVersionId(FilterCondition)
         */
        default Builder detectorVersionId(Consumer<FilterCondition.Builder> detectorVersionId) {
            return detectorVersionId(FilterCondition.builder().applyMutation(detectorVersionId).build());
        }

        /**
         * <p>
         * The time period for when the predictions were generated.
         * </p>
         * 
         * @param predictionTimeRange
         *        The time period for when the predictions were generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionTimeRange(PredictionTimeRange predictionTimeRange);

        /**
         * <p>
         * The time period for when the predictions were generated.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredictionTimeRange.Builder} avoiding the
         * need to create one manually via {@link PredictionTimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link PredictionTimeRange.Builder#build()} is called immediately and
         * its result is passed to {@link #predictionTimeRange(PredictionTimeRange)}.
         * 
         * @param predictionTimeRange
         *        a consumer that will call methods on {@link PredictionTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictionTimeRange(PredictionTimeRange)
         */
        default Builder predictionTimeRange(Consumer<PredictionTimeRange.Builder> predictionTimeRange) {
            return predictionTimeRange(PredictionTimeRange.builder().applyMutation(predictionTimeRange).build());
        }

        /**
         * <p>
         * Identifies the next page of results to return. Use the token to make the call again to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        Identifies the next page of results to return. Use the token to make the call again to retrieve the
         *        next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of predictions to return for the request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of predictions to return for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private FilterCondition eventId;

        private FilterCondition eventType;

        private FilterCondition detectorId;

        private FilterCondition detectorVersionId;

        private PredictionTimeRange predictionTimeRange;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventPredictionsRequest model) {
            super(model);
            eventId(model.eventId);
            eventType(model.eventType);
            detectorId(model.detectorId);
            detectorVersionId(model.detectorVersionId);
            predictionTimeRange(model.predictionTimeRange);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final FilterCondition.Builder getEventId() {
            return eventId != null ? eventId.toBuilder() : null;
        }

        public final void setEventId(FilterCondition.BuilderImpl eventId) {
            this.eventId = eventId != null ? eventId.build() : null;
        }

        @Override
        public final Builder eventId(FilterCondition eventId) {
            this.eventId = eventId;
            return this;
        }

        public final FilterCondition.Builder getEventType() {
            return eventType != null ? eventType.toBuilder() : null;
        }

        public final void setEventType(FilterCondition.BuilderImpl eventType) {
            this.eventType = eventType != null ? eventType.build() : null;
        }

        @Override
        public final Builder eventType(FilterCondition eventType) {
            this.eventType = eventType;
            return this;
        }

        public final FilterCondition.Builder getDetectorId() {
            return detectorId != null ? detectorId.toBuilder() : null;
        }

        public final void setDetectorId(FilterCondition.BuilderImpl detectorId) {
            this.detectorId = detectorId != null ? detectorId.build() : null;
        }

        @Override
        public final Builder detectorId(FilterCondition detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final FilterCondition.Builder getDetectorVersionId() {
            return detectorVersionId != null ? detectorVersionId.toBuilder() : null;
        }

        public final void setDetectorVersionId(FilterCondition.BuilderImpl detectorVersionId) {
            this.detectorVersionId = detectorVersionId != null ? detectorVersionId.build() : null;
        }

        @Override
        public final Builder detectorVersionId(FilterCondition detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final PredictionTimeRange.Builder getPredictionTimeRange() {
            return predictionTimeRange != null ? predictionTimeRange.toBuilder() : null;
        }

        public final void setPredictionTimeRange(PredictionTimeRange.BuilderImpl predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange != null ? predictionTimeRange.build() : null;
        }

        @Override
        public final Builder predictionTimeRange(PredictionTimeRange predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEventPredictionsRequest build() {
            return new ListEventPredictionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
