/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The fraud prediction scores.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelScores implements SdkPojo, Serializable, ToCopyableBuilder<ModelScores.Builder, ModelScores> {
    private static final SdkField<ModelVersion> MODEL_VERSION_FIELD = SdkField.<ModelVersion> builder(MarshallingType.SDK_POJO)
            .memberName("modelVersion").getter(getter(ModelScores::modelVersion)).setter(setter(Builder::modelVersion))
            .constructor(ModelVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersion").build()).build();

    private static final SdkField<Map<String, Float>> SCORES_FIELD = SdkField
            .<Map<String, Float>> builder(MarshallingType.MAP)
            .memberName("scores")
            .getter(getter(ModelScores::scores))
            .setter(setter(Builder::scores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scores").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Float> builder(MarshallingType.FLOAT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_VERSION_FIELD,
            SCORES_FIELD));

    private static final long serialVersionUID = 1L;

    private final ModelVersion modelVersion;

    private final Map<String, Float> scores;

    private ModelScores(BuilderImpl builder) {
        this.modelVersion = builder.modelVersion;
        this.scores = builder.scores;
    }

    /**
     * <p>
     * The model version.
     * </p>
     * 
     * @return The model version.
     */
    public final ModelVersion modelVersion() {
        return modelVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scores property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScores() {
        return scores != null && !(scores instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The model's fraud prediction scores.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScores} method.
     * </p>
     * 
     * @return The model's fraud prediction scores.
     */
    public final Map<String, Float> scores() {
        return scores;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasScores() ? scores() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelScores)) {
            return false;
        }
        ModelScores other = (ModelScores) obj;
        return Objects.equals(modelVersion(), other.modelVersion()) && hasScores() == other.hasScores()
                && Objects.equals(scores(), other.scores());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelScores").add("ModelVersion", modelVersion()).add("Scores", hasScores() ? scores() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "scores":
            return Optional.ofNullable(clazz.cast(scores()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelScores, T> g) {
        return obj -> g.apply((ModelScores) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelScores> {
        /**
         * <p>
         * The model version.
         * </p>
         * 
         * @param modelVersion
         *        The model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(ModelVersion modelVersion);

        /**
         * <p>
         * The model version.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelVersion.Builder} avoiding the need
         * to create one manually via {@link ModelVersion#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelVersion.Builder#build()} is called immediately and its
         * result is passed to {@link #modelVersion(ModelVersion)}.
         * 
         * @param modelVersion
         *        a consumer that will call methods on {@link ModelVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelVersion(ModelVersion)
         */
        default Builder modelVersion(Consumer<ModelVersion.Builder> modelVersion) {
            return modelVersion(ModelVersion.builder().applyMutation(modelVersion).build());
        }

        /**
         * <p>
         * The model's fraud prediction scores.
         * </p>
         * 
         * @param scores
         *        The model's fraud prediction scores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scores(Map<String, Float> scores);
    }

    static final class BuilderImpl implements Builder {
        private ModelVersion modelVersion;

        private Map<String, Float> scores = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelScores model) {
            modelVersion(model.modelVersion);
            scores(model.scores);
        }

        public final ModelVersion.Builder getModelVersion() {
            return modelVersion != null ? modelVersion.toBuilder() : null;
        }

        public final void setModelVersion(ModelVersion.BuilderImpl modelVersion) {
            this.modelVersion = modelVersion != null ? modelVersion.build() : null;
        }

        @Override
        public final Builder modelVersion(ModelVersion modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final Map<String, Float> getScores() {
            if (scores instanceof SdkAutoConstructMap) {
                return null;
            }
            return scores;
        }

        public final void setScores(Map<String, Float> scores) {
            this.scores = ModelPredictionMapCopier.copy(scores);
        }

        @Override
        public final Builder scores(Map<String, Float> scores) {
            this.scores = ModelPredictionMapCopier.copy(scores);
            return this;
        }

        @Override
        public ModelScores build() {
            return new ModelScores(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
