/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.frauddetector.model.CsvIndexToVariableMapCopier;
import software.amazon.awssdk.services.frauddetector.model.JsonKeyToVariableMapCopier;
import software.amazon.awssdk.services.frauddetector.model.ModelOutputDataFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelOutputConfiguration> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(ModelOutputConfiguration.getter(ModelOutputConfiguration::formatAsString)).setter(ModelOutputConfiguration.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<Map<String, String>> JSON_KEY_TO_VARIABLE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("jsonKeyToVariableMap").getter(ModelOutputConfiguration.getter(ModelOutputConfiguration::jsonKeyToVariableMap)).setter(ModelOutputConfiguration.setter(Builder::jsonKeyToVariableMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonKeyToVariableMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CSV_INDEX_TO_VARIABLE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("csvIndexToVariableMap").getter(ModelOutputConfiguration.getter(ModelOutputConfiguration::csvIndexToVariableMap)).setter(ModelOutputConfiguration.setter(Builder::csvIndexToVariableMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("csvIndexToVariableMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, JSON_KEY_TO_VARIABLE_MAP_FIELD, CSV_INDEX_TO_VARIABLE_MAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String format;
    private final Map<String, String> jsonKeyToVariableMap;
    private final Map<String, String> csvIndexToVariableMap;

    private ModelOutputConfiguration(BuilderImpl builder) {
        this.format = builder.format;
        this.jsonKeyToVariableMap = builder.jsonKeyToVariableMap;
        this.csvIndexToVariableMap = builder.csvIndexToVariableMap;
    }

    public final ModelOutputDataFormat format() {
        return ModelOutputDataFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final boolean hasJsonKeyToVariableMap() {
        return this.jsonKeyToVariableMap != null && !(this.jsonKeyToVariableMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> jsonKeyToVariableMap() {
        return this.jsonKeyToVariableMap;
    }

    public final boolean hasCsvIndexToVariableMap() {
        return this.csvIndexToVariableMap != null && !(this.csvIndexToVariableMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> csvIndexToVariableMap() {
        return this.csvIndexToVariableMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJsonKeyToVariableMap() ? this.jsonKeyToVariableMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCsvIndexToVariableMap() ? this.csvIndexToVariableMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelOutputConfiguration)) {
            return false;
        }
        ModelOutputConfiguration other = (ModelOutputConfiguration)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && this.hasJsonKeyToVariableMap() == other.hasJsonKeyToVariableMap() && Objects.equals(this.jsonKeyToVariableMap(), other.jsonKeyToVariableMap()) && this.hasCsvIndexToVariableMap() == other.hasCsvIndexToVariableMap() && Objects.equals(this.csvIndexToVariableMap(), other.csvIndexToVariableMap());
    }

    public final String toString() {
        return ToString.builder((String)"ModelOutputConfiguration").add("Format", (Object)this.formatAsString()).add("JsonKeyToVariableMap", this.hasJsonKeyToVariableMap() ? this.jsonKeyToVariableMap() : null).add("CsvIndexToVariableMap", this.hasCsvIndexToVariableMap() ? this.csvIndexToVariableMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "jsonKeyToVariableMap": {
                return Optional.ofNullable(clazz.cast(this.jsonKeyToVariableMap()));
            }
            case "csvIndexToVariableMap": {
                return Optional.ofNullable(clazz.cast(this.csvIndexToVariableMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelOutputConfiguration, T> g) {
        return obj -> g.apply((ModelOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private Map<String, String> jsonKeyToVariableMap = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> csvIndexToVariableMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelOutputConfiguration model) {
            this.format(model.format);
            this.jsonKeyToVariableMap(model.jsonKeyToVariableMap);
            this.csvIndexToVariableMap(model.csvIndexToVariableMap);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        @Transient
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        @Transient
        public final Builder format(ModelOutputDataFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Map<String, String> getJsonKeyToVariableMap() {
            if (this.jsonKeyToVariableMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.jsonKeyToVariableMap;
        }

        public final void setJsonKeyToVariableMap(Map<String, String> jsonKeyToVariableMap) {
            this.jsonKeyToVariableMap = JsonKeyToVariableMapCopier.copy(jsonKeyToVariableMap);
        }

        @Override
        @Transient
        public final Builder jsonKeyToVariableMap(Map<String, String> jsonKeyToVariableMap) {
            this.jsonKeyToVariableMap = JsonKeyToVariableMapCopier.copy(jsonKeyToVariableMap);
            return this;
        }

        public final Map<String, String> getCsvIndexToVariableMap() {
            if (this.csvIndexToVariableMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.csvIndexToVariableMap;
        }

        public final void setCsvIndexToVariableMap(Map<String, String> csvIndexToVariableMap) {
            this.csvIndexToVariableMap = CsvIndexToVariableMapCopier.copy(csvIndexToVariableMap);
        }

        @Override
        @Transient
        public final Builder csvIndexToVariableMap(Map<String, String> csvIndexToVariableMap) {
            this.csvIndexToVariableMap = CsvIndexToVariableMapCopier.copy(csvIndexToVariableMap);
            return this;
        }

        public ModelOutputConfiguration build() {
            return new ModelOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelOutputConfiguration> {
        public Builder format(String var1);

        public Builder format(ModelOutputDataFormat var1);

        public Builder jsonKeyToVariableMap(Map<String, String> var1);

        public Builder csvIndexToVariableMap(Map<String, String> var1);
    }
}

