/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Transaction Fraud Insights (TFI) model performance score.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TFIModelPerformance implements SdkPojo, Serializable,
        ToCopyableBuilder<TFIModelPerformance.Builder, TFIModelPerformance> {
    private static final SdkField<Float> AUC_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("auc")
            .getter(getter(TFIModelPerformance::auc)).setter(setter(Builder::auc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUC_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float auc;

    private TFIModelPerformance(BuilderImpl builder) {
        this.auc = builder.auc;
    }

    /**
     * <p>
     * The area under the curve (auc). This summarizes the total positive rate (tpr) and false positive rate (FPR)
     * across all possible model score thresholds.
     * </p>
     * 
     * @return The area under the curve (auc). This summarizes the total positive rate (tpr) and false positive rate
     *         (FPR) across all possible model score thresholds.
     */
    public final Float auc() {
        return auc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(auc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TFIModelPerformance)) {
            return false;
        }
        TFIModelPerformance other = (TFIModelPerformance) obj;
        return Objects.equals(auc(), other.auc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TFIModelPerformance").add("Auc", auc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "auc":
            return Optional.ofNullable(clazz.cast(auc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TFIModelPerformance, T> g) {
        return obj -> g.apply((TFIModelPerformance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TFIModelPerformance> {
        /**
         * <p>
         * The area under the curve (auc). This summarizes the total positive rate (tpr) and false positive rate (FPR)
         * across all possible model score thresholds.
         * </p>
         * 
         * @param auc
         *        The area under the curve (auc). This summarizes the total positive rate (tpr) and false positive rate
         *        (FPR) across all possible model score thresholds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auc(Float auc);
    }

    static final class BuilderImpl implements Builder {
        private Float auc;

        private BuilderImpl() {
        }

        private BuilderImpl(TFIModelPerformance model) {
            auc(model.auc);
        }

        public final Float getAuc() {
            return auc;
        }

        public final void setAuc(Float auc) {
            this.auc = auc;
        }

        @Override
        public final Builder auc(Float auc) {
            this.auc = auc;
            return this;
        }

        @Override
        public TFIModelPerformance build() {
            return new TFIModelPerformance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
