/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for the external events data used for model version training.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalEventsDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ExternalEventsDetail.Builder, ExternalEventsDetail> {
    private static final SdkField<String> DATA_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataLocation").getter(getter(ExternalEventsDetail::dataLocation)).setter(setter(Builder::dataLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLocation").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAccessRoleArn").getter(getter(ExternalEventsDetail::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LOCATION_FIELD,
            DATA_ACCESS_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataLocation;

    private final String dataAccessRoleArn;

    private ExternalEventsDetail(BuilderImpl builder) {
        this.dataLocation = builder.dataLocation;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
    }

    /**
     * <p>
     * The Amazon S3 bucket location for the data.
     * </p>
     * 
     * @return The Amazon S3 bucket location for the data.
     */
    public final String dataLocation() {
        return dataLocation;
    }

    /**
     * <p>
     * The ARN of the role that provides Amazon Fraud Detector access to the data location.
     * </p>
     * 
     * @return The ARN of the role that provides Amazon Fraud Detector access to the data location.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalEventsDetail)) {
            return false;
        }
        ExternalEventsDetail other = (ExternalEventsDetail) obj;
        return Objects.equals(dataLocation(), other.dataLocation())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalEventsDetail").add("DataLocation", dataLocation())
                .add("DataAccessRoleArn", dataAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataLocation":
            return Optional.ofNullable(clazz.cast(dataLocation()));
        case "dataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalEventsDetail, T> g) {
        return obj -> g.apply((ExternalEventsDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalEventsDetail> {
        /**
         * <p>
         * The Amazon S3 bucket location for the data.
         * </p>
         * 
         * @param dataLocation
         *        The Amazon S3 bucket location for the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLocation(String dataLocation);

        /**
         * <p>
         * The ARN of the role that provides Amazon Fraud Detector access to the data location.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The ARN of the role that provides Amazon Fraud Detector access to the data location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String dataLocation;

        private String dataAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalEventsDetail model) {
            dataLocation(model.dataLocation);
            dataAccessRoleArn(model.dataAccessRoleArn);
        }

        public final String getDataLocation() {
            return dataLocation;
        }

        public final void setDataLocation(String dataLocation) {
            this.dataLocation = dataLocation;
        }

        @Override
        @Transient
        public final Builder dataLocation(String dataLocation) {
            this.dataLocation = dataLocation;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        @Transient
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        @Override
        public ExternalEventsDetail build() {
            return new ExternalEventsDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
