/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon SageMaker model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalModelSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ExternalModelSummary.Builder, ExternalModelSummary> {
    private static final SdkField<String> MODEL_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelEndpoint").getter(getter(ExternalModelSummary::modelEndpoint))
            .setter(setter(Builder::modelEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpoint").build()).build();

    private static final SdkField<String> MODEL_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelSource").getter(getter(ExternalModelSummary::modelSourceAsString))
            .setter(setter(Builder::modelSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ENDPOINT_FIELD,
            MODEL_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelEndpoint;

    private final String modelSource;

    private ExternalModelSummary(BuilderImpl builder) {
        this.modelEndpoint = builder.modelEndpoint;
        this.modelSource = builder.modelSource;
    }

    /**
     * <p>
     * The endpoint of the Amazon SageMaker model.
     * </p>
     * 
     * @return The endpoint of the Amazon SageMaker model.
     */
    public final String modelEndpoint() {
        return modelEndpoint;
    }

    /**
     * <p>
     * The source of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelSource} will
     * return {@link ModelSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelSourceAsString}.
     * </p>
     * 
     * @return The source of the model.
     * @see ModelSource
     */
    public final ModelSource modelSource() {
        return ModelSource.fromValue(modelSource);
    }

    /**
     * <p>
     * The source of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelSource} will
     * return {@link ModelSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelSourceAsString}.
     * </p>
     * 
     * @return The source of the model.
     * @see ModelSource
     */
    public final String modelSourceAsString() {
        return modelSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(modelSourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalModelSummary)) {
            return false;
        }
        ExternalModelSummary other = (ExternalModelSummary) obj;
        return Objects.equals(modelEndpoint(), other.modelEndpoint())
                && Objects.equals(modelSourceAsString(), other.modelSourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalModelSummary").add("ModelEndpoint", modelEndpoint())
                .add("ModelSource", modelSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelEndpoint":
            return Optional.ofNullable(clazz.cast(modelEndpoint()));
        case "modelSource":
            return Optional.ofNullable(clazz.cast(modelSourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalModelSummary, T> g) {
        return obj -> g.apply((ExternalModelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalModelSummary> {
        /**
         * <p>
         * The endpoint of the Amazon SageMaker model.
         * </p>
         * 
         * @param modelEndpoint
         *        The endpoint of the Amazon SageMaker model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelEndpoint(String modelEndpoint);

        /**
         * <p>
         * The source of the model.
         * </p>
         * 
         * @param modelSource
         *        The source of the model.
         * @see ModelSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelSource
         */
        Builder modelSource(String modelSource);

        /**
         * <p>
         * The source of the model.
         * </p>
         * 
         * @param modelSource
         *        The source of the model.
         * @see ModelSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelSource
         */
        Builder modelSource(ModelSource modelSource);
    }

    static final class BuilderImpl implements Builder {
        private String modelEndpoint;

        private String modelSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalModelSummary model) {
            modelEndpoint(model.modelEndpoint);
            modelSource(model.modelSource);
        }

        public final String getModelEndpoint() {
            return modelEndpoint;
        }

        public final void setModelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
        }

        @Override
        @Transient
        public final Builder modelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
            return this;
        }

        public final String getModelSource() {
            return modelSource;
        }

        public final void setModelSource(String modelSource) {
            this.modelSource = modelSource;
        }

        @Override
        @Transient
        public final Builder modelSource(String modelSource) {
            this.modelSource = modelSource;
            return this;
        }

        @Override
        @Transient
        public final Builder modelSource(ModelSource modelSource) {
            this.modelSource(modelSource == null ? null : modelSource.toString());
            return this;
        }

        @Override
        public ExternalModelSummary build() {
            return new ExternalModelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
