/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEventPredictionRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<GetEventPredictionRequest.Builder, GetEventPredictionRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorId").getter(getter(GetEventPredictionRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorVersionId").getter(getter(GetEventPredictionRequest::detectorVersionId))
            .setter(setter(Builder::detectorVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(GetEventPredictionRequest::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTypeName").getter(getter(GetEventPredictionRequest::eventTypeName))
            .setter(setter(Builder::eventTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()).build();

    private static final SdkField<List<Entity>> ENTITIES_FIELD = SdkField
            .<List<Entity>> builder(MarshallingType.LIST)
            .memberName("entities")
            .getter(getter(GetEventPredictionRequest::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Entity> builder(MarshallingType.SDK_POJO)
                                            .constructor(Entity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EVENT_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTimestamp").getter(getter(GetEventPredictionRequest::eventTimestamp))
            .setter(setter(Builder::eventTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()).build();

    private static final SdkField<Map<String, String>> EVENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("eventVariables")
            .getter(getter(GetEventPredictionRequest::eventVariables))
            .setter(setter(Builder::eventVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ModelEndpointDataBlob>> EXTERNAL_MODEL_ENDPOINT_DATA_BLOBS_FIELD = SdkField
            .<Map<String, ModelEndpointDataBlob>> builder(MarshallingType.MAP)
            .memberName("externalModelEndpointDataBlobs")
            .getter(getter(GetEventPredictionRequest::externalModelEndpointDataBlobs))
            .setter(setter(Builder::externalModelEndpointDataBlobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalModelEndpointDataBlobs")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ModelEndpointDataBlob> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelEndpointDataBlob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            DETECTOR_VERSION_ID_FIELD, EVENT_ID_FIELD, EVENT_TYPE_NAME_FIELD, ENTITIES_FIELD, EVENT_TIMESTAMP_FIELD,
            EVENT_VARIABLES_FIELD, EXTERNAL_MODEL_ENDPOINT_DATA_BLOBS_FIELD));

    private final String detectorId;

    private final String detectorVersionId;

    private final String eventId;

    private final String eventTypeName;

    private final List<Entity> entities;

    private final String eventTimestamp;

    private final Map<String, String> eventVariables;

    private final Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs;

    private GetEventPredictionRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.eventId = builder.eventId;
        this.eventTypeName = builder.eventTypeName;
        this.entities = builder.entities;
        this.eventTimestamp = builder.eventTimestamp;
        this.eventVariables = builder.eventVariables;
        this.externalModelEndpointDataBlobs = builder.externalModelEndpointDataBlobs;
    }

    /**
     * <p>
     * The detector ID.
     * </p>
     * 
     * @return The detector ID.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The detector version ID.
     * </p>
     * 
     * @return The detector version ID.
     */
    public final String detectorVersionId() {
        return detectorVersionId;
    }

    /**
     * <p>
     * The unique ID used to identify the event.
     * </p>
     * 
     * @return The unique ID used to identify the event.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The event type associated with the detector specified for the prediction.
     * </p>
     * 
     * @return The event type associated with the detector specified for the prediction.
     */
    public final String eventTypeName() {
        return eventTypeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The entity type (associated with the detector's event type) and specific entity ID representing who performed the
     * event. If an entity id is not available, use "UNKNOWN."
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return The entity type (associated with the detector's event type) and specific entity ID representing who
     *         performed the event. If an entity id is not available, use "UNKNOWN."
     */
    public final List<Entity> entities() {
        return entities;
    }

    /**
     * <p>
     * Timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO 8601
     * standard in UTC.
     * </p>
     * 
     * @return Timestamp that defines when the event under evaluation occurred. The timestamp must be specified using
     *         ISO 8601 standard in UTC.
     */
    public final String eventTimestamp() {
        return eventTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventVariables() {
        return eventVariables != null && !(eventVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their
     * corresponding values for the event you are sending for evaluation.
     * </p>
     * <important>
     * <p>
     * You must provide at least one eventVariable
     * </p>
     * </important>
     * <p>
     * To ensure most accurate fraud prediction and to simplify your data preparation, Amazon Fraud Detector will
     * replace all missing variables or values as follows:
     * </p>
     * <p>
     * <b>For Amazon Fraud Detector trained models:</b>
     * </p>
     * <p>
     * If a null value is provided explicitly for a variable or if a variable is missing, model will replace the null
     * value or the missing variable (no variable name in the eventVariables map) with calculated default mean/medians
     * for numeric variables and with special values for categorical variables.
     * </p>
     * <p>
     * <b>For imported SageMaker models:</b>
     * </p>
     * <p>
     * If a null value is provided explicitly for a variable, the model and rules will use “null” as the value. If a
     * variable is not provided (no variable name in the eventVariables map), model and rules will use the default value
     * that is provided for the variable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventVariables} method.
     * </p>
     * 
     * @return Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and
     *         their corresponding values for the event you are sending for evaluation.</p> <important>
     *         <p>
     *         You must provide at least one eventVariable
     *         </p>
     *         </important>
     *         <p>
     *         To ensure most accurate fraud prediction and to simplify your data preparation, Amazon Fraud Detector
     *         will replace all missing variables or values as follows:
     *         </p>
     *         <p>
     *         <b>For Amazon Fraud Detector trained models:</b>
     *         </p>
     *         <p>
     *         If a null value is provided explicitly for a variable or if a variable is missing, model will replace the
     *         null value or the missing variable (no variable name in the eventVariables map) with calculated default
     *         mean/medians for numeric variables and with special values for categorical variables.
     *         </p>
     *         <p>
     *         <b>For imported SageMaker models:</b>
     *         </p>
     *         <p>
     *         If a null value is provided explicitly for a variable, the model and rules will use “null” as the value.
     *         If a variable is not provided (no variable name in the eventVariables map), model and rules will use the
     *         default value that is provided for the variable.
     */
    public final Map<String, String> eventVariables() {
        return eventVariables;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExternalModelEndpointDataBlobs property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExternalModelEndpointDataBlobs() {
        return externalModelEndpointDataBlobs != null && !(externalModelEndpointDataBlobs instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Amazon SageMaker model endpoint input data blobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExternalModelEndpointDataBlobs} method.
     * </p>
     * 
     * @return The Amazon SageMaker model endpoint input data blobs.
     */
    public final Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs() {
        return externalModelEndpointDataBlobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventVariables() ? eventVariables() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasExternalModelEndpointDataBlobs() ? externalModelEndpointDataBlobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventPredictionRequest)) {
            return false;
        }
        GetEventPredictionRequest other = (GetEventPredictionRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(detectorVersionId(), other.detectorVersionId())
                && Objects.equals(eventId(), other.eventId()) && Objects.equals(eventTypeName(), other.eventTypeName())
                && hasEntities() == other.hasEntities() && Objects.equals(entities(), other.entities())
                && Objects.equals(eventTimestamp(), other.eventTimestamp()) && hasEventVariables() == other.hasEventVariables()
                && Objects.equals(eventVariables(), other.eventVariables())
                && hasExternalModelEndpointDataBlobs() == other.hasExternalModelEndpointDataBlobs()
                && Objects.equals(externalModelEndpointDataBlobs(), other.externalModelEndpointDataBlobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetEventPredictionRequest")
                .add("DetectorId", detectorId())
                .add("DetectorVersionId", detectorVersionId())
                .add("EventId", eventId())
                .add("EventTypeName", eventTypeName())
                .add("Entities", entities() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EventTimestamp", eventTimestamp())
                .add("EventVariables", eventVariables() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExternalModelEndpointDataBlobs",
                        externalModelEndpointDataBlobs() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "detectorVersionId":
            return Optional.ofNullable(clazz.cast(detectorVersionId()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "eventTypeName":
            return Optional.ofNullable(clazz.cast(eventTypeName()));
        case "entities":
            return Optional.ofNullable(clazz.cast(entities()));
        case "eventTimestamp":
            return Optional.ofNullable(clazz.cast(eventTimestamp()));
        case "eventVariables":
            return Optional.ofNullable(clazz.cast(eventVariables()));
        case "externalModelEndpointDataBlobs":
            return Optional.ofNullable(clazz.cast(externalModelEndpointDataBlobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEventPredictionRequest, T> g) {
        return obj -> g.apply((GetEventPredictionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetEventPredictionRequest> {
        /**
         * <p>
         * The detector ID.
         * </p>
         * 
         * @param detectorId
         *        The detector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The detector version ID.
         * </p>
         * 
         * @param detectorVersionId
         *        The detector version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorVersionId(String detectorVersionId);

        /**
         * <p>
         * The unique ID used to identify the event.
         * </p>
         * 
         * @param eventId
         *        The unique ID used to identify the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The event type associated with the detector specified for the prediction.
         * </p>
         * 
         * @param eventTypeName
         *        The event type associated with the detector specified for the prediction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeName(String eventTypeName);

        /**
         * <p>
         * The entity type (associated with the detector's event type) and specific entity ID representing who performed
         * the event. If an entity id is not available, use "UNKNOWN."
         * </p>
         * 
         * @param entities
         *        The entity type (associated with the detector's event type) and specific entity ID representing who
         *        performed the event. If an entity id is not available, use "UNKNOWN."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<Entity> entities);

        /**
         * <p>
         * The entity type (associated with the detector's event type) and specific entity ID representing who performed
         * the event. If an entity id is not available, use "UNKNOWN."
         * </p>
         * 
         * @param entities
         *        The entity type (associated with the detector's event type) and specific entity ID representing who
         *        performed the event. If an entity id is not available, use "UNKNOWN."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Entity... entities);

        /**
         * <p>
         * The entity type (associated with the detector's event type) and specific entity ID representing who performed
         * the event. If an entity id is not available, use "UNKNOWN."
         * </p>
         * This is a convenience that creates an instance of the {@link List<Entity>.Builder} avoiding the need to
         * create one manually via {@link List<Entity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Entity>.Builder#build()} is called immediately and its
         * result is passed to {@link #entities(List<Entity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on {@link List<Entity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(List<Entity>)
         */
        Builder entities(Consumer<Entity.Builder>... entities);

        /**
         * <p>
         * Timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO
         * 8601 standard in UTC.
         * </p>
         * 
         * @param eventTimestamp
         *        Timestamp that defines when the event under evaluation occurred. The timestamp must be specified using
         *        ISO 8601 standard in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestamp(String eventTimestamp);

        /**
         * <p>
         * Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their
         * corresponding values for the event you are sending for evaluation.
         * </p>
         * <important>
         * <p>
         * You must provide at least one eventVariable
         * </p>
         * </important>
         * <p>
         * To ensure most accurate fraud prediction and to simplify your data preparation, Amazon Fraud Detector will
         * replace all missing variables or values as follows:
         * </p>
         * <p>
         * <b>For Amazon Fraud Detector trained models:</b>
         * </p>
         * <p>
         * If a null value is provided explicitly for a variable or if a variable is missing, model will replace the
         * null value or the missing variable (no variable name in the eventVariables map) with calculated default
         * mean/medians for numeric variables and with special values for categorical variables.
         * </p>
         * <p>
         * <b>For imported SageMaker models:</b>
         * </p>
         * <p>
         * If a null value is provided explicitly for a variable, the model and rules will use “null” as the value. If a
         * variable is not provided (no variable name in the eventVariables map), model and rules will use the default
         * value that is provided for the variable.
         * </p>
         * 
         * @param eventVariables
         *        Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements
         *        and their corresponding values for the event you are sending for evaluation.</p> <important>
         *        <p>
         *        You must provide at least one eventVariable
         *        </p>
         *        </important>
         *        <p>
         *        To ensure most accurate fraud prediction and to simplify your data preparation, Amazon Fraud Detector
         *        will replace all missing variables or values as follows:
         *        </p>
         *        <p>
         *        <b>For Amazon Fraud Detector trained models:</b>
         *        </p>
         *        <p>
         *        If a null value is provided explicitly for a variable or if a variable is missing, model will replace
         *        the null value or the missing variable (no variable name in the eventVariables map) with calculated
         *        default mean/medians for numeric variables and with special values for categorical variables.
         *        </p>
         *        <p>
         *        <b>For imported SageMaker models:</b>
         *        </p>
         *        <p>
         *        If a null value is provided explicitly for a variable, the model and rules will use “null” as the
         *        value. If a variable is not provided (no variable name in the eventVariables map), model and rules
         *        will use the default value that is provided for the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventVariables(Map<String, String> eventVariables);

        /**
         * <p>
         * The Amazon SageMaker model endpoint input data blobs.
         * </p>
         * 
         * @param externalModelEndpointDataBlobs
         *        The Amazon SageMaker model endpoint input data blobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalModelEndpointDataBlobs(Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String detectorVersionId;

        private String eventId;

        private String eventTypeName;

        private List<Entity> entities = DefaultSdkAutoConstructList.getInstance();

        private String eventTimestamp;

        private Map<String, String> eventVariables = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventPredictionRequest model) {
            super(model);
            detectorId(model.detectorId);
            detectorVersionId(model.detectorVersionId);
            eventId(model.eventId);
            eventTypeName(model.eventTypeName);
            entities(model.entities);
            eventTimestamp(model.eventTimestamp);
            eventVariables(model.eventVariables);
            externalModelEndpointDataBlobs(model.externalModelEndpointDataBlobs);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        @Transient
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDetectorVersionId() {
            return detectorVersionId;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        @Override
        @Transient
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        @Transient
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventTypeName() {
            return eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        @Transient
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final List<Entity.Builder> getEntities() {
            List<Entity.Builder> result = _listOfEntitiesCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<Entity.BuilderImpl> entities) {
            this.entities = _listOfEntitiesCopier.copyFromBuilder(entities);
        }

        @Override
        @Transient
        public final Builder entities(Collection<Entity> entities) {
            this.entities = _listOfEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entities(Entity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entities(Consumer<Entity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> Entity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEventTimestamp() {
            return eventTimestamp;
        }

        public final void setEventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        @Transient
        public final Builder eventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final Map<String, String> getEventVariables() {
            if (eventVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return eventVariables;
        }

        public final void setEventVariables(Map<String, String> eventVariables) {
            this.eventVariables = EventVariableMapCopier.copy(eventVariables);
        }

        @Override
        @Transient
        public final Builder eventVariables(Map<String, String> eventVariables) {
            this.eventVariables = EventVariableMapCopier.copy(eventVariables);
            return this;
        }

        public final Map<String, ModelEndpointDataBlob.Builder> getExternalModelEndpointDataBlobs() {
            Map<String, ModelEndpointDataBlob.Builder> result = ExternalModelEndpointDataBlobMapCopier
                    .copyToBuilder(this.externalModelEndpointDataBlobs);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExternalModelEndpointDataBlobs(
                Map<String, ModelEndpointDataBlob.BuilderImpl> externalModelEndpointDataBlobs) {
            this.externalModelEndpointDataBlobs = ExternalModelEndpointDataBlobMapCopier
                    .copyFromBuilder(externalModelEndpointDataBlobs);
        }

        @Override
        @Transient
        public final Builder externalModelEndpointDataBlobs(Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs) {
            this.externalModelEndpointDataBlobs = ExternalModelEndpointDataBlobMapCopier.copy(externalModelEndpointDataBlobs);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEventPredictionRequest build() {
            return new GetEventPredictionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
