/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data about the stored events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngestedEventStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<IngestedEventStatistics.Builder, IngestedEventStatistics> {
    private static final SdkField<Long> NUMBER_OF_EVENTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numberOfEvents").getter(getter(IngestedEventStatistics::numberOfEvents))
            .setter(setter(Builder::numberOfEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfEvents").build()).build();

    private static final SdkField<Long> EVENT_DATA_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("eventDataSizeInBytes").getter(getter(IngestedEventStatistics::eventDataSizeInBytes))
            .setter(setter(Builder::eventDataSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDataSizeInBytes").build())
            .build();

    private static final SdkField<String> LEAST_RECENT_EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("leastRecentEvent").getter(getter(IngestedEventStatistics::leastRecentEvent))
            .setter(setter(Builder::leastRecentEvent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("leastRecentEvent").build()).build();

    private static final SdkField<String> MOST_RECENT_EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mostRecentEvent").getter(getter(IngestedEventStatistics::mostRecentEvent))
            .setter(setter(Builder::mostRecentEvent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mostRecentEvent").build()).build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedTime").getter(getter(IngestedEventStatistics::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_EVENTS_FIELD,
            EVENT_DATA_SIZE_IN_BYTES_FIELD, LEAST_RECENT_EVENT_FIELD, MOST_RECENT_EVENT_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long numberOfEvents;

    private final Long eventDataSizeInBytes;

    private final String leastRecentEvent;

    private final String mostRecentEvent;

    private final String lastUpdatedTime;

    private IngestedEventStatistics(BuilderImpl builder) {
        this.numberOfEvents = builder.numberOfEvents;
        this.eventDataSizeInBytes = builder.eventDataSizeInBytes;
        this.leastRecentEvent = builder.leastRecentEvent;
        this.mostRecentEvent = builder.mostRecentEvent;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The number of stored events.
     * </p>
     * 
     * @return The number of stored events.
     */
    public final Long numberOfEvents() {
        return numberOfEvents;
    }

    /**
     * <p>
     * The total size of the stored events.
     * </p>
     * 
     * @return The total size of the stored events.
     */
    public final Long eventDataSizeInBytes() {
        return eventDataSizeInBytes;
    }

    /**
     * <p>
     * The oldest stored event.
     * </p>
     * 
     * @return The oldest stored event.
     */
    public final String leastRecentEvent() {
        return leastRecentEvent;
    }

    /**
     * <p>
     * The newest stored event.
     * </p>
     * 
     * @return The newest stored event.
     */
    public final String mostRecentEvent() {
        return mostRecentEvent;
    }

    /**
     * <p>
     * Timestamp of when the stored event was last updated.
     * </p>
     * 
     * @return Timestamp of when the stored event was last updated.
     */
    public final String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfEvents());
        hashCode = 31 * hashCode + Objects.hashCode(eventDataSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(leastRecentEvent());
        hashCode = 31 * hashCode + Objects.hashCode(mostRecentEvent());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestedEventStatistics)) {
            return false;
        }
        IngestedEventStatistics other = (IngestedEventStatistics) obj;
        return Objects.equals(numberOfEvents(), other.numberOfEvents())
                && Objects.equals(eventDataSizeInBytes(), other.eventDataSizeInBytes())
                && Objects.equals(leastRecentEvent(), other.leastRecentEvent())
                && Objects.equals(mostRecentEvent(), other.mostRecentEvent())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngestedEventStatistics").add("NumberOfEvents", numberOfEvents())
                .add("EventDataSizeInBytes", eventDataSizeInBytes()).add("LeastRecentEvent", leastRecentEvent())
                .add("MostRecentEvent", mostRecentEvent()).add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "numberOfEvents":
            return Optional.ofNullable(clazz.cast(numberOfEvents()));
        case "eventDataSizeInBytes":
            return Optional.ofNullable(clazz.cast(eventDataSizeInBytes()));
        case "leastRecentEvent":
            return Optional.ofNullable(clazz.cast(leastRecentEvent()));
        case "mostRecentEvent":
            return Optional.ofNullable(clazz.cast(mostRecentEvent()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngestedEventStatistics, T> g) {
        return obj -> g.apply((IngestedEventStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngestedEventStatistics> {
        /**
         * <p>
         * The number of stored events.
         * </p>
         * 
         * @param numberOfEvents
         *        The number of stored events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfEvents(Long numberOfEvents);

        /**
         * <p>
         * The total size of the stored events.
         * </p>
         * 
         * @param eventDataSizeInBytes
         *        The total size of the stored events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataSizeInBytes(Long eventDataSizeInBytes);

        /**
         * <p>
         * The oldest stored event.
         * </p>
         * 
         * @param leastRecentEvent
         *        The oldest stored event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leastRecentEvent(String leastRecentEvent);

        /**
         * <p>
         * The newest stored event.
         * </p>
         * 
         * @param mostRecentEvent
         *        The newest stored event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mostRecentEvent(String mostRecentEvent);

        /**
         * <p>
         * Timestamp of when the stored event was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        Timestamp of when the stored event was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private Long numberOfEvents;

        private Long eventDataSizeInBytes;

        private String leastRecentEvent;

        private String mostRecentEvent;

        private String lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestedEventStatistics model) {
            numberOfEvents(model.numberOfEvents);
            eventDataSizeInBytes(model.eventDataSizeInBytes);
            leastRecentEvent(model.leastRecentEvent);
            mostRecentEvent(model.mostRecentEvent);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final Long getNumberOfEvents() {
            return numberOfEvents;
        }

        public final void setNumberOfEvents(Long numberOfEvents) {
            this.numberOfEvents = numberOfEvents;
        }

        @Override
        @Transient
        public final Builder numberOfEvents(Long numberOfEvents) {
            this.numberOfEvents = numberOfEvents;
            return this;
        }

        public final Long getEventDataSizeInBytes() {
            return eventDataSizeInBytes;
        }

        public final void setEventDataSizeInBytes(Long eventDataSizeInBytes) {
            this.eventDataSizeInBytes = eventDataSizeInBytes;
        }

        @Override
        @Transient
        public final Builder eventDataSizeInBytes(Long eventDataSizeInBytes) {
            this.eventDataSizeInBytes = eventDataSizeInBytes;
            return this;
        }

        public final String getLeastRecentEvent() {
            return leastRecentEvent;
        }

        public final void setLeastRecentEvent(String leastRecentEvent) {
            this.leastRecentEvent = leastRecentEvent;
        }

        @Override
        @Transient
        public final Builder leastRecentEvent(String leastRecentEvent) {
            this.leastRecentEvent = leastRecentEvent;
            return this;
        }

        public final String getMostRecentEvent() {
            return mostRecentEvent;
        }

        public final void setMostRecentEvent(String mostRecentEvent) {
            this.mostRecentEvent = mostRecentEvent;
        }

        @Override
        @Transient
        public final Builder mostRecentEvent(String mostRecentEvent) {
            this.mostRecentEvent = mostRecentEvent;
            return this;
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public IngestedEventStatistics build() {
            return new IngestedEventStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
