/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the ingested event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngestedEventsDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<IngestedEventsDetail.Builder, IngestedEventsDetail> {
    private static final SdkField<IngestedEventsTimeWindow> INGESTED_EVENTS_TIME_WINDOW_FIELD = SdkField
            .<IngestedEventsTimeWindow> builder(MarshallingType.SDK_POJO).memberName("ingestedEventsTimeWindow")
            .getter(getter(IngestedEventsDetail::ingestedEventsTimeWindow)).setter(setter(Builder::ingestedEventsTimeWindow))
            .constructor(IngestedEventsTimeWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestedEventsTimeWindow").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INGESTED_EVENTS_TIME_WINDOW_FIELD));

    private static final long serialVersionUID = 1L;

    private final IngestedEventsTimeWindow ingestedEventsTimeWindow;

    private IngestedEventsDetail(BuilderImpl builder) {
        this.ingestedEventsTimeWindow = builder.ingestedEventsTimeWindow;
    }

    /**
     * <p>
     * The start and stop time of the ingested events.
     * </p>
     * 
     * @return The start and stop time of the ingested events.
     */
    public final IngestedEventsTimeWindow ingestedEventsTimeWindow() {
        return ingestedEventsTimeWindow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ingestedEventsTimeWindow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestedEventsDetail)) {
            return false;
        }
        IngestedEventsDetail other = (IngestedEventsDetail) obj;
        return Objects.equals(ingestedEventsTimeWindow(), other.ingestedEventsTimeWindow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngestedEventsDetail").add("IngestedEventsTimeWindow", ingestedEventsTimeWindow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ingestedEventsTimeWindow":
            return Optional.ofNullable(clazz.cast(ingestedEventsTimeWindow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngestedEventsDetail, T> g) {
        return obj -> g.apply((IngestedEventsDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngestedEventsDetail> {
        /**
         * <p>
         * The start and stop time of the ingested events.
         * </p>
         * 
         * @param ingestedEventsTimeWindow
         *        The start and stop time of the ingested events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestedEventsTimeWindow(IngestedEventsTimeWindow ingestedEventsTimeWindow);

        /**
         * <p>
         * The start and stop time of the ingested events.
         * </p>
         * This is a convenience that creates an instance of the {@link IngestedEventsTimeWindow.Builder} avoiding the
         * need to create one manually via {@link IngestedEventsTimeWindow#builder()}.
         *
         * When the {@link Consumer} completes, {@link IngestedEventsTimeWindow.Builder#build()} is called immediately
         * and its result is passed to {@link #ingestedEventsTimeWindow(IngestedEventsTimeWindow)}.
         * 
         * @param ingestedEventsTimeWindow
         *        a consumer that will call methods on {@link IngestedEventsTimeWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestedEventsTimeWindow(IngestedEventsTimeWindow)
         */
        default Builder ingestedEventsTimeWindow(Consumer<IngestedEventsTimeWindow.Builder> ingestedEventsTimeWindow) {
            return ingestedEventsTimeWindow(IngestedEventsTimeWindow.builder().applyMutation(ingestedEventsTimeWindow).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IngestedEventsTimeWindow ingestedEventsTimeWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestedEventsDetail model) {
            ingestedEventsTimeWindow(model.ingestedEventsTimeWindow);
        }

        public final IngestedEventsTimeWindow.Builder getIngestedEventsTimeWindow() {
            return ingestedEventsTimeWindow != null ? ingestedEventsTimeWindow.toBuilder() : null;
        }

        public final void setIngestedEventsTimeWindow(IngestedEventsTimeWindow.BuilderImpl ingestedEventsTimeWindow) {
            this.ingestedEventsTimeWindow = ingestedEventsTimeWindow != null ? ingestedEventsTimeWindow.build() : null;
        }

        @Override
        @Transient
        public final Builder ingestedEventsTimeWindow(IngestedEventsTimeWindow ingestedEventsTimeWindow) {
            this.ingestedEventsTimeWindow = ingestedEventsTimeWindow;
            return this;
        }

        @Override
        public IngestedEventsDetail build() {
            return new IngestedEventsDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
