/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The log odds metric details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogOddsMetric implements SdkPojo, Serializable, ToCopyableBuilder<LogOddsMetric.Builder, LogOddsMetric> {
    private static final SdkField<String> VARIABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("variableName").getter(getter(LogOddsMetric::variableName)).setter(setter(Builder::variableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableName").build()).build();

    private static final SdkField<String> VARIABLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("variableType").getter(getter(LogOddsMetric::variableType)).setter(setter(Builder::variableType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableType").build()).build();

    private static final SdkField<Float> VARIABLE_IMPORTANCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("variableImportance").getter(getter(LogOddsMetric::variableImportance))
            .setter(setter(Builder::variableImportance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableImportance").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLE_NAME_FIELD,
            VARIABLE_TYPE_FIELD, VARIABLE_IMPORTANCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String variableName;

    private final String variableType;

    private final Float variableImportance;

    private LogOddsMetric(BuilderImpl builder) {
        this.variableName = builder.variableName;
        this.variableType = builder.variableType;
        this.variableImportance = builder.variableImportance;
    }

    /**
     * <p>
     * The name of the variable.
     * </p>
     * 
     * @return The name of the variable.
     */
    public final String variableName() {
        return variableName;
    }

    /**
     * <p>
     * The type of variable.
     * </p>
     * 
     * @return The type of variable.
     */
    public final String variableType() {
        return variableType;
    }

    /**
     * <p>
     * The relative importance of the variable. For more information, see <a
     * href="https://docs.aws.amazon.com/frauddetector/latest/ug/model-variable-importance.html">Model variable
     * importance</a>.
     * </p>
     * 
     * @return The relative importance of the variable. For more information, see <a
     *         href="https://docs.aws.amazon.com/frauddetector/latest/ug/model-variable-importance.html">Model variable
     *         importance</a>.
     */
    public final Float variableImportance() {
        return variableImportance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(variableName());
        hashCode = 31 * hashCode + Objects.hashCode(variableType());
        hashCode = 31 * hashCode + Objects.hashCode(variableImportance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogOddsMetric)) {
            return false;
        }
        LogOddsMetric other = (LogOddsMetric) obj;
        return Objects.equals(variableName(), other.variableName()) && Objects.equals(variableType(), other.variableType())
                && Objects.equals(variableImportance(), other.variableImportance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogOddsMetric").add("VariableName", variableName()).add("VariableType", variableType())
                .add("VariableImportance", variableImportance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "variableName":
            return Optional.ofNullable(clazz.cast(variableName()));
        case "variableType":
            return Optional.ofNullable(clazz.cast(variableType()));
        case "variableImportance":
            return Optional.ofNullable(clazz.cast(variableImportance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogOddsMetric, T> g) {
        return obj -> g.apply((LogOddsMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogOddsMetric> {
        /**
         * <p>
         * The name of the variable.
         * </p>
         * 
         * @param variableName
         *        The name of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableName(String variableName);

        /**
         * <p>
         * The type of variable.
         * </p>
         * 
         * @param variableType
         *        The type of variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableType(String variableType);

        /**
         * <p>
         * The relative importance of the variable. For more information, see <a
         * href="https://docs.aws.amazon.com/frauddetector/latest/ug/model-variable-importance.html">Model variable
         * importance</a>.
         * </p>
         * 
         * @param variableImportance
         *        The relative importance of the variable. For more information, see <a
         *        href="https://docs.aws.amazon.com/frauddetector/latest/ug/model-variable-importance.html">Model
         *        variable importance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableImportance(Float variableImportance);
    }

    static final class BuilderImpl implements Builder {
        private String variableName;

        private String variableType;

        private Float variableImportance;

        private BuilderImpl() {
        }

        private BuilderImpl(LogOddsMetric model) {
            variableName(model.variableName);
            variableType(model.variableType);
            variableImportance(model.variableImportance);
        }

        public final String getVariableName() {
            return variableName;
        }

        public final void setVariableName(String variableName) {
            this.variableName = variableName;
        }

        @Override
        @Transient
        public final Builder variableName(String variableName) {
            this.variableName = variableName;
            return this;
        }

        public final String getVariableType() {
            return variableType;
        }

        public final void setVariableType(String variableType) {
            this.variableType = variableType;
        }

        @Override
        @Transient
        public final Builder variableType(String variableType) {
            this.variableType = variableType;
            return this;
        }

        public final Float getVariableImportance() {
            return variableImportance;
        }

        public final void setVariableImportance(Float variableImportance) {
            this.variableImportance = variableImportance;
        }

        @Override
        @Transient
        public final Builder variableImportance(Float variableImportance) {
            this.variableImportance = variableImportance;
            return this;
        }

        @Override
        public LogOddsMetric build() {
            return new LogOddsMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
