/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The rule results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleResult implements SdkPojo, Serializable, ToCopyableBuilder<RuleResult.Builder, RuleResult> {
    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ruleId")
            .getter(getter(RuleResult::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()).build();

    private static final SdkField<List<String>> OUTCOMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("outcomes")
            .getter(getter(RuleResult::outcomes))
            .setter(setter(Builder::outcomes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(RULE_ID_FIELD, OUTCOMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleId;

    private final List<String> outcomes;

    private RuleResult(BuilderImpl builder) {
        this.ruleId = builder.ruleId;
        this.outcomes = builder.outcomes;
    }

    /**
     * <p>
     * The rule ID that was matched, based on the rule execution mode.
     * </p>
     * 
     * @return The rule ID that was matched, based on the rule execution mode.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outcomes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutcomes() {
        return outcomes != null && !(outcomes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outcomes of the matched rule, based on the rule execution mode.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutcomes} method.
     * </p>
     * 
     * @return The outcomes of the matched rule, based on the rule execution mode.
     */
    public final List<String> outcomes() {
        return outcomes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutcomes() ? outcomes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleResult)) {
            return false;
        }
        RuleResult other = (RuleResult) obj;
        return Objects.equals(ruleId(), other.ruleId()) && hasOutcomes() == other.hasOutcomes()
                && Objects.equals(outcomes(), other.outcomes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleResult").add("RuleId", ruleId()).add("Outcomes", hasOutcomes() ? outcomes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "outcomes":
            return Optional.ofNullable(clazz.cast(outcomes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleResult, T> g) {
        return obj -> g.apply((RuleResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleResult> {
        /**
         * <p>
         * The rule ID that was matched, based on the rule execution mode.
         * </p>
         * 
         * @param ruleId
         *        The rule ID that was matched, based on the rule execution mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The outcomes of the matched rule, based on the rule execution mode.
         * </p>
         * 
         * @param outcomes
         *        The outcomes of the matched rule, based on the rule execution mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomes(Collection<String> outcomes);

        /**
         * <p>
         * The outcomes of the matched rule, based on the rule execution mode.
         * </p>
         * 
         * @param outcomes
         *        The outcomes of the matched rule, based on the rule execution mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomes(String... outcomes);
    }

    static final class BuilderImpl implements Builder {
        private String ruleId;

        private List<String> outcomes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleResult model) {
            ruleId(model.ruleId);
            outcomes(model.outcomes);
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        @Transient
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final Collection<String> getOutcomes() {
            if (outcomes instanceof SdkAutoConstructList) {
                return null;
            }
            return outcomes;
        }

        public final void setOutcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
        }

        @Override
        @Transient
        public final Builder outcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outcomes(String... outcomes) {
            outcomes(Arrays.asList(outcomes));
            return this;
        }

        @Override
        public RuleResult build() {
            return new RuleResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
