/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVariableRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<UpdateVariableRequest.Builder, UpdateVariableRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateVariableRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultValue").getter(getter(UpdateVariableRequest::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateVariableRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> VARIABLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("variableType").getter(getter(UpdateVariableRequest::variableType)).setter(setter(Builder::variableType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DEFAULT_VALUE_FIELD, DESCRIPTION_FIELD, VARIABLE_TYPE_FIELD));

    private final String name;

    private final String defaultValue;

    private final String description;

    private final String variableType;

    private UpdateVariableRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
        this.variableType = builder.variableType;
    }

    /**
     * <p>
     * The name of the variable.
     * </p>
     * 
     * @return The name of the variable.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The new default value of the variable.
     * </p>
     * 
     * @return The new default value of the variable.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The new description.
     * </p>
     * 
     * @return The new description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The variable type. For more information see <a
     * href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable
     * types</a>.
     * </p>
     * 
     * @return The variable type. For more information see <a
     *         href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable
     *         types</a>.
     */
    public final String variableType() {
        return variableType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(variableType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVariableRequest)) {
            return false;
        }
        UpdateVariableRequest other = (UpdateVariableRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(description(), other.description()) && Objects.equals(variableType(), other.variableType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVariableRequest").add("Name", name()).add("DefaultValue", defaultValue())
                .add("Description", description()).add("VariableType", variableType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "variableType":
            return Optional.ofNullable(clazz.cast(variableType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVariableRequest, T> g) {
        return obj -> g.apply((UpdateVariableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVariableRequest> {
        /**
         * <p>
         * The name of the variable.
         * </p>
         * 
         * @param name
         *        The name of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new default value of the variable.
         * </p>
         * 
         * @param defaultValue
         *        The new default value of the variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The new description.
         * </p>
         * 
         * @param description
         *        The new description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The variable type. For more information see <a
         * href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types">Variable
         * types</a>.
         * </p>
         * 
         * @param variableType
         *        The variable type. For more information see <a
         *        href="https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types"
         *        >Variable types</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableType(String variableType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String name;

        private String defaultValue;

        private String description;

        private String variableType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVariableRequest model) {
            super(model);
            name(model.name);
            defaultValue(model.defaultValue);
            description(model.description);
            variableType(model.variableType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        @Transient
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVariableType() {
            return variableType;
        }

        public final void setVariableType(String variableType) {
            this.variableType = variableType;
        }

        @Override
        @Transient
        public final Builder variableType(String variableType) {
            this.variableType = variableType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVariableRequest build() {
            return new UpdateVariableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
