/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event orchestration status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventOrchestration implements SdkPojo, Serializable,
        ToCopyableBuilder<EventOrchestration.Builder, EventOrchestration> {
    private static final SdkField<Boolean> EVENT_BRIDGE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("eventBridgeEnabled").getter(getter(EventOrchestration::eventBridgeEnabled))
            .setter(setter(Builder::eventBridgeEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventBridgeEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_BRIDGE_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean eventBridgeEnabled;

    private EventOrchestration(BuilderImpl builder) {
        this.eventBridgeEnabled = builder.eventBridgeEnabled;
    }

    /**
     * <p>
     * Specifies if event orchestration is enabled through Amazon EventBridge.
     * </p>
     * 
     * @return Specifies if event orchestration is enabled through Amazon EventBridge.
     */
    public final Boolean eventBridgeEnabled() {
        return eventBridgeEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventBridgeEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventOrchestration)) {
            return false;
        }
        EventOrchestration other = (EventOrchestration) obj;
        return Objects.equals(eventBridgeEnabled(), other.eventBridgeEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventOrchestration").add("EventBridgeEnabled", eventBridgeEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventBridgeEnabled":
            return Optional.ofNullable(clazz.cast(eventBridgeEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventOrchestration, T> g) {
        return obj -> g.apply((EventOrchestration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventOrchestration> {
        /**
         * <p>
         * Specifies if event orchestration is enabled through Amazon EventBridge.
         * </p>
         * 
         * @param eventBridgeEnabled
         *        Specifies if event orchestration is enabled through Amazon EventBridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeEnabled(Boolean eventBridgeEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean eventBridgeEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(EventOrchestration model) {
            eventBridgeEnabled(model.eventBridgeEnabled);
        }

        public final Boolean getEventBridgeEnabled() {
            return eventBridgeEnabled;
        }

        public final void setEventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
        }

        @Override
        public final Builder eventBridgeEnabled(Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
            return this;
        }

        @Override
        public EventOrchestration build() {
            return new EventOrchestration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
